/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ShortBuffer;
import java.util.Iterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainerShortIterator;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.ReverseMappeableArrayContainerShortIterator;

public final class MappeableArrayContainer
extends MappeableContainer
implements Cloneable,
Serializable {
    private static final int DEFAULT_INIT_SIZE = 4;
    protected static final int DEFAULT_MAX_SIZE = 4096;
    private static final long serialVersionUID = 1L;
    protected int cardinality = 0;
    protected ShortBuffer content;

    public MappeableArrayContainer() {
        this(4);
    }

    public MappeableArrayContainer(int capacity) {
        this.content = ShortBuffer.allocate(capacity);
    }

    public MappeableArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun + 1;
        this.content = ShortBuffer.allocate(valuesInRange);
        short[] sarray = this.content.array();
        for (int i = 0; i < valuesInRange; ++i) {
            sarray[i] = (short)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    private MappeableArrayContainer(int newCard, ShortBuffer newContent) {
        this.cardinality = newCard;
        this.content = ShortBuffer.allocate(newContent.limit());
        newContent.rewind();
        this.content.put(newContent);
    }

    public MappeableArrayContainer(ShortBuffer array, int cardinality) {
        if (array.limit() != cardinality) {
            throw new RuntimeException("Mismatch between buffer and cardinality");
        }
        this.cardinality = cardinality;
        this.content = array;
    }

    @Override
    public MappeableContainer add(short x) {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] sarray = this.content.array();
            int loc = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= 4096) {
                    MappeableBitmapContainer a = this.toBitmapContainer();
                    a.add(x);
                    return a;
                }
                if (this.cardinality >= sarray.length) {
                    this.increaseCapacity();
                    sarray = this.content.array();
                }
                System.arraycopy(sarray, -loc - 1, sarray, -loc, this.cardinality + loc + 1);
                sarray[-loc - 1] = x;
                ++this.cardinality;
            }
        } else {
            int loc = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= 4096) {
                    MappeableBitmapContainer a = this.toBitmapContainer();
                    a.add(x);
                    return a;
                }
                if (this.cardinality >= this.content.limit()) {
                    this.increaseCapacity();
                }
                for (int k = this.cardinality; k > -loc - 1; --k) {
                    this.content.put(k, this.content.get(k - 1));
                }
                this.content.put(-loc - 1, x);
                ++this.cardinality;
            }
        }
        return this;
    }

    @Override
    public MappeableArrayContainer and(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int desiredCapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        MappeableArrayContainer answer = new MappeableArrayContainer(desiredCapacity);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(this.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedIntersect2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableContainer and(MappeableBitmapContainer x) {
        return x.and(this);
    }

    @Override
    public MappeableArrayContainer andNot(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int desiredCapacity = value1.getCardinality();
        MappeableArrayContainer answer = new MappeableArrayContainer(desiredCapacity);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedDifference(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedDifference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableArrayContainer andNot(MappeableBitmapContainer value2) {
        MappeableArrayContainer answer = new MappeableArrayContainer(this.content.limit());
        int pos = 0;
        short[] sarray = answer.content.array();
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] c = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                if (value2.contains(c[k])) continue;
                sarray[pos++] = c[k];
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                if (value2.contains(this.content.get(k))) continue;
                sarray[pos++] = this.content.get(k);
            }
        }
        answer.cardinality = pos;
        return answer;
    }

    @Override
    public void clear() {
        this.cardinality = 0;
    }

    @Override
    public MappeableArrayContainer clone() {
        return new MappeableArrayContainer(this.cardinality, this.content);
    }

    @Override
    public boolean contains(short x) {
        return BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    public boolean equals(Object o) {
        if (o instanceof MappeableArrayContainer) {
            MappeableArrayContainer srb = (MappeableArrayContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            if (BufferUtil.isBackedBySimpleArray(this.content) && BufferUtil.isBackedBySimpleArray(srb.content)) {
                short[] t = this.content.array();
                short[] sr = srb.content.array();
                for (int i = 0; i < this.cardinality; ++i) {
                    if (t[i] == sr[i]) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < this.cardinality; ++i) {
                    if (this.content.get(i) == srb.content.get(i)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        if (BufferUtil.isBackedBySimpleArray(this.content)) {
            short[] c = this.content.array();
            for (int k = 0; k < this.cardinality; ++k) {
                x[k + i] = BufferUtil.toIntUnsigned(c[k]) | mask;
            }
        } else {
            for (int k = 0; k < this.cardinality; ++k) {
                x[k + i] = BufferUtil.toIntUnsigned(this.content.get(k)) | mask;
            }
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return this.cardinality * 2;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        return new MappeableArrayContainerShortIterator(this);
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        return new ReverseMappeableArrayContainerShortIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.cardinality * 2;
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            hash += 31 * hash + this.content.get(k);
        }
        return hash;
    }

    @Override
    public MappeableArrayContainer iand(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        value1.cardinality = BufferUtil.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), value1.content.array());
        return this;
    }

    @Override
    public MappeableContainer iand(MappeableBitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (!value2.contains(this.content.get(k))) continue;
            this.content.put(pos++, this.content.get(k));
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public MappeableArrayContainer iandNot(MappeableArrayContainer value2) {
        this.cardinality = BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedDifference(this.content.array(), this.getCardinality(), value2.content.array(), value2.getCardinality(), this.content.array()) : BufferUtil.unsignedDifference(this.content, this.getCardinality(), value2.content, value2.getCardinality(), this.content.array());
        return this;
    }

    @Override
    public MappeableArrayContainer iandNot(MappeableBitmapContainer value2) {
        short[] c = this.content.array();
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            if (value2.contains(c[k])) continue;
            c[pos++] = c[k];
        }
        this.cardinality = pos;
        return this;
    }

    private void increaseCapacity() {
        int newCapacity;
        int n = this.content.limit() == 0 ? 4 : (this.content.limit() < 64 ? this.content.limit() * 2 : (newCapacity = this.content.limit() < 1024 ? this.content.limit() * 3 / 2 : this.content.limit() * 5 / 4));
        if (newCapacity > 4096) {
            newCapacity = 4096;
        }
        ShortBuffer newContent = ShortBuffer.allocate(newCapacity);
        this.content.rewind();
        newContent.put(this.content);
        this.content = newContent;
    }

    @Override
    public MappeableContainer inot(int firstOfRange, int lastOfRange) {
        int lastIndex;
        int startIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)lastOfRange)) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = lastOfRange - firstOfRange + 1;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        ShortBuffer buffer = ShortBuffer.allocate(newValuesInRange);
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            if (newCardinality > this.content.limit()) {
                if (newCardinality >= 4096) {
                    return this.toBitmapContainer().inot(firstOfRange, lastOfRange);
                }
                ShortBuffer co = ShortBuffer.allocate(newCardinality);
                this.content.rewind();
                co.put(this.content);
                this.content = co;
            }
            for (int pos = this.cardinality - 1; pos > lastIndex; --pos) {
                this.content.put(pos + cardinalityChange, this.content.get(pos));
            }
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
        } else {
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
            if (cardinalityChange < 0) {
                for (int i = startIndex + newValuesInRange; i < newCardinality; ++i) {
                    this.content.put(i, this.content.get(i - cardinalityChange));
                }
            }
        }
        this.cardinality = newCardinality;
        return this;
    }

    @Override
    public MappeableContainer ior(MappeableArrayContainer value2) {
        return this.or(value2);
    }

    @Override
    public MappeableContainer ior(MappeableBitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            short pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < MappeableArrayContainer.this.cardinality;
            }

            @Override
            public Short next() {
                short s = this.pos;
                this.pos = (short)(s + 1);
                return MappeableArrayContainer.this.content.get(s);
            }

            @Override
            public void remove() {
                MappeableArrayContainer.this.remove((short)(this.pos - 1));
                this.pos = (short)(this.pos - 1);
            }
        };
    }

    @Override
    public MappeableContainer ixor(MappeableArrayContainer value2) {
        return this.xor(value2);
    }

    @Override
    public MappeableContainer ixor(MappeableBitmapContainer x) {
        return x.xor(this);
    }

    protected void loadData(MappeableBitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        bitmapContainer.fillArray(this.content.array());
    }

    private void negateRange(ShortBuffer buffer, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange <= lastRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content.get(inPos)) {
                buffer.put(outPos++, (short)valInRange);
                continue;
            }
            ++inPos;
        }
        while (valInRange <= lastRange) {
            buffer.put(outPos++, (short)valInRange);
            ++valInRange;
        }
        if (outPos != buffer.limit()) {
            throw new RuntimeException("negateRange: outPos " + outPos + " whereas buffer.length=" + buffer.limit());
        }
        assert (outPos == buffer.limit());
        int i = startIndex;
        for (int k = 0; k < buffer.limit(); ++k) {
            short item = buffer.get(k);
            this.content.put(i++, item);
        }
    }

    @Override
    public MappeableContainer not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange > lastOfRange) {
            return this.clone();
        }
        int startIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)lastOfRange)) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange + 1) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) >= 4096) {
            return this.toBitmapContainer().not(firstOfRange, lastOfRange);
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(newCardinality);
        short[] sarray = answer.content.array();
        for (int i = 0; i < startIndex; ++i) {
            sarray[i] = this.content.get(i);
        }
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange <= lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content.get(inPos)) {
                sarray[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange <= lastOfRange) {
            answer.content.put(outPos++, (short)valInRange);
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content.put(outPos++, this.content.get(i));
        }
        answer.cardinality = newCardinality;
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int i2;
            int k;
            short[] sarray;
            MappeableBitmapContainer bc = new MappeableBitmapContainer();
            long[] bitArray = bc.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(value2.content)) {
                sarray = value2.content.array();
                for (k = 0; k < value2.cardinality; ++k) {
                    int n = i2 = BufferUtil.toIntUnsigned(sarray[k]) >>> 6;
                    bitArray[n] = bitArray[n] | 1L << sarray[k];
                }
            } else {
                for (int k2 = 0; k2 < value2.cardinality; ++k2) {
                    int n = i = BufferUtil.toIntUnsigned(value2.content.get(k2)) >>> 6;
                    bitArray[n] = bitArray[n] | 1L << value2.content.get(k2);
                }
            }
            if (BufferUtil.isBackedBySimpleArray(this.content)) {
                sarray = this.content.array();
                for (k = 0; k < this.cardinality; ++k) {
                    int n = i2 = BufferUtil.toIntUnsigned(sarray[k]) >>> 6;
                    bitArray[n] = bitArray[n] | 1L << sarray[k];
                }
            } else {
                for (int k3 = 0; k3 < this.cardinality; ++k3) {
                    int n = i = BufferUtil.toIntUnsigned(this.content.get(k3)) >>> 6;
                    bitArray[n] = bitArray[n] | 1L << this.content.get(k3);
                }
            }
            bc.cardinality = 0;
            for (int index = 0; index < bc.bitmap.limit(); ++index) {
                bc.cardinality += Long.bitCount(bitArray[index]);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(totalCardinality);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedUnion2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableBitmapContainer x) {
        return x.or(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[2];
        in.readFully(buffer);
        this.cardinality = buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
        if (this.content.limit() < this.cardinality) {
            this.content = ShortBuffer.allocate(this.cardinality);
        }
        for (int k = 0; k < this.cardinality; ++k) {
            in.readFully(buffer);
            this.content.put(k, (short)((buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF));
        }
    }

    @Override
    public MappeableContainer remove(short x) {
        int loc = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc >= 0) {
            System.arraycopy(this.content.array(), loc + 1, this.content.array(), loc, this.cardinality - loc - 1);
            --this.cardinality;
        }
        return this;
    }

    public MappeableBitmapContainer toBitmapContainer() {
        MappeableBitmapContainer bc = new MappeableBitmapContainer();
        bc.loadData(this);
        return bc;
    }

    public String toString() {
        if (this.cardinality == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.cardinality - 1; ++i) {
            sb.append(this.content.get(i));
            sb.append(",");
        }
        sb.append(this.content.get(this.cardinality - 1));
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
        ShortBuffer co = ShortBuffer.allocate(this.cardinality);
        for (int k = 0; k < this.cardinality; ++k) {
            co.put(this.content.get(k));
        }
        this.content = co;
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        for (int k = 0; k < this.cardinality; ++k) {
            out.write(this.content.get(k) & 0xFF);
            out.write(this.content.get(k) >>> 8 & 0xFF);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.cardinality & 0xFF);
        out.write(this.cardinality >>> 8 & 0xFF);
        for (int k = 0; k < this.cardinality; ++k) {
            out.write(this.content.get(k) & 0xFF);
            out.write(this.content.get(k) >>> 8 & 0xFF);
        }
    }

    @Override
    public MappeableContainer xor(MappeableArrayContainer value2) {
        MappeableArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            int i2;
            int k;
            short[] sarray;
            MappeableBitmapContainer bc = new MappeableBitmapContainer();
            long[] bitArray = bc.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(value2.content)) {
                sarray = value2.content.array();
                for (k = 0; k < value2.cardinality; ++k) {
                    int n = i2 = BufferUtil.toIntUnsigned(sarray[k]) >>> 6;
                    bitArray[n] = bitArray[n] ^ 1L << sarray[k];
                }
            } else {
                for (int k2 = 0; k2 < value2.cardinality; ++k2) {
                    int n = i = BufferUtil.toIntUnsigned(value2.content.get(k2)) >>> 6;
                    bitArray[n] = bitArray[n] ^ 1L << value2.content.get(k2);
                }
            }
            if (BufferUtil.isBackedBySimpleArray(this.content)) {
                sarray = this.content.array();
                for (k = 0; k < this.cardinality; ++k) {
                    int n = i2 = BufferUtil.toIntUnsigned(sarray[k]) >>> 6;
                    bitArray[n] = bitArray[n] ^ 1L << sarray[k];
                }
            } else {
                for (int k3 = 0; k3 < this.cardinality; ++k3) {
                    int n = i = BufferUtil.toIntUnsigned(this.content.get(k3)) >>> 6;
                    bitArray[n] = bitArray[n] ^ 1L << this.content.get(k3);
                }
            }
            bc.cardinality = 0;
            for (int index = 0; index < bc.bitmap.limit(); ++index) {
                bc.cardinality += Long.bitCount(bitArray[index]);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        MappeableArrayContainer answer = new MappeableArrayContainer(totalCardinality);
        answer.cardinality = BufferUtil.isBackedBySimpleArray(value1.content) && BufferUtil.isBackedBySimpleArray(value2.content) ? Util.unsignedExclusiveUnion2by2(value1.content.array(), value1.getCardinality(), value2.content.array(), value2.getCardinality(), answer.content.array()) : BufferUtil.unsignedExclusiveUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content.array());
        return answer;
    }

    @Override
    public MappeableContainer xor(MappeableBitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public int rank(short lowbits) {
        int answer = BufferUtil.unsignedBinarySearch(this.content, 0, this.cardinality, lowbits);
        if (answer >= 0) {
            return answer + 1;
        }
        return -answer - 1;
    }

    @Override
    public short select(int j) {
        return this.content.get(j);
    }

    @Override
    public MappeableContainer limit(int maxcardinality) {
        if (maxcardinality < this.getCardinality()) {
            return new MappeableArrayContainer(maxcardinality, this.content);
        }
        return this.clone();
    }
}

