/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.writers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.Deflater;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.GuavaShim;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.io.NonSyncDataOutputStream;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.library.api.IOInterruptedException;
import org.apache.tez.runtime.library.api.TezRuntimeConfiguration;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.common.writers.BaseUnorderedPartitionedKVWriter;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnorderedPartitionedKVWriter
extends BaseUnorderedPartitionedKVWriter {
    private static final Logger LOG = LoggerFactory.getLogger(UnorderedPartitionedKVWriter.class);
    private static final int INT_SIZE = 4;
    private static final int NUM_META = 3;
    private static final int INDEX_KEYLEN = 0;
    private static final int INDEX_VALLEN = 1;
    private static final int INDEX_NEXT = 2;
    private static final int META_SIZE = 12;
    private static final int APPROX_HEADER_LENGTH = 150;
    private final String destNameTrimmed;
    private final long availableMemory;
    @VisibleForTesting
    final WrappedBuffer[] buffers;
    @VisibleForTesting
    final BlockingQueue<WrappedBuffer> availableBuffers;
    private final ByteArrayOutputStream baos;
    private final NonSyncDataOutputStream dos;
    @VisibleForTesting
    WrappedBuffer currentBuffer;
    private final FileSystem rfs;
    @VisibleForTesting
    final List<SpillInfo> spillInfoList = Collections.synchronizedList(new ArrayList());
    private final ListeningExecutorService spillExecutor;
    private final int[] numRecordsPerPartition;
    private long localOutputRecordBytesCounter;
    private long localOutputBytesWithOverheadCounter;
    private long localOutputRecordsCounter;
    private static final int NOTIFY_THRESHOLD = 1000;
    private final long[] sizePerPartition;
    private volatile long spilledSize = 0L;
    private boolean dataViaEventsEnabled;
    private int dataViaEventsMaxSize;
    static final ThreadLocal<Deflater> deflater = new ThreadLocal<Deflater>(){

        @Override
        public Deflater initialValue() {
            return TezCommonUtils.newBestCompressionDeflater();
        }

        @Override
        public Deflater get() {
            Deflater deflater = (Deflater)super.get();
            deflater.reset();
            return deflater;
        }
    };
    private final Semaphore availableSlots;
    protected final TezCounter outputLargeRecordsCounter;
    @VisibleForTesting
    int numBuffers;
    @VisibleForTesting
    int sizePerBuffer;
    @VisibleForTesting
    int lastBufferSize;
    @VisibleForTesting
    int numInitializedBuffers;
    @VisibleForTesting
    int spillLimit;
    private Throwable spillException;
    private AtomicBoolean isShutdown = new AtomicBoolean(false);
    @VisibleForTesting
    final AtomicInteger numSpills = new AtomicInteger(0);
    private final AtomicInteger pendingSpillCount = new AtomicInteger(0);
    @VisibleForTesting
    Path finalIndexPath;
    @VisibleForTesting
    Path finalOutPath;
    @VisibleForTesting
    final IFile.Writer writer;
    @VisibleForTesting
    final boolean skipBuffers;
    private final ReentrantLock spillLock = new ReentrantLock();
    private final Condition spillInProgress = this.spillLock.newCondition();
    private final boolean pipelinedShuffle;
    private final boolean isFinalMergeEnabled;
    private final List<Event> finalEvents;
    final TezRuntimeConfiguration.ReportPartitionStats reportPartitionStats;
    private final long indexFileSizeEstimate;
    private List<WrappedBuffer> filledBuffers = new ArrayList<WrappedBuffer>();
    private final boolean useCachedStream;
    private static final int ALLOC_OVERHEAD = 64;

    public UnorderedPartitionedKVWriter(OutputContext outputContext, Configuration conf, int numOutputs, long availableMemoryBytes) throws IOException {
        super(outputContext, conf, numOutputs);
        Preconditions.checkArgument((availableMemoryBytes >= 0L ? 1 : 0) != 0, (Object)"availableMemory should be >= 0 bytes");
        this.destNameTrimmed = TezUtilsInternal.cleanVertexName((String)outputContext.getDestinationVertexName());
        boolean pipelinedShuffleConf = this.conf.getBoolean("tez.runtime.pipelined-shuffle.enabled", false);
        this.isFinalMergeEnabled = conf.getBoolean("tez.runtime.enable.final-merge.in.output", true);
        this.pipelinedShuffle = pipelinedShuffleConf && !this.isFinalMergeEnabled;
        this.finalEvents = Lists.newLinkedList();
        this.dataViaEventsEnabled = conf.getBoolean("tez.runtime.transfer.data-via-events.enabled", false);
        this.dataViaEventsMaxSize = conf.getInt("tez.runtime.transfer.data-via-events.max-size", 512);
        boolean useCachedStreamConfig = conf.getBoolean("tez.runtime.transfer.data-via-events.support.in-mem.file", true);
        boolean bl = this.useCachedStream = useCachedStreamConfig && this.dataViaEventsEnabled && this.numPartitions == 1 && !this.pipelinedShuffle;
        if (availableMemoryBytes == 0L) {
            Preconditions.checkArgument((this.numPartitions == 1 && !this.pipelinedShuffle ? 1 : 0) != 0, (Object)("availableMemory can be set to 0 only when numPartitions=1 and tez.runtime.pipelined-shuffle.enabled is disabled. current numPartitions=" + this.numPartitions + ", " + "tez.runtime.pipelined-shuffle.enabled" + "=" + this.pipelinedShuffle));
        }
        this.availableMemory = availableMemoryBytes;
        int maxSingleBufferSizeBytes = conf.getInt("tez.runtime.unordered.output.max-per-buffer.size-bytes", Integer.MAX_VALUE);
        this.computeNumBuffersAndSize(maxSingleBufferSizeBytes);
        this.availableBuffers = new LinkedBlockingQueue<WrappedBuffer>();
        this.buffers = new WrappedBuffer[this.numBuffers];
        this.buffers[0] = new WrappedBuffer(numOutputs, this.sizePerBuffer);
        this.numInitializedBuffers = 1;
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.destNameTrimmed + ": " + "Initializing Buffer #" + this.numInitializedBuffers + " with size=" + this.sizePerBuffer);
        }
        this.currentBuffer = this.buffers[0];
        this.baos = new ByteArrayOutputStream();
        this.dos = new NonSyncDataOutputStream((OutputStream)this.baos);
        this.keySerializer.open((OutputStream)this.dos);
        this.valSerializer.open((OutputStream)this.dos);
        this.rfs = FileSystem.getLocal((Configuration)this.conf).getRaw();
        int maxThreads = Math.max(2, this.numBuffers / 2);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, maxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("UnorderedOutSpiller {" + TezUtilsInternal.cleanVertexName((String)outputContext.getDestinationVertexName()) + "} #%d").build());
        this.availableSlots = new Semaphore(maxThreads - 1, true);
        this.spillExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.numRecordsPerPartition = new int[this.numPartitions];
        this.reportPartitionStats = TezRuntimeConfiguration.ReportPartitionStats.fromString(conf.get("tez.runtime.report.partition.stats", TezRuntimeConfiguration.TEZ_RUNTIME_REPORT_PARTITION_STATS_DEFAULT));
        this.sizePerPartition = this.reportPartitionStats.isEnabled() ? new long[this.numPartitions] : null;
        this.outputLargeRecordsCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_LARGE_RECORDS);
        this.indexFileSizeEstimate = this.numPartitions * 24;
        if (this.numPartitions == 1 && !this.pipelinedShuffle) {
            this.skipBuffers = true;
            if (this.useCachedStream) {
                this.writer = new IFile.FileBackedInMemIFileWriter(conf, this.rfs, this.outputFileHandler, this.keyClass, this.valClass, this.codec, this.outputRecordsCounter, this.outputRecordBytesCounter, this.dataViaEventsMaxSize);
            } else {
                this.finalOutPath = this.outputFileHandler.getOutputFileForWrite();
                this.writer = new IFile.Writer(conf, this.rfs, this.finalOutPath, this.keyClass, this.valClass, this.codec, this.outputRecordsCounter, this.outputRecordBytesCounter);
                if (!TezSpillRecord.SPILL_FILE_PERMS.equals((Object)TezSpillRecord.SPILL_FILE_PERMS.applyUMask(FsPermission.getUMask((Configuration)conf)))) {
                    this.rfs.setPermission(this.finalOutPath, TezSpillRecord.SPILL_FILE_PERMS);
                }
            }
        } else {
            this.skipBuffers = false;
            this.writer = null;
        }
        LOG.info(this.destNameTrimmed + ": " + "numBuffers=" + this.numBuffers + ", sizePerBuffer=" + this.sizePerBuffer + ", skipBuffers=" + this.skipBuffers + ", numPartitions=" + this.numPartitions + ", availableMemory=" + this.availableMemory + ", maxSingleBufferSizeBytes=" + maxSingleBufferSizeBytes + ", pipelinedShuffle=" + this.pipelinedShuffle + ", isFinalMergeEnabled=" + this.isFinalMergeEnabled + ", numPartitions=" + this.numPartitions + ", reportPartitionStats=" + (Object)((Object)this.reportPartitionStats) + ", dataViaEventsEnabled=" + this.dataViaEventsEnabled + ", dataViaEventsMaxSize=" + this.dataViaEventsMaxSize + ", useCachedStreamConfig=" + useCachedStreamConfig + ", useCachedStream=" + this.useCachedStream);
    }

    private void computeNumBuffersAndSize(int bufferLimit) {
        this.numBuffers = (int)(this.availableMemory / (long)bufferLimit);
        if (this.numBuffers >= 2) {
            this.sizePerBuffer = bufferLimit - 64;
            this.lastBufferSize = (int)(this.availableMemory % (long)bufferLimit);
            if (this.lastBufferSize > bufferLimit / 2) {
                ++this.numBuffers;
            } else {
                if (this.lastBufferSize > 0) {
                    LOG.warn("Underallocating memory. Unused memory size: {}.", (Object)this.lastBufferSize);
                }
                this.lastBufferSize = this.sizePerBuffer;
            }
        } else {
            this.numBuffers = 2;
            this.sizePerBuffer = this.availableMemory / (long)this.numBuffers > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(this.availableMemory / (long)this.numBuffers);
            this.lastBufferSize = this.sizePerBuffer;
        }
        this.sizePerBuffer -= this.sizePerBuffer % 4;
        this.lastBufferSize -= this.lastBufferSize % 4;
        int mergePercent = this.conf.getInt("tez.runtime.unordered-partitioned-kvwriter.buffer-merge-percent", 0);
        this.spillLimit = this.numBuffers * mergePercent / 100;
        if (this.spillLimit < 1) {
            this.spillLimit = 1;
        }
        if (this.spillLimit > this.numBuffers) {
            this.spillLimit = this.numBuffers;
        }
    }

    @Override
    public void write(Object key, Object value) throws IOException {
        if (this.isShutdown.get()) {
            throw new RuntimeException("Writer already closed");
        }
        if (this.spillException != null) {
            throw new IOException("Exception during spill", new IOException(this.spillException));
        }
        if (this.skipBuffers) {
            this.writer.append(key, value);
            this.outputContext.notifyProgress();
        } else {
            int partition = this.partitioner.getPartition(key, value, this.numPartitions);
            this.write(key, value, partition);
        }
    }

    private void write(Object key, Object value, int partition) throws IOException {
        int metaSkip;
        int mod = this.currentBuffer.nextPosition % 4;
        int n = metaSkip = mod == 0 ? 0 : 4 - mod;
        if (this.currentBuffer.availableSize < 12 + metaSkip || this.currentBuffer.full) {
            metaSkip = 0;
            this.setupNextBuffer();
        }
        WrappedBuffer wrappedBuffer = this.currentBuffer;
        wrappedBuffer.nextPosition = wrappedBuffer.nextPosition + metaSkip;
        int metaStart = this.currentBuffer.nextPosition;
        WrappedBuffer wrappedBuffer2 = this.currentBuffer;
        wrappedBuffer2.availableSize = wrappedBuffer2.availableSize - (12 + metaSkip);
        wrappedBuffer2 = this.currentBuffer;
        wrappedBuffer2.nextPosition = wrappedBuffer2.nextPosition + 12;
        this.keySerializer.serialize(key);
        if (this.currentBuffer.full) {
            if (metaStart == 0) {
                this.currentBuffer.reset();
                this.writeLargeRecord(key, value, partition);
                return;
            }
            this.setupNextBuffer();
            this.write(key, value, partition);
            return;
        }
        int valStart = this.currentBuffer.nextPosition;
        this.valSerializer.serialize(value);
        if (this.currentBuffer.full) {
            if (metaStart == 0) {
                this.currentBuffer.reset();
                this.writeLargeRecord(key, value, partition);
                return;
            }
            this.setupNextBuffer();
            this.write(key, value, partition);
            return;
        }
        int metaIndex = metaStart / 4;
        int indexNext = this.currentBuffer.partitionPositions[partition];
        this.currentBuffer.metaBuffer.put(metaIndex + 0, valStart - (metaStart + 12));
        this.currentBuffer.metaBuffer.put(metaIndex + 1, this.currentBuffer.nextPosition - valStart);
        this.currentBuffer.metaBuffer.put(metaIndex + 2, indexNext);
        WrappedBuffer wrappedBuffer3 = this.currentBuffer;
        wrappedBuffer3.skipSize = wrappedBuffer3.skipSize + metaSkip;
        this.localOutputRecordBytesCounter += (long)(this.currentBuffer.nextPosition - (metaStart + 12));
        this.localOutputBytesWithOverheadCounter += (long)(this.currentBuffer.nextPosition - metaStart + metaSkip);
        ++this.localOutputRecordsCounter;
        if (this.localOutputRecordBytesCounter % 1000L == 0L) {
            this.updateTezCountersAndNotify();
        }
        ((WrappedBuffer)this.currentBuffer).partitionPositions[partition] = metaStart;
        int[] nArray = this.currentBuffer.recordsPerPartition;
        int n2 = partition;
        nArray[n2] = nArray[n2] + 1;
        long[] lArray = this.currentBuffer.sizePerPartition;
        int n3 = partition;
        lArray[n3] = lArray[n3] + (long)(this.currentBuffer.nextPosition - (metaStart + 12));
        this.currentBuffer.numRecords++;
    }

    private void updateTezCountersAndNotify() {
        this.outputRecordBytesCounter.increment(this.localOutputRecordBytesCounter);
        this.outputBytesWithOverheadCounter.increment(this.localOutputBytesWithOverheadCounter);
        this.outputRecordsCounter.increment(this.localOutputRecordsCounter);
        this.outputContext.notifyProgress();
        this.localOutputRecordBytesCounter = 0L;
        this.localOutputBytesWithOverheadCounter = 0L;
        this.localOutputRecordsCounter = 0L;
    }

    private void setupNextBuffer() throws IOException {
        if (this.currentBuffer.numRecords == 0) {
            this.currentBuffer.reset();
        } else {
            int filledBufferCount = this.filledBuffers.size();
            if (LOG.isDebugEnabled() || filledBufferCount % 10 == 0) {
                LOG.info(this.destNameTrimmed + ": " + "Moving to next buffer. Total filled buffers: " + filledBufferCount);
            }
            this.updateGlobalStats(this.currentBuffer);
            this.filledBuffers.add(this.currentBuffer);
            this.mayBeSpill(false);
            this.currentBuffer = this.getNextAvailableBuffer();
            this.mayBeSpill(false);
        }
    }

    private void mayBeSpill(boolean shouldBlock) throws IOException {
        if (this.filledBuffers.size() >= this.spillLimit) {
            this.scheduleSpill(shouldBlock);
        }
    }

    private boolean scheduleSpill(boolean block) throws IOException {
        if (this.filledBuffers.isEmpty()) {
            return false;
        }
        try {
            if (block) {
                this.availableSlots.acquire();
            } else if (!this.availableSlots.tryAcquire()) {
                return false;
            }
            int filledBufferCount = this.filledBuffers.size();
            if (LOG.isDebugEnabled() || filledBufferCount % 10 == 0) {
                LOG.info(this.destNameTrimmed + ": triggering spill. filledBuffers.size=" + filledBufferCount);
            }
            this.pendingSpillCount.incrementAndGet();
            int spillNumber = this.numSpills.getAndIncrement();
            ListenableFuture future = this.spillExecutor.submit((Callable)((Object)new SpillCallable(new ArrayList<WrappedBuffer>(this.filledBuffers), this.codec, this.spilledRecordsCounter, spillNumber)));
            this.filledBuffers.clear();
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new SpillCallback(spillNumber), (Executor)GuavaShim.directExecutor());
            this.updateTezCountersAndNotify();
            return true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private boolean reportPartitionStats() {
        return this.sizePerPartition != null;
    }

    private void updateGlobalStats(WrappedBuffer buffer) {
        for (int i = 0; i < this.numPartitions; ++i) {
            int n = i;
            this.numRecordsPerPartition[n] = this.numRecordsPerPartition[n] + buffer.recordsPerPartition[i];
            if (!this.reportPartitionStats()) continue;
            int n2 = i;
            this.sizePerPartition[n2] = this.sizePerPartition[n2] + buffer.sizePerPartition[i];
        }
    }

    private WrappedBuffer getNextAvailableBuffer() throws IOException {
        if (this.availableBuffers.peek() == null) {
            if (this.numInitializedBuffers < this.numBuffers) {
                this.buffers[this.numInitializedBuffers] = new WrappedBuffer(this.numPartitions, this.numInitializedBuffers == this.numBuffers - 1 ? this.lastBufferSize : this.sizePerBuffer);
                ++this.numInitializedBuffers;
                return this.buffers[this.numInitializedBuffers - 1];
            }
            try {
                this.mayBeSpill(true);
                return this.availableBuffers.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOInterruptedException("Interrupted while waiting for next buffer", e);
            }
        }
        return (WrappedBuffer)this.availableBuffers.poll();
    }

    private long writePartition(int pos, WrappedBuffer wrappedBuffer, IFile.Writer writer, DataInputBuffer keyBuffer, DataInputBuffer valBuffer) throws IOException {
        long numRecords = 0L;
        while (pos != -1) {
            int metaIndex = pos / 4;
            int keyLength = wrappedBuffer.metaBuffer.get(metaIndex + 0);
            int valLength = wrappedBuffer.metaBuffer.get(metaIndex + 1);
            keyBuffer.reset(wrappedBuffer.buffer, pos + 12, keyLength);
            valBuffer.reset(wrappedBuffer.buffer, pos + 12 + keyLength, valLength);
            writer.append(keyBuffer, valBuffer);
            ++numRecords;
            pos = wrappedBuffer.metaBuffer.get(metaIndex + 2);
        }
        return numRecords;
    }

    public static long getInitialMemoryRequirement(Configuration conf, long maxAvailableTaskMemory) {
        long initialMemRequestMb = conf.getInt("tez.runtime.unordered.output.buffer.size-mb", 100);
        Preconditions.checkArgument((initialMemRequestMb != 0L ? 1 : 0) != 0, (Object)"tez.runtime.unordered.output.buffer.size-mb should be larger than 0");
        long reqBytes = initialMemRequestMb << 20;
        LOG.info("Requested BufferSize (tez.runtime.unordered.output.buffer.size-mb) : " + initialMemRequestMb);
        return reqBytes;
    }

    private boolean canSendDataOverDME() throws IOException {
        if (this.dataViaEventsEnabled && this.useCachedStream && this.finalOutPath == null && ((IFile.FileBackedInMemIFileWriter)this.writer).isDataFlushedToDisk()) {
            this.finalOutPath = ((IFile.FileBackedInMemIFileWriter)this.writer).getOutputPath();
            if (!TezSpillRecord.SPILL_FILE_PERMS.equals((Object)TezSpillRecord.SPILL_FILE_PERMS.applyUMask(FsPermission.getUMask((Configuration)this.conf)))) {
                this.rfs.setPermission(this.finalOutPath, TezSpillRecord.SPILL_FILE_PERMS);
            }
            this.additionalSpillBytesWritternCounter.increment(this.writer.getCompressedLength());
        }
        return this.writer != null && this.dataViaEventsEnabled && this.writer.getCompressedLength() <= (long)this.dataViaEventsMaxSize;
    }

    private ByteBuffer readDataForDME() throws IOException {
        if (this.useCachedStream && !((IFile.FileBackedInMemIFileWriter)this.writer).isDataFlushedToDisk()) {
            return ((IFile.FileBackedInMemIFileWriter)this.writer).getData();
        }
        try (FSDataInputStream inStream = this.rfs.open(this.finalOutPath);){
            byte[] buf = new byte[(int)this.writer.getCompressedLength()];
            IOUtils.readFully((InputStream)inStream, (byte[])buf, (int)0, (int)((int)this.writer.getCompressedLength()));
            this.additionalSpillBytesReadCounter.increment(this.writer.getCompressedLength());
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
            return byteBuffer;
        }
    }

    @Override
    public List<Event> close() throws IOException, InterruptedException {
        this.scheduleSpill(true);
        LinkedList eventList = Lists.newLinkedList();
        this.isShutdown.set(true);
        this.spillLock.lock();
        try {
            LOG.info(this.destNameTrimmed + ": " + "Waiting for all spills to complete : Pending : " + this.pendingSpillCount.get());
            while (this.pendingSpillCount.get() != 0 && this.spillException == null) {
                this.spillInProgress.await();
            }
        }
        finally {
            this.spillLock.unlock();
        }
        if (this.spillException != null) {
            LOG.error(this.destNameTrimmed + ": " + "Error during spill, throwing");
            this.cleanup();
            this.currentBuffer.cleanup();
            this.currentBuffer = null;
            if (this.spillException instanceof IOException) {
                throw (IOException)this.spillException;
            }
            throw new IOException(this.spillException);
        }
        LOG.info(this.destNameTrimmed + ": " + "All spills complete");
        this.cleanup();
        LinkedList events = Lists.newLinkedList();
        if (!this.pipelinedShuffle) {
            if (this.skipBuffers) {
                this.writer.close();
                long rawLen = this.writer.getRawLength();
                long compLen = this.writer.getCompressedLength();
                BitSet emptyPartitions = new BitSet();
                if (this.outputRecordsCounter.getValue() == 0L) {
                    emptyPartitions.set(0);
                }
                if (this.reportPartitionStats() && this.outputRecordsCounter.getValue() > 0L) {
                    this.sizePerPartition[0] = rawLen;
                }
                this.cleanupCurrentBuffer();
                if (this.outputRecordsCounter.getValue() > 0L) {
                    this.outputBytesWithOverheadCounter.increment(rawLen);
                    this.fileOutputBytesCounter.increment(compLen + this.indexFileSizeEstimate);
                }
                eventList.add(this.generateVMEvent());
                if (!this.canSendDataOverDME()) {
                    TezIndexRecord rec = new TezIndexRecord(0L, rawLen, compLen);
                    TezSpillRecord sr = new TezSpillRecord(1);
                    sr.putIndex(rec, 0);
                    this.finalIndexPath = this.outputFileHandler.getOutputIndexFileForWrite(this.indexFileSizeEstimate);
                    sr.writeToFile(this.finalIndexPath, this.conf);
                }
                eventList.add(this.generateDMEvent(false, -1, false, this.outputContext.getUniqueIdentifier(), emptyPartitions));
                return eventList;
            }
            if (this.isFinalMergeEnabled) {
                if (this.numSpills.get() > 0) {
                    this.mergeAll();
                } else {
                    this.finalSpill();
                }
                this.updateTezCountersAndNotify();
                eventList.add(this.generateVMEvent());
                eventList.add(this.generateDMEvent());
            } else {
                SpillResult result = this.finalSpill();
                if (result != null) {
                    this.updateTezCountersAndNotify();
                    this.finalEvents.add(this.generateVMEvent());
                    int spillNum = this.numSpills.get() - 1;
                    SpillCallback callback = new SpillCallback(spillNum);
                    callback.computePartitionStats(result);
                    BitSet emptyPartitions = this.getEmptyPartitions(callback.getRecordsPerPartition());
                    String pathComponent = this.generatePathComponent(this.outputContext.getUniqueIdentifier(), spillNum);
                    Event finalEvent = this.generateDMEvent(true, spillNum, true, pathComponent, emptyPartitions);
                    this.finalEvents.add(finalEvent);
                }
                eventList.addAll(this.finalEvents);
            }
            this.cleanupCurrentBuffer();
            return eventList;
        }
        if (this.finalSpill() != null) {
            this.mayBeSendEventsForSpill(this.currentBuffer.recordsPerPartition, this.sizePerPartition, this.numSpills.get() - 1, true);
        }
        this.updateTezCountersAndNotify();
        this.cleanupCurrentBuffer();
        return events;
    }

    private BitSet getEmptyPartitions(int[] recordsPerPartition) {
        Preconditions.checkArgument((recordsPerPartition != null ? 1 : 0) != 0, (Object)"records per partition can not be null");
        BitSet emptyPartitions = new BitSet();
        for (int i = 0; i < this.numPartitions; ++i) {
            if (recordsPerPartition[i] != 0) continue;
            emptyPartitions.set(i);
        }
        return emptyPartitions;
    }

    public boolean reportDetailedPartitionStats() {
        return this.reportPartitionStats.isPrecise();
    }

    private Event generateVMEvent() throws IOException {
        return ShuffleUtils.generateVMEvent(this.outputContext, this.sizePerPartition, this.reportDetailedPartitionStats(), deflater.get());
    }

    private Event generateDMEvent() throws IOException {
        BitSet emptyPartitions = this.getEmptyPartitions(this.numRecordsPerPartition);
        return this.generateDMEvent(false, -1, false, this.outputContext.getUniqueIdentifier(), emptyPartitions);
    }

    private Event generateDMEvent(boolean addSpillDetails, int spillId, boolean isLastSpill, String pathComponent, BitSet emptyPartitions) throws IOException {
        this.outputContext.notifyProgress();
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        String host = this.getHost();
        if (emptyPartitions.cardinality() != 0) {
            ByteString emptyPartitionsByteString = TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)emptyPartitions), (Deflater)deflater.get());
            payloadBuilder.setEmptyPartitions(emptyPartitionsByteString);
        }
        if (emptyPartitions.cardinality() != this.numPartitions) {
            payloadBuilder.setHost(host);
            payloadBuilder.setPort(this.getShufflePort());
            payloadBuilder.setPathComponent(pathComponent);
        }
        if (addSpillDetails) {
            payloadBuilder.setSpillId(spillId);
            payloadBuilder.setLastEvent(isLastSpill);
        }
        if (this.canSendDataOverDME()) {
            ShuffleUserPayloads.DataProto.Builder dataProtoBuilder = ShuffleUserPayloads.DataProto.newBuilder();
            dataProtoBuilder.setData(ByteString.copyFrom((ByteBuffer)this.readDataForDME()));
            dataProtoBuilder.setRawLength((int)this.writer.getRawLength());
            dataProtoBuilder.setCompressedLength((int)this.writer.getCompressedLength());
            payloadBuilder.setData(dataProtoBuilder.build());
            this.dataViaEventSize.increment(this.writer.getCompressedLength());
            LOG.debug("payload packed in DME, dataSize: " + this.writer.getCompressedLength());
        }
        ByteBuffer payload = payloadBuilder.build().toByteString().asReadOnlyByteBuffer();
        return CompositeDataMovementEvent.create((int)0, (int)this.numPartitions, (ByteBuffer)payload);
    }

    private void cleanupCurrentBuffer() {
        this.currentBuffer.cleanup();
        this.currentBuffer = null;
    }

    private void cleanup() {
        if (this.spillExecutor != null) {
            this.spillExecutor.shutdownNow();
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null || this.buffers[i] == this.currentBuffer) continue;
            this.buffers[i].cleanup();
            this.buffers[i] = null;
        }
        this.availableBuffers.clear();
    }

    private SpillResult finalSpill() throws IOException {
        if (this.currentBuffer.nextPosition == 0) {
            if (this.pipelinedShuffle || !this.isFinalMergeEnabled) {
                LinkedList eventList = Lists.newLinkedList();
                eventList.add(ShuffleUtils.generateVMEvent(this.outputContext, this.reportPartitionStats() ? new long[this.numPartitions] : null, this.reportDetailedPartitionStats(), deflater.get()));
                if (this.localOutputRecordsCounter == 0L && this.outputLargeRecordsCounter.getValue() == 0L) {
                    BitSet emptyPartitions = new BitSet(this.numPartitions);
                    emptyPartitions.flip(0, this.numPartitions);
                    eventList.add(this.generateDMEvent(true, this.numSpills.get(), true, null, emptyPartitions));
                }
                if (this.pipelinedShuffle) {
                    this.outputContext.sendEvents((List)eventList);
                } else if (!this.isFinalMergeEnabled) {
                    this.finalEvents.addAll(0, eventList);
                }
            }
            return null;
        }
        this.updateGlobalStats(this.currentBuffer);
        this.filledBuffers.add(this.currentBuffer);
        SpillPathDetails spillPathDetails = this.getSpillPathDetails(true, -1L);
        SpillCallable spillCallable = new SpillCallable(this.filledBuffers, this.codec, null, spillPathDetails);
        try {
            SpillResult spillResult = (SpillResult)spillCallable.call();
            this.fileOutputBytesCounter.increment(spillResult.spillSize);
            this.fileOutputBytesCounter.increment(this.indexFileSizeEstimate);
            return spillResult;
        }
        catch (Exception ex) {
            throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
        }
    }

    private SpillPathDetails getSpillPathDetails(boolean isFinalSpill, long expectedSpillSize) throws IOException {
        int spillNumber = this.numSpills.getAndIncrement();
        return this.getSpillPathDetails(isFinalSpill, expectedSpillSize, spillNumber);
    }

    private SpillPathDetails getSpillPathDetails(boolean isFinalSpill, long expectedSpillSize, int spillNumber) throws IOException {
        long spillSize = expectedSpillSize < 0L ? (long)(this.currentBuffer.nextPosition + this.numPartitions * 150) : expectedSpillSize;
        Path outputFilePath = null;
        Path indexFilePath = null;
        if (!this.pipelinedShuffle && this.isFinalMergeEnabled) {
            if (isFinalSpill) {
                outputFilePath = this.outputFileHandler.getOutputFileForWrite(spillSize);
                indexFilePath = this.outputFileHandler.getOutputIndexFileForWrite(this.indexFileSizeEstimate);
                this.finalOutPath = outputFilePath;
                this.finalIndexPath = indexFilePath;
            } else {
                outputFilePath = this.outputFileHandler.getSpillFileForWrite(spillNumber, spillSize);
            }
        } else {
            outputFilePath = this.outputFileHandler.getSpillFileForWrite(spillNumber, spillSize);
            indexFilePath = this.outputFileHandler.getSpillIndexFileForWrite(spillNumber, this.indexFileSizeEstimate);
        }
        return new SpillPathDetails(outputFilePath, indexFilePath, spillNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeAll() throws IOException {
        long expectedSize = this.spilledSize;
        if (this.currentBuffer.nextPosition != 0) {
            expectedSize += (long)(this.currentBuffer.nextPosition - this.currentBuffer.numRecords * 12 - this.currentBuffer.skipSize + this.numPartitions * 150);
            this.updateGlobalStats(this.currentBuffer);
        }
        SpillPathDetails spillPathDetails = this.getSpillPathDetails(true, expectedSize);
        this.finalIndexPath = spillPathDetails.indexFilePath;
        this.finalOutPath = spillPathDetails.outputFilePath;
        TezSpillRecord finalSpillRecord = new TezSpillRecord(this.numPartitions);
        DataInputBuffer keyBuffer = new DataInputBuffer();
        DataInputBuffer valBuffer = new DataInputBuffer();
        DataInputBuffer keyBufferIFile = new DataInputBuffer();
        DataInputBuffer valBufferIFile = new DataInputBuffer();
        FSDataOutputStream out = null;
        try {
            out = this.rfs.create(this.finalOutPath);
            if (!TezSpillRecord.SPILL_FILE_PERMS.equals((Object)TezSpillRecord.SPILL_FILE_PERMS.applyUMask(FsPermission.getUMask((Configuration)this.conf)))) {
                this.rfs.setPermission(this.finalOutPath, TezSpillRecord.SPILL_FILE_PERMS);
            }
            IFile.Writer writer = null;
            for (int i = 0; i < this.numPartitions; ++i) {
                long segmentStart = out.getPos();
                if (this.numRecordsPerPartition[i] == 0) {
                    LOG.info(this.destNameTrimmed + ": " + "Skipping partition: " + i + " in final merge since it has no records");
                    continue;
                }
                writer = new IFile.Writer(this.conf, out, this.keyClass, this.valClass, this.codec, null, null);
                try {
                    if (this.currentBuffer.nextPosition != 0 && this.currentBuffer.partitionPositions[i] != -1) {
                        this.writePartition(this.currentBuffer.partitionPositions[i], this.currentBuffer, writer, keyBuffer, valBuffer);
                    }
                    List<SpillInfo> list = this.spillInfoList;
                    synchronized (list) {
                        for (SpillInfo spillInfo : this.spillInfoList) {
                            TezIndexRecord indexRecord = spillInfo.spillRecord.getIndex(i);
                            if (indexRecord.getPartLength() == 0L) continue;
                            FSDataInputStream in = this.rfs.open(spillInfo.outPath);
                            in.seek(indexRecord.getStartOffset());
                            IFile.Reader reader = new IFile.Reader((InputStream)in, indexRecord.getPartLength(), this.codec, null, this.additionalSpillBytesReadCounter, this.ifileReadAhead, this.ifileReadAheadLength, this.ifileBufferSize);
                            while (reader.nextRawKey(keyBufferIFile)) {
                                reader.nextRawValue(valBufferIFile);
                                writer.append(keyBufferIFile, valBufferIFile);
                            }
                            reader.close();
                        }
                    }
                    writer.close();
                    this.fileOutputBytesCounter.increment(writer.getCompressedLength());
                    TezIndexRecord indexRecord = new TezIndexRecord(segmentStart, writer.getRawLength(), writer.getCompressedLength());
                    writer = null;
                    finalSpillRecord.putIndex(indexRecord, i);
                    this.outputContext.notifyProgress();
                    continue;
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            this.deleteIntermediateSpills();
        }
        finalSpillRecord.writeToFile(this.finalIndexPath, this.conf);
        this.fileOutputBytesCounter.increment(this.indexFileSizeEstimate);
        LOG.info(this.destNameTrimmed + ": " + "Finished final spill after merging : " + this.numSpills.get() + " spills");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIntermediateSpills() {
        List<SpillInfo> list = this.spillInfoList;
        synchronized (list) {
            for (SpillInfo spill : this.spillInfoList) {
                try {
                    this.rfs.delete(spill.outPath, false);
                }
                catch (IOException e) {
                    LOG.warn("Unable to delete intermediate spill " + spill.outPath, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLargeRecord(Object key, Object value, int partition) throws IOException {
        this.numAdditionalSpillsCounter.increment(1L);
        long size = this.sizePerBuffer - this.currentBuffer.numRecords * 12 - this.currentBuffer.skipSize + this.numPartitions * 150;
        SpillPathDetails spillPathDetails = this.getSpillPathDetails(false, size);
        int spillIndex = spillPathDetails.spillIndex;
        long outSize = 0L;
        try (FSDataOutputStream out = null;){
            TezSpillRecord spillRecord = new TezSpillRecord(this.numPartitions);
            Path outPath = spillPathDetails.outputFilePath;
            out = this.rfs.create(outPath);
            if (!TezSpillRecord.SPILL_FILE_PERMS.equals((Object)TezSpillRecord.SPILL_FILE_PERMS.applyUMask(FsPermission.getUMask((Configuration)this.conf)))) {
                this.rfs.setPermission(outPath, TezSpillRecord.SPILL_FILE_PERMS);
            }
            BitSet emptyPartitions = null;
            if (this.pipelinedShuffle || !this.isFinalMergeEnabled) {
                emptyPartitions = new BitSet(this.numPartitions);
            }
            for (int i = 0; i < this.numPartitions; ++i) {
                long recordStart = out.getPos();
                if (i == partition) {
                    this.spilledRecordsCounter.increment(1L);
                    try (IFile.Writer writer = null;){
                        writer = new IFile.Writer(this.conf, out, this.keyClass, this.valClass, this.codec, null, null);
                        writer.append(key, value);
                        this.outputLargeRecordsCounter.increment(1L);
                        int n = i;
                        this.numRecordsPerPartition[n] = this.numRecordsPerPartition[n] + 1;
                        if (this.reportPartitionStats()) {
                            int n2 = i;
                            this.sizePerPartition[n2] = this.sizePerPartition[n2] + writer.getRawLength();
                        }
                        writer.close();
                        TezCounter tezCounter = this.additionalSpillBytesWritternCounter;
                        synchronized (tezCounter) {
                            this.additionalSpillBytesWritternCounter.increment(writer.getCompressedLength());
                        }
                        TezIndexRecord indexRecord = new TezIndexRecord(recordStart, writer.getRawLength(), writer.getCompressedLength());
                        spillRecord.putIndex(indexRecord, i);
                        outSize = writer.getCompressedLength();
                        writer = null;
                        continue;
                    }
                }
                if (emptyPartitions == null) continue;
                emptyPartitions.set(i);
            }
            this.handleSpillIndex(spillPathDetails, spillRecord);
            this.mayBeSendEventsForSpill(emptyPartitions, this.sizePerPartition, spillIndex, false);
            LOG.info(this.destNameTrimmed + ": " + "Finished writing large record of size " + outSize + " to spill file " + spillIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.destNameTrimmed + ": " + "LargeRecord Spill=" + spillIndex + ", indexPath=" + spillPathDetails.indexFilePath + ", outputPath=" + spillPathDetails.outputFilePath);
            }
        }
    }

    private void handleSpillIndex(SpillPathDetails spillPathDetails, TezSpillRecord spillRecord) throws IOException {
        if (spillPathDetails.indexFilePath != null) {
            spillRecord.writeToFile(spillPathDetails.indexFilePath, this.conf);
        } else {
            SpillInfo spillInfo = new SpillInfo(spillRecord, spillPathDetails.outputFilePath);
            this.spillInfoList.add(spillInfo);
            this.numAdditionalSpillsCounter.increment(1L);
        }
    }

    private String generatePathComponent(String uniqueId, int spillNumber) {
        return uniqueId + "_" + spillNumber;
    }

    private List<Event> generateEventForSpill(BitSet emptyPartitions, long[] sizePerPartition, int spillNumber, boolean isFinalUpdate) throws IOException {
        LinkedList eventList = Lists.newLinkedList();
        String pathComponent = this.generatePathComponent(this.outputContext.getUniqueIdentifier(), spillNumber);
        if (isFinalUpdate) {
            eventList.add(ShuffleUtils.generateVMEvent(this.outputContext, sizePerPartition, this.reportDetailedPartitionStats(), deflater.get()));
        }
        Event compEvent = this.generateDMEvent(true, spillNumber, isFinalUpdate, pathComponent, emptyPartitions);
        eventList.add(compEvent);
        return eventList;
    }

    private void mayBeSendEventsForSpill(BitSet emptyPartitions, long[] sizePerPartition, int spillNumber, boolean isFinalUpdate) {
        if (!this.pipelinedShuffle && this.isFinalMergeEnabled) {
            return;
        }
        List<Event> events = null;
        try {
            events = this.generateEventForSpill(emptyPartitions, sizePerPartition, spillNumber, isFinalUpdate);
            LOG.info(this.destNameTrimmed + ": " + "Adding spill event for spill" + " (final update=" + isFinalUpdate + "), spillId=" + spillNumber);
            if (this.pipelinedShuffle) {
                this.outputContext.sendEvents(events);
            } else if (!this.isFinalMergeEnabled) {
                this.finalEvents.addAll(events);
            }
        }
        catch (IOException e) {
            LOG.error(this.destNameTrimmed + ": " + "Error in sending pipelined events", (Throwable)e);
            this.outputContext.reportFailure(TaskFailureType.NON_FATAL, (Throwable)e, "Error in sending events.");
        }
    }

    private void mayBeSendEventsForSpill(int[] recordsPerPartition, long[] sizePerPartition, int spillNumber, boolean isFinalUpdate) {
        BitSet emptyPartitions = this.getEmptyPartitions(recordsPerPartition);
        this.mayBeSendEventsForSpill(emptyPartitions, sizePerPartition, spillNumber, isFinalUpdate);
    }

    @VisibleForTesting
    String getHost() {
        return this.outputContext.getExecutionContext().getHostName();
    }

    @VisibleForTesting
    int getShufflePort() throws IOException {
        String auxiliaryService = this.conf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        ByteBuffer shuffleMetadata = this.outputContext.getServiceProviderMetaData(auxiliaryService);
        int shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetadata);
        return shufflePort;
    }

    @InterfaceAudience.Private
    static class SpillPathDetails {
        final Path indexFilePath;
        final Path outputFilePath;
        final int spillIndex;

        SpillPathDetails(Path outputFilePath, Path indexFilePath, int spillIndex) {
            this.outputFilePath = outputFilePath;
            this.indexFilePath = indexFilePath;
            this.spillIndex = spillIndex;
        }
    }

    @VisibleForTesting
    static class SpillInfo {
        final TezSpillRecord spillRecord;
        final Path outPath;

        SpillInfo(TezSpillRecord spillRecord, Path outPath) {
            this.spillRecord = spillRecord;
            this.outPath = outPath;
        }
    }

    private static class SpillResult {
        final long spillSize;
        final List<WrappedBuffer> filledBuffers;

        SpillResult(long size, List<WrappedBuffer> filledBuffers) {
            this.spillSize = size;
            this.filledBuffers = filledBuffers;
        }
    }

    private class SpillCallback
    implements FutureCallback<SpillResult> {
        private final int spillNumber;
        private int[] recordsPerPartition;
        private long[] sizePerPartition;

        SpillCallback(int spillNumber) {
            this.spillNumber = spillNumber;
        }

        void computePartitionStats(SpillResult result) {
            if (result.filledBuffers.size() == 1) {
                this.recordsPerPartition = result.filledBuffers.get(0).recordsPerPartition;
                this.sizePerPartition = result.filledBuffers.get(0).sizePerPartition;
            } else {
                this.recordsPerPartition = new int[UnorderedPartitionedKVWriter.this.numPartitions];
                this.sizePerPartition = new long[UnorderedPartitionedKVWriter.this.numPartitions];
                for (WrappedBuffer buffer : result.filledBuffers) {
                    for (int i = 0; i < UnorderedPartitionedKVWriter.this.numPartitions; ++i) {
                        int n = i;
                        this.recordsPerPartition[n] = this.recordsPerPartition[n] + buffer.recordsPerPartition[i];
                        int n2 = i;
                        this.sizePerPartition[n2] = this.sizePerPartition[n2] + buffer.sizePerPartition[i];
                    }
                }
            }
        }

        int[] getRecordsPerPartition() {
            return this.recordsPerPartition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(SpillResult result) {
            Object object = UnorderedPartitionedKVWriter.this;
            synchronized (object) {
                UnorderedPartitionedKVWriter.this.spilledSize = UnorderedPartitionedKVWriter.this.spilledSize + result.spillSize;
            }
            this.computePartitionStats(result);
            UnorderedPartitionedKVWriter.this.mayBeSendEventsForSpill(this.recordsPerPartition, this.sizePerPartition, this.spillNumber, false);
            try {
                for (WrappedBuffer buffer : result.filledBuffers) {
                    buffer.reset();
                    UnorderedPartitionedKVWriter.this.availableBuffers.add(buffer);
                }
            }
            catch (Throwable e) {
                LOG.error(UnorderedPartitionedKVWriter.this.destNameTrimmed + ": Failure while attempting to reset buffer after spill", e);
                UnorderedPartitionedKVWriter.this.outputContext.reportFailure(TaskFailureType.NON_FATAL, e, "Failure while attempting to reset buffer after spill");
            }
            if (!UnorderedPartitionedKVWriter.this.pipelinedShuffle && UnorderedPartitionedKVWriter.this.isFinalMergeEnabled) {
                object = UnorderedPartitionedKVWriter.this.additionalSpillBytesWritternCounter;
                synchronized (object) {
                    UnorderedPartitionedKVWriter.this.additionalSpillBytesWritternCounter.increment(result.spillSize);
                }
            }
            object = UnorderedPartitionedKVWriter.this.fileOutputBytesCounter;
            synchronized (object) {
                UnorderedPartitionedKVWriter.this.fileOutputBytesCounter.increment(UnorderedPartitionedKVWriter.this.indexFileSizeEstimate);
                UnorderedPartitionedKVWriter.this.fileOutputBytesCounter.increment(result.spillSize);
            }
            UnorderedPartitionedKVWriter.this.spillLock.lock();
            try {
                if (UnorderedPartitionedKVWriter.this.pendingSpillCount.decrementAndGet() == 0) {
                    UnorderedPartitionedKVWriter.this.spillInProgress.signal();
                }
            }
            finally {
                UnorderedPartitionedKVWriter.this.spillLock.unlock();
                UnorderedPartitionedKVWriter.this.availableSlots.release();
            }
        }

        public void onFailure(Throwable t) {
            LOG.error(UnorderedPartitionedKVWriter.this.destNameTrimmed + ": " + "Failure while spilling to disk", t);
            UnorderedPartitionedKVWriter.this.spillException = t;
            UnorderedPartitionedKVWriter.this.outputContext.reportFailure(TaskFailureType.NON_FATAL, t, "Failure while spilling to disk");
            UnorderedPartitionedKVWriter.this.spillLock.lock();
            try {
                UnorderedPartitionedKVWriter.this.spillInProgress.signal();
            }
            finally {
                UnorderedPartitionedKVWriter.this.spillLock.unlock();
                UnorderedPartitionedKVWriter.this.availableSlots.release();
            }
        }
    }

    private static class WrappedBuffer {
        private static final int PARTITION_ABSENT_POSITION = -1;
        private final int[] partitionPositions;
        private final int[] recordsPerPartition;
        private final long[] sizePerPartition;
        private final int numPartitions;
        private final int size;
        private byte[] buffer;
        private IntBuffer metaBuffer;
        private int numRecords = 0;
        private int skipSize = 0;
        private int nextPosition = 0;
        private int availableSize;
        private boolean full = false;

        WrappedBuffer(int numPartitions, int size) {
            this.partitionPositions = new int[numPartitions];
            this.recordsPerPartition = new int[numPartitions];
            this.sizePerPartition = new long[numPartitions];
            this.numPartitions = numPartitions;
            for (int i = 0; i < numPartitions; ++i) {
                this.partitionPositions[i] = -1;
                this.recordsPerPartition[i] = 0;
                this.sizePerPartition[i] = 0L;
            }
            size -= size % 4;
            this.size = size;
            this.buffer = new byte[size];
            this.metaBuffer = ByteBuffer.wrap(this.buffer).order(ByteOrder.nativeOrder()).asIntBuffer();
            this.availableSize = size;
        }

        void reset() {
            for (int i = 0; i < this.numPartitions; ++i) {
                this.partitionPositions[i] = -1;
                this.recordsPerPartition[i] = 0;
                this.sizePerPartition[i] = 0L;
            }
            this.numRecords = 0;
            this.nextPosition = 0;
            this.skipSize = 0;
            this.availableSize = this.size;
            this.full = false;
        }

        void cleanup() {
            this.buffer = null;
            this.metaBuffer = null;
        }
    }

    private class ByteArrayOutputStream
    extends OutputStream {
        private final byte[] scratch = new byte[1];

        private ByteArrayOutputStream() {
        }

        @Override
        public void write(int v) throws IOException {
            this.scratch[0] = (byte)v;
            this.write(this.scratch, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!UnorderedPartitionedKVWriter.this.currentBuffer.full) {
                if (len > UnorderedPartitionedKVWriter.this.currentBuffer.availableSize) {
                    UnorderedPartitionedKVWriter.this.currentBuffer.full = true;
                } else {
                    System.arraycopy(b, off, UnorderedPartitionedKVWriter.this.currentBuffer.buffer, UnorderedPartitionedKVWriter.this.currentBuffer.nextPosition, len);
                    WrappedBuffer wrappedBuffer = UnorderedPartitionedKVWriter.this.currentBuffer;
                    wrappedBuffer.nextPosition = wrappedBuffer.nextPosition + len;
                    wrappedBuffer = UnorderedPartitionedKVWriter.this.currentBuffer;
                    wrappedBuffer.availableSize = wrappedBuffer.availableSize - len;
                }
            }
        }
    }

    private class SpillCallable
    extends CallableWithNdc<SpillResult> {
        private final List<WrappedBuffer> filledBuffers;
        private final CompressionCodec codec;
        private final TezCounter numRecordsCounter;
        private int spillIndex;
        private SpillPathDetails spillPathDetails;
        private int spillNumber;

        public SpillCallable(List<WrappedBuffer> filledBuffers, CompressionCodec codec, TezCounter numRecordsCounter, SpillPathDetails spillPathDetails) {
            this(filledBuffers, codec, numRecordsCounter, spillPathDetails.spillIndex);
            Preconditions.checkArgument((spillPathDetails.outputFilePath != null ? 1 : 0) != 0, (Object)"Spill output file path can not be null");
            this.spillPathDetails = spillPathDetails;
        }

        public SpillCallable(List<WrappedBuffer> filledBuffers, CompressionCodec codec, TezCounter numRecordsCounter, int spillNumber) {
            this.filledBuffers = filledBuffers;
            this.codec = codec;
            this.numRecordsCounter = numRecordsCounter;
            this.spillNumber = spillNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SpillResult callInternal() throws IOException {
            SpillResult spillResult = null;
            if (this.spillPathDetails == null) {
                this.spillPathDetails = UnorderedPartitionedKVWriter.this.getSpillPathDetails(false, -1L, this.spillNumber);
                this.spillIndex = this.spillPathDetails.spillIndex;
            }
            LOG.info("Writing spill " + this.spillNumber + " to " + this.spillPathDetails.outputFilePath.toString());
            FSDataOutputStream out = UnorderedPartitionedKVWriter.this.rfs.create(this.spillPathDetails.outputFilePath);
            if (!TezSpillRecord.SPILL_FILE_PERMS.equals((Object)TezSpillRecord.SPILL_FILE_PERMS.applyUMask(FsPermission.getUMask((Configuration)UnorderedPartitionedKVWriter.this.conf)))) {
                UnorderedPartitionedKVWriter.this.rfs.setPermission(this.spillPathDetails.outputFilePath, TezSpillRecord.SPILL_FILE_PERMS);
            }
            TezSpillRecord spillRecord = new TezSpillRecord(UnorderedPartitionedKVWriter.this.numPartitions);
            DataInputBuffer key = new DataInputBuffer();
            DataInputBuffer val = new DataInputBuffer();
            long compressedLength = 0L;
            for (int i = 0; i < UnorderedPartitionedKVWriter.this.numPartitions; ++i) {
                try (IFile.Writer writer = null;){
                    long segmentStart = out.getPos();
                    long numRecords = 0L;
                    for (WrappedBuffer buffer : this.filledBuffers) {
                        UnorderedPartitionedKVWriter.this.outputContext.notifyProgress();
                        if (buffer.partitionPositions[i] == -1) continue;
                        if (writer == null) {
                            writer = new IFile.Writer(UnorderedPartitionedKVWriter.this.conf, out, UnorderedPartitionedKVWriter.this.keyClass, UnorderedPartitionedKVWriter.this.valClass, this.codec, null, null);
                        }
                        numRecords += UnorderedPartitionedKVWriter.this.writePartition(buffer.partitionPositions[i], buffer, writer, key, val);
                    }
                    if (writer == null) continue;
                    if (this.numRecordsCounter != null) {
                        TezCounter tezCounter = this.numRecordsCounter;
                        synchronized (tezCounter) {
                            this.numRecordsCounter.increment(numRecords);
                        }
                    }
                    writer.close();
                    compressedLength += writer.getCompressedLength();
                    TezIndexRecord indexRecord = new TezIndexRecord(segmentStart, writer.getRawLength(), writer.getCompressedLength());
                    spillRecord.putIndex(indexRecord, i);
                    writer = null;
                    continue;
                }
            }
            key.close();
            val.close();
            spillResult = new SpillResult(compressedLength, this.filledBuffers);
            UnorderedPartitionedKVWriter.this.handleSpillIndex(this.spillPathDetails, spillRecord);
            LOG.info(UnorderedPartitionedKVWriter.this.destNameTrimmed + ": " + "Finished spill " + this.spillIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug(UnorderedPartitionedKVWriter.this.destNameTrimmed + ": " + "Spill=" + this.spillIndex + ", indexPath=" + this.spillPathDetails.indexFilePath + ", outputPath=" + this.spillPathDetails.outputFilePath);
            }
            return spillResult;
        }
    }
}

