/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import java.io.IOException;
import java.time.LocalDate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.logging.HistoryLoggingService;
import org.apache.tez.dag.history.logging.proto.DatePartitionedLogger;
import org.apache.tez.dag.history.logging.proto.HistoryEventProtoConverter;
import org.apache.tez.dag.history.logging.proto.HistoryLoggerProtos;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWriter;
import org.apache.tez.dag.history.logging.proto.TezProtoLoggers;
import org.apache.tez.dag.records.TezDAGID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoHistoryLoggingService
extends HistoryLoggingService {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoHistoryLoggingService.class);
    static final String SPLIT_DAG_EVENTS_FILE_SUFFIX = "_1";
    private final HistoryEventProtoConverter converter = new HistoryEventProtoConverter();
    private boolean loggingDisabled = false;
    private LinkedBlockingQueue<DAGHistoryEvent> eventQueue;
    private Thread eventHandlingThread;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private TezProtoLoggers loggers;
    private ProtoMessageWriter<HistoryLoggerProtos.HistoryEventProto> appEventsWriter;
    private ProtoMessageWriter<HistoryLoggerProtos.HistoryEventProto> dagEventsWriter;
    private ProtoMessageWriter<HistoryLoggerProtos.ManifestEntryProto> manifestEventsWriter;
    private Map<HistoryEventType, Long> eventsHisto = new ConcurrentHashMap<HistoryEventType, Long>();
    private LocalDate manifestDate;
    private TezDAGID currentDagId;
    private long dagSubmittedEventOffset = -1L;
    private String appEventsFile;
    private long appLaunchedEventOffset;
    private boolean splitDagStartEvents;

    public ProtoHistoryLoggingService() {
        super(ProtoHistoryLoggingService.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        LOG.info("Initing ProtoHistoryLoggingService");
        this.setConfig(conf);
        this.loggingDisabled = !conf.getBoolean("tez.am.history.logging.enabled", true);
        this.splitDagStartEvents = conf.getBoolean("tez.history.logging.split-dag-start", false);
        int queueSize = conf.getInt("tez.history.logging.queue.size", 100000);
        this.eventQueue = new LinkedBlockingQueue(queueSize);
        LOG.info("Inited ProtoHistoryLoggingService. loggingDisabled: {} splitDagStartEvents: {} queueSize: {}", new Object[]{this.loggingDisabled, this.splitDagStartEvents, queueSize});
    }

    protected void serviceStart() throws Exception {
        LOG.info("Starting ProtoHistoryLoggingService");
        if (!this.loggingDisabled) {
            this.loggers = new TezProtoLoggers();
            if (!this.loggers.setup(this.getConfig(), this.appContext.getClock())) {
                LOG.warn("Log file location for ProtoHistoryLoggingService not specified, logging disabled");
                this.loggingDisabled = true;
                return;
            }
            this.appEventsWriter = this.loggers.getAppEventsLogger().getWriter(this.appContext.getApplicationAttemptId().toString());
            this.eventHandlingThread = new Thread(this::loop, "HistoryEventHandlingThread");
            this.eventHandlingThread.start();
        }
        LOG.info("Started ProtoHistoryLoggingService");
    }

    protected void serviceStop() throws Exception {
        LOG.info("Stopping ProtoHistoryLoggingService, eventQueueBacklog=" + this.eventQueue.size());
        this.stopped.set(true);
        this.eventHandlingThread.join();
        IOUtils.closeQuietly(this.appEventsWriter);
        IOUtils.closeQuietly(this.dagEventsWriter);
        IOUtils.closeQuietly(this.manifestEventsWriter);
        LOG.info("Stopped ProtoHistoryLoggingService");
    }

    public void handle(DAGHistoryEvent event) {
        if (this.loggingDisabled || this.stopped.get()) {
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                this.eventsHisto.compute(event.getHistoryEvent().getEventType(), (k, v) -> v == null ? 1L : v + 1L);
                LOG.debug("EVENTS HISTOGRAM BEFORE: {}", this.eventsHisto);
            }
            this.eventQueue.add(event);
        }
        catch (IllegalStateException e) {
            LOG.error("Queue capacity filled up, ignoring event: " + event.getHistoryEvent().getEventType());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Queue capacity filled up, ignoring event: {}", (Object)event.getHistoryEvent());
            }
        }
        catch (Exception e) {
            LOG.warn("Exception thrown while handling history events..", (Throwable)e);
        }
    }

    private void loop() {
        while (!this.stopped.get() || !this.eventQueue.isEmpty()) {
            DAGHistoryEvent evt = null;
            try {
                evt = this.eventQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (evt == null) continue;
                this.handleEvent(evt);
                if (!LOG.isDebugEnabled()) continue;
                this.eventsHisto.compute(evt.getHistoryEvent().getEventType(), (k, v) -> v == null ? 1L : v - 1L);
                LOG.info("EVENTS HISTOGRAM AFTER: {}", this.eventsHisto);
            }
            catch (InterruptedException e) {
                LOG.info("EventQueue poll interrupted, ignoring it.", (Throwable)e);
            }
            catch (IOException e) {
                TezDAGID dagid = evt.getDagID();
                HistoryEventType type = evt.getHistoryEvent().getEventType();
                LOG.error("Got exception while handling event {} for dag {}.", new Object[]{type, dagid, e});
            }
        }
    }

    private void handleEvent(DAGHistoryEvent event) throws IOException {
        if (this.loggingDisabled) {
            return;
        }
        HistoryEvent historyEvent = event.getHistoryEvent();
        if (event.getDagID() == null) {
            if (historyEvent.getEventType() == HistoryEventType.APP_LAUNCHED) {
                this.appEventsFile = this.appEventsWriter.getPath().toString();
                this.appLaunchedEventOffset = this.appEventsWriter.getOffset();
            }
            this.appEventsWriter.writeProto(this.converter.convert(historyEvent));
        } else {
            HistoryEventType type = historyEvent.getEventType();
            TezDAGID dagId = event.getDagID();
            if (type == HistoryEventType.DAG_FINISHED) {
                this.finishCurrentDag((DAGFinishedEvent)historyEvent);
            } else if (type == HistoryEventType.DAG_SUBMITTED) {
                this.finishCurrentDag(null);
                this.currentDagId = dagId;
                this.dagEventsWriter = this.loggers.getDagEventsLogger().getWriter(dagId.toString() + "_" + this.appContext.getApplicationAttemptId().getAttemptId());
                this.dagSubmittedEventOffset = this.dagEventsWriter.getOffset();
                this.dagEventsWriter.writeProto(this.converter.convert(historyEvent));
            } else if (this.dagEventsWriter != null) {
                this.dagEventsWriter.writeProto(this.converter.convert(historyEvent));
                if (this.splitDagStartEvents && type == HistoryEventType.DAG_STARTED) {
                    this.finishCurrentDag(null);
                    this.dagEventsWriter = this.loggers.getDagEventsLogger().getWriter(dagId.toString() + "_" + this.appContext.getApplicationAttemptId().getAttemptId() + SPLIT_DAG_EVENTS_FILE_SUFFIX);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCurrentDag(DAGFinishedEvent event) throws IOException {
        if (this.dagEventsWriter == null) {
            return;
        }
        try {
            long finishEventOffset = -1L;
            if (event != null) {
                finishEventOffset = this.dagEventsWriter.getOffset();
                this.dagEventsWriter.writeProto(this.converter.convert((HistoryEvent)event));
            }
            DatePartitionedLogger<HistoryLoggerProtos.ManifestEntryProto> manifestLogger = this.loggers.getManifestEventsLogger();
            if (this.manifestDate == null || !this.manifestDate.equals(manifestLogger.getNow().toLocalDate())) {
                IOUtils.closeQuietly(this.manifestEventsWriter);
                this.manifestEventsWriter = manifestLogger.getWriter(this.appContext.getApplicationAttemptId().toString());
                this.manifestDate = manifestLogger.getDateFromDir(this.manifestEventsWriter.getPath().getParent().getName());
            }
            HistoryLoggerProtos.ManifestEntryProto.Builder entry = HistoryLoggerProtos.ManifestEntryProto.newBuilder().setDagId(this.currentDagId.toString()).setAppId(this.currentDagId.getApplicationId().toString()).setDagSubmittedEventOffset(this.dagSubmittedEventOffset).setDagFinishedEventOffset(finishEventOffset).setDagFilePath(this.dagEventsWriter.getPath().toString()).setAppFilePath(this.appEventsFile).setAppLaunchedEventOffset(this.appLaunchedEventOffset).setWriteTime(System.currentTimeMillis());
            if (event != null) {
                entry.setDagId(event.getDagID().toString());
            }
            this.manifestEventsWriter.writeProto(entry.build());
            this.manifestEventsWriter.hflush();
            this.appEventsWriter.hflush();
        }
        finally {
            IOUtils.closeQuietly(this.dagEventsWriter);
            this.dagEventsWriter = null;
            this.dagSubmittedEventOffset = -1L;
        }
    }
}

