/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamStatistics;

public class AbfsInputStreamStatisticsImpl
implements AbfsInputStreamStatistics {
    public volatile long seekOperations;
    public volatile long forwardSeekOperations;
    public volatile long backwardSeekOperations;
    public volatile long bytesRead;
    public volatile long bytesSkippedOnSeek;
    public volatile long bytesBackwardsOnSeek;
    public volatile long seekInBuffer;
    public volatile long readOperations;
    public volatile long bytesReadFromBuffer;
    public volatile long remoteReadOperations;

    @Override
    public void seekBackwards(long negativeOffset) {
        ++this.seekOperations;
        ++this.backwardSeekOperations;
        this.bytesBackwardsOnSeek -= negativeOffset;
    }

    @Override
    public void seekForwards(long skipped) {
        ++this.seekOperations;
        ++this.forwardSeekOperations;
        if (skipped > 0L) {
            this.bytesSkippedOnSeek += skipped;
        }
    }

    @Override
    public void seek(long seekTo, long currentPos) {
        if (seekTo >= currentPos) {
            this.seekForwards(seekTo - currentPos);
        } else {
            this.seekBackwards(currentPos - seekTo);
        }
    }

    @Override
    public void bytesRead(long bytes) {
        if (bytes > 0L) {
            this.bytesRead += bytes;
        }
    }

    @Override
    public void bytesReadFromBuffer(long bytes) {
        if (bytes > 0L) {
            this.bytesReadFromBuffer += bytes;
        }
    }

    @Override
    public void seekInBuffer() {
        ++this.seekInBuffer;
    }

    @Override
    public void readOperationStarted(long pos, long len) {
        ++this.readOperations;
    }

    @Override
    public void remoteReadOperation() {
        ++this.remoteReadOperations;
    }

    @Override
    @InterfaceStability.Unstable
    public String toString() {
        StringBuilder sb = new StringBuilder("StreamStatistics{");
        sb.append(", SeekOperations=").append(this.seekOperations);
        sb.append(", ForwardSeekOperations=").append(this.forwardSeekOperations);
        sb.append(", BackwardSeekOperations=").append(this.backwardSeekOperations);
        sb.append(", BytesSkippedOnSeek=").append(this.bytesSkippedOnSeek);
        sb.append(", BytesBackwardsOnSeek=").append(this.bytesBackwardsOnSeek);
        sb.append(", seekInBuffer=").append(this.seekInBuffer);
        sb.append(", BytesRead=").append(this.bytesRead);
        sb.append(", ReadOperations=").append(this.readOperations);
        sb.append(", bytesReadFromBuffer=").append(this.bytesReadFromBuffer);
        sb.append(", remoteReadOperations=").append(this.remoteReadOperations);
        sb.append('}');
        return sb.toString();
    }
}

