/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.UserPayload;

@InterfaceAudience.Public
public abstract class EntityDescriptor<T extends EntityDescriptor<T>>
implements Writable {
    private static final int SERIALIZE_BUFFER_SIZE = 8192;
    private UserPayload userPayload = null;
    private String className;
    protected String historyText;

    @InterfaceAudience.Private
    public EntityDescriptor() {
    }

    public EntityDescriptor(String className) {
        this.className = className;
    }

    public UserPayload getUserPayload() {
        return this.userPayload;
    }

    public T setUserPayload(UserPayload userPayload) {
        Objects.requireNonNull(userPayload);
        this.userPayload = userPayload;
        return (T)this;
    }

    public T setHistoryText(String historyText) {
        this.historyText = historyText;
        return (T)this;
    }

    @InterfaceAudience.Private
    public String getHistoryText() {
        return this.historyText;
    }

    public String getClassName() {
        return this.className;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.className);
        ByteBuffer bb = DagTypeConverters.convertFromTezUserPayload(this.userPayload);
        if (bb == null) {
            out.writeInt(-1);
        } else {
            int size = bb.remaining();
            if (size == 0) {
                out.writeInt(-1);
            } else {
                out.writeInt(size);
                if (out instanceof DataOutputBuffer) {
                    DataOutputBuffer buf = (DataOutputBuffer)out;
                    buf.write((DataInput)new ByteBufferDataInput(bb), size);
                } else {
                    byte[] buf = new byte[8192];
                    do {
                        int len = Math.min(bb.remaining(), 8192);
                        bb.get(buf, 0, len);
                        out.write(buf, 0, len);
                    } while (bb.remaining() > 0);
                }
            }
            out.writeInt(this.userPayload.getVersion());
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.className = Text.readString((DataInput)in);
        int payloadLength = in.readInt();
        if (payloadLength != -1) {
            byte[] bb = new byte[payloadLength];
            in.readFully(bb);
            int version = in.readInt();
            this.userPayload = DagTypeConverters.convertToTezUserPayload(ByteBuffer.wrap(bb), version);
        }
    }

    public String toString() {
        boolean hasPayload = this.userPayload == null ? false : this.userPayload.getPayload() != null;
        return "ClassName=" + this.className + ", hasPayload=" + hasPayload;
    }

    private static class ByteBufferDataInput
    implements DataInput {
        private final ByteBuffer bb;

        public ByteBufferDataInput(ByteBuffer bb) {
            this.bb = bb;
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.bb.get(b, 0, this.bb.remaining());
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.bb.get(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean readBoolean() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte readByte() throws IOException {
            return this.bb.get();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public short readShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public char readChar() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readInt() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long readLong() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public float readFloat() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public double readDouble() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

