/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.client.CallerContext;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.JavaOptsChecker;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezYARNUtils;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.HistoryLogLevel;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.Scope;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class DAG {
    private static final Logger LOG = LoggerFactory.getLogger(DAG.class);
    final BidiMap<String, Vertex> vertices = new DualLinkedHashBidiMap();
    final Set<Edge> edges = Sets.newHashSet();
    final String name;
    final Collection<URI> urisForCredentials = new HashSet<URI>();
    Credentials credentials = new Credentials();
    Set<VertexGroup> vertexGroups = Sets.newHashSet();
    Set<GroupInputEdge> groupInputEdges = Sets.newHashSet();
    private DAGAccessControls dagAccessControls;
    Map<String, LocalResource> commonTaskLocalFiles = Maps.newHashMap();
    String dagInfo;
    CallerContext callerContext;
    private Map<String, String> dagConf = new HashMap<String, String>();
    private Vertex.VertexExecutionContext defaultExecutionContext;

    private DAG(String name) {
        this.name = name;
    }

    public static DAG create(String name) {
        return new DAG(name);
    }

    public synchronized DAG addTaskLocalFiles(Map<String, LocalResource> localFiles) {
        Objects.requireNonNull(localFiles);
        TezCommonUtils.addAdditionalLocalResources(localFiles, this.commonTaskLocalFiles, "DAG " + this.getName());
        return this;
    }

    public synchronized DAG addVertex(Vertex vertex) {
        if (this.vertices.containsKey((Object)vertex.getName())) {
            throw new IllegalStateException("Vertex " + vertex.getName() + " already defined!");
        }
        this.vertices.put((Object)vertex.getName(), (Object)vertex);
        return this;
    }

    public synchronized Vertex getVertex(String vertexName) {
        return (Vertex)this.vertices.get((Object)vertexName);
    }

    public synchronized DAG setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Deprecated
    public synchronized DAG setDAGInfo(String dagInfo) {
        Objects.requireNonNull(dagInfo);
        this.dagInfo = dagInfo;
        return this;
    }

    public synchronized DAG setCallerContext(CallerContext callerContext) {
        Objects.requireNonNull(callerContext);
        this.callerContext = callerContext;
        return this;
    }

    public synchronized VertexGroup createVertexGroup(String name, Vertex ... members) {
        VertexGroup uv = new VertexGroup(name, members);
        if (!this.vertexGroups.add(uv)) {
            throw new IllegalStateException("VertexGroup " + name + " already defined!");
        }
        return uv;
    }

    @InterfaceAudience.Private
    public synchronized Credentials getCredentials() {
        return this.credentials;
    }

    public synchronized DAG setAccessControls(DAGAccessControls accessControls) {
        this.dagAccessControls = accessControls;
        return this;
    }

    @InterfaceAudience.Private
    public synchronized DAGAccessControls getDagAccessControls() {
        return this.dagAccessControls;
    }

    public synchronized DAG addURIsForCredentials(Collection<URI> uris) {
        Objects.requireNonNull(uris, "URIs cannot be null");
        this.urisForCredentials.addAll(uris);
        return this;
    }

    @InterfaceAudience.Private
    public synchronized Collection<URI> getURIsForCredentials() {
        return Collections.unmodifiableCollection(this.urisForCredentials);
    }

    @InterfaceAudience.Private
    public synchronized Set<Vertex> getVertices() {
        return Collections.unmodifiableSet(this.vertices.values());
    }

    public synchronized DAG addEdge(Edge edge) {
        if (!this.vertices.containsValue((Object)edge.getInputVertex())) {
            throw new IllegalArgumentException("Input vertex " + edge.getInputVertex() + " doesn't exist!");
        }
        if (!this.vertices.containsValue((Object)edge.getOutputVertex())) {
            throw new IllegalArgumentException("Output vertex " + edge.getOutputVertex() + " doesn't exist!");
        }
        if (this.edges.contains(edge)) {
            throw new IllegalArgumentException("Edge " + edge + " already defined!");
        }
        edge.getInputVertex().addOutputVertex(edge.getOutputVertex(), edge);
        edge.getOutputVertex().addInputVertex(edge.getInputVertex(), edge);
        this.edges.add(edge);
        return this;
    }

    public synchronized DAG addEdge(GroupInputEdge edge) {
        if (!this.vertexGroups.contains(edge.getInputVertexGroup())) {
            throw new IllegalArgumentException("Input vertex " + edge.getInputVertexGroup() + " doesn't exist!");
        }
        if (!this.vertices.containsValue((Object)edge.getOutputVertex())) {
            throw new IllegalArgumentException("Output vertex " + edge.getOutputVertex() + " doesn't exist!");
        }
        if (this.groupInputEdges.contains(edge)) {
            throw new IllegalArgumentException("GroupInputEdge " + edge + " already defined!");
        }
        VertexGroup av = edge.getInputVertexGroup();
        av.addOutputVertex(edge.getOutputVertex(), edge);
        this.groupInputEdges.add(edge);
        LinkedList newEdges = Lists.newLinkedList();
        Vertex dstVertex = edge.getOutputVertex();
        VertexGroup uv = edge.getInputVertexGroup();
        for (Vertex member : uv.getMembers()) {
            newEdges.add(Edge.create(member, dstVertex, edge.getEdgeProperty()));
        }
        dstVertex.addGroupInput(uv.getGroupName(), uv.getGroupInfo());
        for (Edge e : newEdges) {
            this.addEdge(e);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    @InterfaceStability.Unstable
    public DAG setConf(String property, String value) {
        TezConfiguration.validateProperty(property, Scope.DAG);
        this.dagConf.put(property, value);
        return this;
    }

    public DAG setHistoryLogLevel(HistoryLogLevel historyLogLevel) {
        return this.setConf("tez.history.logging.log.level", historyLogLevel.name());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public synchronized DAG setExecutionContext(Vertex.VertexExecutionContext vertexExecutionContext) {
        this.defaultExecutionContext = vertexExecutionContext;
        return this;
    }

    @InterfaceAudience.Private
    Vertex.VertexExecutionContext getDefaultExecutionContext() {
        return this.defaultExecutionContext;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public Map<String, String> getDagConf() {
        return this.dagConf;
    }

    @InterfaceAudience.Private
    public Map<String, LocalResource> getTaskLocalFiles() {
        return this.commonTaskLocalFiles;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    void checkAndInferOneToOneParallelism() {
        HashSet newKnownTasksVertices = Sets.newHashSet();
        for (Object vertex : this.vertices.values()) {
            if (((Vertex)vertex).getParallelism() <= -1) continue;
            newKnownTasksVertices.add(vertex);
        }
        while (!newKnownTasksVertices.isEmpty()) {
            HashSet knownTasksVertices = Sets.newHashSet((Iterable)newKnownTasksVertices);
            newKnownTasksVertices.clear();
            for (Vertex v : knownTasksVertices) {
                for (Edge e : v.getOutputEdges()) {
                    Vertex outVertex;
                    if (e.getEdgeProperty().getDataMovementType() != EdgeProperty.DataMovementType.ONE_TO_ONE || (outVertex = e.getOutputVertex()).getParallelism() != -1) continue;
                    LOG.info("Inferring parallelism for vertex: " + outVertex.getName() + " to be " + v.getParallelism() + " from 1-1 connection with vertex " + v.getName());
                    outVertex.setParallelism(v.getParallelism());
                    newKnownTasksVertices.add(outVertex);
                }
            }
        }
        for (Edge e : this.edges) {
            Vertex inputVertex = e.getInputVertex();
            Vertex outputVertex = e.getOutputVertex();
            if (e.getEdgeProperty().getDataMovementType() != EdgeProperty.DataMovementType.ONE_TO_ONE || inputVertex.getParallelism() == outputVertex.getParallelism() || outputVertex.getParallelism() == -1) continue;
            throw new TezUncheckedException("1-1 Edge. Destination vertex parallelism must match source vertex. Vertex: " + inputVertex.getName() + " does not match vertex: " + outputVertex.getName());
        }
        for (Object vertex : this.vertices.values()) {
            if (((Vertex)vertex).getParallelism() != -1) continue;
            boolean hasInputInitializer = false;
            if (((Vertex)vertex).getDataSources() != null && !((Vertex)vertex).getDataSources().isEmpty()) {
                for (DataSourceDescriptor ds : ((Vertex)vertex).getDataSources()) {
                    if (ds.getInputInitializerDescriptor() == null) continue;
                    hasInputInitializer = true;
                    break;
                }
            }
            if (hasInputInitializer || ((Vertex)vertex).getDataSources() != null && ((Vertex)vertex).getDataSources().size() == 1 && ((Vertex)vertex).getDataSources().get(0).getNumberOfShards() > -1) continue;
            boolean has1to1UninitedSources = false;
            if (((Vertex)vertex).getInputVertices() != null && !((Vertex)vertex).getInputVertices().isEmpty()) {
                for (Vertex srcVertex : ((Vertex)vertex).getInputVertices()) {
                    if (srcVertex.getParallelism() != -1) continue;
                    has1to1UninitedSources = true;
                    break;
                }
            }
            if (has1to1UninitedSources || ((Vertex)vertex).getVertexManagerPlugin() != null) continue;
            throw new IllegalStateException(((Vertex)vertex).getName() + " has -1 tasks but does not have input initializers, " + "1-1 uninited sources or custom vertex manager to set it at runtime");
        }
    }

    @VisibleForTesting
    void verify() throws IllegalStateException {
        this.verify(true);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    Deque<String> verify(boolean restricted) throws IllegalStateException {
        Vertex vertex;
        if (this.vertices.isEmpty()) {
            throw new IllegalStateException("Invalid dag containing 0 vertices");
        }
        HashMap<String, AnnotatedVertex> vertexMap = new HashMap<String, AnnotatedVertex>();
        HashMap<Vertex, HashSet<String>> inboundVertexMap = new HashMap<Vertex, HashSet<String>>();
        HashMap<Iterator<RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>>, HashSet<String>> outboundVertexMap = new HashMap<Iterator<RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>>, HashSet<String>>();
        for (Object v : this.vertices.values()) {
            if (vertexMap.containsKey(((Vertex)v).getName())) {
                throw new IllegalStateException("DAG contains multiple vertices with name: " + ((Vertex)v).getName());
            }
            vertexMap.put(((Vertex)v).getName(), new AnnotatedVertex((Vertex)v));
        }
        HashMap<Vertex, List<Edge>> edgeMap = new HashMap<Vertex, List<Edge>>();
        for (Edge edge : this.edges) {
            void var10_24;
            Iterator<RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>> inputVertex = edge.getInputVertex();
            Vertex vertex2 = edge.getOutputVertex();
            List list = (List)edgeMap.get(inputVertex);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                edgeMap.put((Vertex)((Object)inputVertex), arrayList);
            }
            var10_24.add(edge);
            HashSet<String> inboundSet = (HashSet<String>)inboundVertexMap.get(vertex2);
            if (inboundSet == null) {
                inboundSet = new HashSet<String>();
                inboundVertexMap.put(vertex2, inboundSet);
            }
            inboundSet.add(((Vertex)((Object)inputVertex)).getName());
            HashSet<String> outboundSet = (HashSet<String>)outboundVertexMap.get(inputVertex);
            if (outboundSet == null) {
                outboundSet = new HashSet<String>();
                outboundVertexMap.put(inputVertex, outboundSet);
            }
            outboundSet.add(vertex2.getName());
        }
        for (Vertex vertex3 : this.vertices.values()) {
            for (RootInputLeafOutput rootInputLeafOutput : vertex3.getInputs()) {
                if (!vertexMap.containsKey(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex3.getName() + " contains an Input with the same name as vertex: " + rootInputLeafOutput.getName());
            }
            for (RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> rootInputLeafOutput : vertex3.getOutputs()) {
                if (!vertexMap.containsKey(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex3.getName() + " contains an Output with the same name as vertex: " + rootInputLeafOutput.getName());
            }
        }
        for (Map.Entry entry : inboundVertexMap.entrySet()) {
            vertex = (Vertex)entry.getKey();
            for (RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> rootInputLeafOutput : vertex.getInputs()) {
                if (!((Set)entry.getValue()).contains(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex.getName() + " contains an incoming vertex and Input with the same name: " + rootInputLeafOutput.getName());
            }
        }
        for (Map.Entry entry : outboundVertexMap.entrySet()) {
            vertex = (Vertex)entry.getKey();
            for (RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> rootInputLeafOutput : vertex.getOutputs()) {
                if (!((Set)entry.getValue()).contains(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex.getName() + " contains an outgoing vertex and Output with the same name: " + rootInputLeafOutput.getName());
            }
        }
        Deque<String> topologicalVertexStack = this.detectCycles(edgeMap, vertexMap);
        this.checkAndInferOneToOneParallelism();
        if (restricted) {
            for (Edge e : this.edges) {
                if (e.getEdgeProperty().getDataSourceType() != EdgeProperty.DataSourceType.PERSISTED) {
                    throw new IllegalStateException("Unsupported source type on edge. " + e);
                }
                if (e.getEdgeProperty().getSchedulingType() == EdgeProperty.SchedulingType.SEQUENTIAL) continue;
                throw new IllegalStateException("Unsupported scheduling type on edge. " + e);
            }
        }
        return topologicalVertexStack;
    }

    @VisibleForTesting
    void verifyLocalResources(Configuration tezConf) {
        for (Vertex v : this.vertices.values()) {
            for (Map.Entry<String, LocalResource> localResource : v.getTaskLocalFiles().entrySet()) {
                String resourceName = localResource.getKey();
                LocalResource resource = localResource.getValue();
                if (!this.commonTaskLocalFiles.containsKey(resourceName) || this.commonTaskLocalFiles.get(resourceName).equals(resource)) continue;
                try {
                    byte[] commonResourceSha;
                    LocalResource commonLr = this.commonTaskLocalFiles.get(resourceName);
                    if (resource.getSize() != commonLr.getSize()) {
                        throw new IllegalStateException("There is conflicting local resource (size mismatch) (" + resourceName + ") between dag local resource and vertex " + v.getName() + " local resource. " + "\nResource of dag : " + this.commonTaskLocalFiles.get(resourceName) + "\nResource of vertex: " + resource);
                    }
                    Path vertexResourcePath = ConverterUtils.getPathFromYarnURL((URL)resource.getResource());
                    Path commonResourcePath = ConverterUtils.getPathFromYarnURL((URL)commonLr.getResource());
                    byte[] vertexResourceSha = TezClientUtils.getResourceSha(vertexResourcePath.toUri(), tezConf);
                    if (Arrays.equals(vertexResourceSha, commonResourceSha = TezClientUtils.getResourceSha(commonResourcePath.toUri(), tezConf))) continue;
                    throw new IllegalStateException("There is conflicting local resource (sha mismatch) (" + resourceName + ") between dag local resource and vertex " + v.getName() + " local resource. " + "\nResource of dag : " + this.commonTaskLocalFiles.get(resourceName) + "\nResource of vertex: " + resource);
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException("Failed while attempting to validate sha for conflicting resources (" + resourceName + ") between dag local resource and vertex " + v.getName() + " local resource. " + "\nResource of dag : " + this.commonTaskLocalFiles.get(resourceName) + "\nResource of vertex: " + resource);
                }
            }
        }
    }

    private Deque<String> detectCycles(Map<Vertex, List<Edge>> edgeMap, Map<String, AnnotatedVertex> vertexMap) throws IllegalStateException {
        LinkedList<String> topologicalVertexStack = new LinkedList<String>();
        Integer nextIndex = 0;
        Stack<AnnotatedVertex> stack = new Stack<AnnotatedVertex>();
        for (AnnotatedVertex av : vertexMap.values()) {
            if (av.index != -1) continue;
            assert (stack.empty());
            this.strongConnect(av, vertexMap, edgeMap, stack, nextIndex, topologicalVertexStack);
        }
        return topologicalVertexStack;
    }

    private void strongConnect(AnnotatedVertex av, Map<String, AnnotatedVertex> vertexMap, Map<Vertex, List<Edge>> edgeMap, Stack<AnnotatedVertex> stack, Integer nextIndex, Deque<String> topologicalVertexStack) throws IllegalStateException {
        av.index = nextIndex;
        av.lowlink = nextIndex;
        Integer n = nextIndex;
        nextIndex = nextIndex + 1;
        Integer n2 = nextIndex;
        stack.push(av);
        av.onstack = true;
        List<Edge> edges = edgeMap.get(av.v);
        if (edges != null) {
            for (Edge e : edgeMap.get(av.v)) {
                AnnotatedVertex outVertex = vertexMap.get(e.getOutputVertex().getName());
                if (outVertex.index == -1) {
                    this.strongConnect(outVertex, vertexMap, edgeMap, stack, nextIndex, topologicalVertexStack);
                    av.lowlink = Math.min(av.lowlink, outVertex.lowlink);
                    continue;
                }
                if (!outVertex.onstack) continue;
                av.lowlink = Math.min(av.lowlink, outVertex.index);
            }
        }
        if (av.lowlink == av.index) {
            AnnotatedVertex pop = stack.pop();
            pop.onstack = false;
            if (pop != av) {
                StringBuilder message = new StringBuilder();
                message.append(av.v.getName()).append(" <- ");
                while (pop != av) {
                    message.append(pop.v.getName()).append(" <- ");
                    pop.onstack = false;
                    pop = stack.pop();
                }
                message.append(av.v.getName());
                throw new IllegalStateException("DAG contains a cycle: " + message);
            }
            if (edgeMap.containsKey(pop.v)) {
                for (Edge edge : edgeMap.get(pop.v)) {
                    if (!edge.getOutputVertex().equals(pop.v)) continue;
                    throw new IllegalStateException("DAG contains a self-cycle on vertex:" + pop.v.getName());
                }
            }
            topologicalVertexStack.push(av.v.getName());
        }
    }

    @InterfaceAudience.Private
    public DAGProtos.DAGPlan createDag(Configuration tezConf, Credentials extraCredentials, Map<String, LocalResource> tezJarResources, LocalResource binaryConfig, boolean tezLrsAsArchive) {
        return this.createDag(tezConf, extraCredentials, tezJarResources, binaryConfig, tezLrsAsArchive, null, null);
    }

    @InterfaceAudience.Private
    public synchronized DAGProtos.DAGPlan createDag(Configuration tezConf, Credentials extraCredentials, Map<String, LocalResource> tezJarResources, LocalResource binaryConfig, boolean tezLrsAsArchive, ServicePluginsDescriptor servicePluginsDescriptor, JavaOptsChecker javaOptsChecker) {
        String logLevel;
        Deque<String> topologicalVertexStack = this.verify(true);
        this.verifyLocalResources(tezConf);
        DAGProtos.DAGPlan.Builder dagBuilder = DAGProtos.DAGPlan.newBuilder();
        dagBuilder.setName(this.name);
        if (this.callerContext != null) {
            dagBuilder.setCallerContext(DagTypeConverters.convertCallerContextToProto(this.callerContext));
        }
        if (this.dagInfo != null && !this.dagInfo.isEmpty()) {
            dagBuilder.setDagInfo(this.dagInfo);
        }
        Vertex.VertexExecutionContext defaultContext = this.getDefaultExecutionContext();
        this.verifyExecutionContext(defaultContext, servicePluginsDescriptor, "DAGDefault");
        if (defaultContext != null) {
            DAGProtos.VertexExecutionContextProto contextProto = DagTypeConverters.convertToProto(defaultContext);
            dagBuilder.setDefaultExecutionContext(contextProto);
        }
        if (!this.vertexGroups.isEmpty()) {
            for (VertexGroup av : this.vertexGroups) {
                VertexGroup.GroupInfo groupInfo = av.getGroupInfo();
                DAGProtos.PlanVertexGroupInfo.Builder groupBuilder = DAGProtos.PlanVertexGroupInfo.newBuilder();
                groupBuilder.setGroupName(groupInfo.getGroupName());
                for (Vertex vertex : groupInfo.getMembers()) {
                    groupBuilder.addGroupMembers(vertex.getName());
                }
                groupBuilder.addAllOutputs(groupInfo.outputs);
                for (Map.Entry entry : groupInfo.edgeMergedInputs.entrySet()) {
                    groupBuilder.addEdgeMergedInputs(DAGProtos.PlanGroupInputEdgeInfo.newBuilder().setDestVertexName((String)entry.getKey()).setMergedInput(DagTypeConverters.convertToDAGPlan((EntityDescriptor)entry.getValue())));
                }
                dagBuilder.addVertexGroups(groupBuilder);
            }
        }
        Credentials dagCredentials = new Credentials();
        if (extraCredentials != null) {
            dagCredentials.mergeAll(extraCredentials);
        }
        dagCredentials.mergeAll(this.credentials);
        if (!this.commonTaskLocalFiles.isEmpty()) {
            dagBuilder.addAllLocalResource(DagTypeConverters.convertToDAGPlan(this.commonTaskLocalFiles));
        }
        Preconditions.checkArgument(topologicalVertexStack.size() == this.vertices.size(), "size of topologicalVertexStack is:" + topologicalVertexStack.size() + " while size of vertices is:" + this.vertices.size() + ", make sure they are the same in order to sort the vertices");
        while (!topologicalVertexStack.isEmpty()) {
            int n;
            Vertex vertex = (Vertex)this.vertices.get((Object)topologicalVertexStack.pop());
            Resource vertexTaskResource = vertex.getTaskResource();
            if (vertexTaskResource == null) {
                vertexTaskResource = Resource.newInstance((int)tezConf.getInt("tez.task.resource.memory.mb", 1024), (int)tezConf.getInt("tez.task.resource.cpu.vcores", 1));
            }
            HashMap vertexLRs = Maps.newHashMap();
            vertexLRs.putAll(vertex.getTaskLocalFiles());
            List<DataSourceDescriptor> dataSources = vertex.getDataSources();
            for (DataSourceDescriptor dataSource : dataSources) {
                if (dataSource.getCredentials() != null) {
                    dagCredentials.addAll(dataSource.getCredentials());
                }
                if (dataSource.getAdditionalLocalFiles() == null) continue;
                TezCommonUtils.addAdditionalLocalResources(dataSource.getAdditionalLocalFiles(), vertexLRs, "Vertex " + vertex.getName());
            }
            if (tezJarResources != null) {
                TezCommonUtils.addAdditionalLocalResources(tezJarResources, vertexLRs, "Vertex " + vertex.getName());
            }
            if (binaryConfig != null) {
                vertexLRs.put("tez-conf.pb", binaryConfig);
            }
            int n2 = vertex.getParallelism();
            VertexLocationHint vertexLocationHint = vertex.getLocationHint();
            if (dataSources.size() == 1) {
                DataSourceDescriptor dataSource = dataSources.get(0);
                if (n2 == -1 && dataSource.getNumberOfShards() > -1) {
                    n = dataSource.getNumberOfShards();
                }
                if (vertexLocationHint == null && dataSource.getLocationHint() != null) {
                    vertexLocationHint = dataSource.getLocationHint();
                }
            }
            if (n == -1) {
                Preconditions.checkState(vertexLocationHint == null, "Cannot specify vertex location hint without specifying vertex parallelism. Vertex: " + vertex.getName());
            } else if (vertexLocationHint != null) {
                Preconditions.checkState(n == vertexLocationHint.getTaskLocationHints().size(), "vertex task location hint must equal vertex parallelism. Vertex: " + vertex.getName());
            }
            for (DataSinkDescriptor dataSink : vertex.getDataSinks()) {
                if (dataSink.getCredentials() == null) continue;
                dagCredentials.addAll(dataSink.getCredentials());
            }
            DAGProtos.VertexPlan.Builder vertexBuilder = DAGProtos.VertexPlan.newBuilder();
            vertexBuilder.setName(vertex.getName());
            vertexBuilder.setType(DAGProtos.PlanVertexType.NORMAL);
            vertexBuilder.setProcessorDescriptor(DagTypeConverters.convertToDAGPlan(vertex.getProcessorDescriptor()));
            Vertex.VertexExecutionContext execContext = vertex.getVertexExecutionContext();
            this.verifyExecutionContext(execContext, servicePluginsDescriptor, vertex.getName());
            if (execContext != null) {
                Iterator<RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>> contextProto = DagTypeConverters.convertToProto(execContext);
                vertexBuilder.setExecutionContext((DAGProtos.VertexExecutionContextProto)((Object)contextProto));
            }
            if (vertex.getInputs().size() > 0) {
                for (RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> rootInputLeafOutput : vertex.getInputs()) {
                    vertexBuilder.addInputs(DagTypeConverters.convertToDAGPlan(rootInputLeafOutput));
                }
            }
            if (vertex.getOutputs().size() > 0) {
                for (RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> rootInputLeafOutput : vertex.getOutputs()) {
                    vertexBuilder.addOutputs(DagTypeConverters.convertToDAGPlan(rootInputLeafOutput));
                }
            }
            if (vertex.getConf() != null && vertex.getConf().size() > 0) {
                DAGProtos.ConfigurationProto.Builder confBuilder = DAGProtos.ConfigurationProto.newBuilder();
                TezUtils.populateConfProtoFromEntries(vertex.getConf().entrySet(), confBuilder);
                vertexBuilder.setVertexConf(confBuilder);
            }
            DAGProtos.PlanTaskConfiguration.Builder taskConfigBuilder = DAGProtos.PlanTaskConfiguration.newBuilder();
            taskConfigBuilder.setNumTasks(n);
            taskConfigBuilder.setMemoryMb(vertexTaskResource.getMemory());
            taskConfigBuilder.setVirtualCores(vertexTaskResource.getVirtualCores());
            try {
                taskConfigBuilder.setJavaOpts(TezClientUtils.addDefaultsToTaskLaunchCmdOpts(vertex.getTaskLaunchCmdOpts(), tezConf, javaOptsChecker));
            }
            catch (TezException tezException) {
                throw new TezUncheckedException("Invalid TaskLaunchCmdOpts defined for Vertex " + vertex.getName() + " : " + tezException.getMessage(), tezException);
            }
            taskConfigBuilder.setTaskModule(vertex.getName());
            if (!vertexLRs.isEmpty()) {
                taskConfigBuilder.addAllLocalResource(DagTypeConverters.convertToDAGPlan(vertexLRs));
            }
            HashMap hashMap = Maps.newHashMap(vertex.getTaskEnvironment());
            TezYARNUtils.setupDefaultEnv(hashMap, tezConf, "tez.task.launch.env", "", "tez.task.launch.cluster-default.env", TezConfiguration.TEZ_TASK_LAUNCH_CLUSTER_DEFAULT_ENV_DEFAULT, tezLrsAsArchive);
            for (Map.Entry entry : hashMap.entrySet()) {
                DAGProtos.PlanKeyValuePair.Builder envSettingBuilder = DAGProtos.PlanKeyValuePair.newBuilder();
                envSettingBuilder.setKey((String)entry.getKey());
                envSettingBuilder.setValue((String)entry.getValue());
                taskConfigBuilder.addEnvironmentSetting(envSettingBuilder);
            }
            if (vertexLocationHint != null && vertexLocationHint.getTaskLocationHints() != null) {
                for (TaskLocationHint hint : vertexLocationHint.getTaskLocationHints()) {
                    DAGProtos.PlanTaskLocationHint.Builder taskLocationHintBuilder = DAGProtos.PlanTaskLocationHint.newBuilder();
                    if (hint.getAffinitizedTask() != null) {
                        throw new TezUncheckedException("Task based affinity may not be specified via the DAG API");
                    }
                    if (hint.getHosts() != null) {
                        taskLocationHintBuilder.addAllHost(hint.getHosts());
                    }
                    if (hint.getRacks() != null) {
                        taskLocationHintBuilder.addAllRack(hint.getRacks());
                    }
                    vertexBuilder.addTaskLocationHint(taskLocationHintBuilder);
                }
            }
            if (vertex.getVertexManagerPlugin() != null) {
                vertexBuilder.setVertexManagerPlugin(DagTypeConverters.convertToDAGPlan(vertex.getVertexManagerPlugin()));
            }
            for (Edge inEdge : vertex.getInputEdges()) {
                vertexBuilder.addInEdgeId(inEdge.getId());
            }
            for (Edge outEdge : vertex.getOutputEdges()) {
                vertexBuilder.addOutEdgeId(outEdge.getId());
            }
            vertexBuilder.setTaskConfig(taskConfigBuilder);
            dagBuilder.addVertex(vertexBuilder);
        }
        for (Edge edge : this.edges) {
            DAGProtos.EdgePlan.Builder edgeBuilder = DAGProtos.EdgePlan.newBuilder();
            edgeBuilder.setId(edge.getId());
            edgeBuilder.setInputVertexName(edge.getInputVertex().getName());
            edgeBuilder.setOutputVertexName(edge.getOutputVertex().getName());
            edgeBuilder.setDataMovementType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getDataMovementType()));
            edgeBuilder.setDataSourceType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getDataSourceType()));
            edgeBuilder.setSchedulingType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getSchedulingType()));
            edgeBuilder.setEdgeSource(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeSource()));
            edgeBuilder.setEdgeDestination(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeDestination()));
            if (edge.getEdgeProperty().getDataMovementType() == EdgeProperty.DataMovementType.CUSTOM && edge.getEdgeProperty().getEdgeManagerDescriptor() != null) {
                edgeBuilder.setEdgeManager(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeManagerDescriptor()));
            }
            dagBuilder.addEdge(edgeBuilder);
        }
        if (this.dagAccessControls != null) {
            dagBuilder.setAclInfo(DagTypeConverters.convertDAGAccessControlsToProto(this.dagAccessControls));
        }
        DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
        if (!this.dagConf.isEmpty()) {
            TezUtils.populateConfProtoFromEntries(this.dagConf.entrySet(), confProtoBuilder);
        }
        if ((logLevel = this.dagConf.get("tez.history.logging.log.level")) != null) {
            if (!HistoryLogLevel.validateLogLevel(logLevel)) {
                throw new IllegalArgumentException("Config: tez.history.logging.log.level is set to invalid value: " + logLevel);
            }
        } else {
            logLevel = tezConf.get("tez.history.logging.log.level");
            if (logLevel != null) {
                if (!HistoryLogLevel.validateLogLevel(logLevel)) {
                    throw new IllegalArgumentException("Config: tez.history.logging.log.level is set to invalid value: " + logLevel);
                }
                DAGProtos.PlanKeyValuePair.Builder kvp = DAGProtos.PlanKeyValuePair.newBuilder();
                kvp.setKey("tez.history.logging.log.level");
                kvp.setValue(logLevel);
                confProtoBuilder.addConfKeyValues(kvp);
            }
        }
        dagBuilder.setDagConf(confProtoBuilder);
        if (dagCredentials != null) {
            dagBuilder.setCredentialsBinary(DagTypeConverters.convertCredentialsToProto(dagCredentials));
            TezCommonUtils.logCredentials(LOG, dagCredentials, "dag");
        }
        return dagBuilder.build();
    }

    private void verifyExecutionContext(Vertex.VertexExecutionContext executionContext, ServicePluginsDescriptor servicePluginsDescriptor, String context) {
        if (executionContext != null) {
            boolean found;
            if (executionContext.shouldExecuteInContainers() && (servicePluginsDescriptor == null || !servicePluginsDescriptor.areContainersEnabled())) {
                throw new IllegalStateException("Invalid configuration. ExecutionContext for " + context + " specifies container execution but this is disabled in the ServicePluginDescriptor");
            }
            if (executionContext.shouldExecuteInAm() && (servicePluginsDescriptor == null || !servicePluginsDescriptor.isUberEnabled())) {
                throw new IllegalStateException("Invalid configuration. ExecutionContext for " + context + " specifies AM execution but this is disabled in the ServicePluginDescriptor");
            }
            if (executionContext.getTaskSchedulerName() != null) {
                found = false;
                if (servicePluginsDescriptor != null) {
                    found = this.checkNamedEntityExists(executionContext.getTaskSchedulerName(), servicePluginsDescriptor.getTaskSchedulerDescriptors());
                }
                if (!found) {
                    throw new IllegalStateException("Invalid configuration. ExecutionContext for " + context + " specifies task scheduler as " + executionContext.getTaskSchedulerName() + " which is not part of the ServicePluginDescriptor");
                }
            }
            if (executionContext.getContainerLauncherName() != null) {
                found = false;
                if (servicePluginsDescriptor != null) {
                    found = this.checkNamedEntityExists(executionContext.getContainerLauncherName(), servicePluginsDescriptor.getContainerLauncherDescriptors());
                }
                if (!found) {
                    throw new IllegalStateException("Invalid configuration. ExecutionContext for " + context + " specifies container launcher as " + executionContext.getContainerLauncherName() + " which is not part of the ServicePluginDescriptor");
                }
            }
            if (executionContext.getTaskCommName() != null) {
                found = false;
                if (servicePluginsDescriptor != null) {
                    found = this.checkNamedEntityExists(executionContext.getTaskCommName(), servicePluginsDescriptor.getTaskCommunicatorDescriptors());
                }
                if (!found) {
                    throw new IllegalStateException("Invalid configuration. ExecutionContext for " + context + " specifies task communicator as " + executionContext.getTaskCommName() + " which is not part of the ServicePluginDescriptor");
                }
            }
        }
    }

    private boolean checkNamedEntityExists(String expected, NamedEntityDescriptor[] namedEntities) {
        if (namedEntities == null) {
            return false;
        }
        for (NamedEntityDescriptor named : namedEntities) {
            if (!named.getEntityName().equals(expected)) continue;
            return true;
        }
        return false;
    }

    public synchronized CallerContext getCallerContext() {
        return this.callerContext;
    }

    private static class AnnotatedVertex {
        Vertex v;
        int index;
        int lowlink;
        boolean onstack;

        private AnnotatedVertex(Vertex v) {
            this.v = v;
            this.index = -1;
            this.lowlink = -1;
        }
    }
}

