/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;

public class TezClassLoader
extends URLClassLoader {
    private static final TezClassLoader INSTANCE;

    public TezClassLoader(URL[] urls, ClassLoader classLoader) {
        super(urls, classLoader);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public static TezClassLoader getInstance() {
        return INSTANCE;
    }

    private static URL[] extractClassPathEntries() {
        String pathSeparator = System.getProperty("path.separator");
        String[] classPathEntries = System.getProperty("java.class.path").split(pathSeparator);
        URL[] cp = (URL[])Arrays.asList(classPathEntries).stream().map(s -> {
            try {
                return new URL("file://" + s);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        return cp;
    }

    static {
        ClassLoader sysLoader = TezClassLoader.class.getClassLoader();
        INSTANCE = new TezClassLoader(sysLoader instanceof URLClassLoader ? ((URLClassLoader)sysLoader).getURLs() : TezClassLoader.extractClassPathEntries(), sysLoader);
    }
}

