/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.registry.AMRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMRegistry
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(AMRegistry.class);
    protected List<AMRecord> amRecords = new ArrayList<AMRecord>();

    public void init(Configuration conf) {
        try {
            this.serviceInit(conf);
        }
        catch (Exception e) {
            LOG.error("Failed to init AMRegistry: name={}, type={}", (Object)this.getName(), (Object)((Object)((Object)this)).getClass().getName());
            throw ServiceStateException.convert((Throwable)e);
        }
    }

    public void start() {
        try {
            this.serviceStart();
        }
        catch (Exception e) {
            LOG.error("Failed to start AMRegistry: name={}, type={}", (Object)this.getName(), (Object)((Object)((Object)this)).getClass().getName());
            throw ServiceStateException.convert((Throwable)e);
        }
    }

    protected AMRegistry(String name) {
        super(name);
    }

    public void add(AMRecord server) throws Exception {
        this.amRecords.add(server);
    }

    public abstract void remove(AMRecord var1) throws Exception;

    public Optional<ApplicationId> generateNewId() throws Exception {
        return Optional.empty();
    }

    public abstract AMRecord createAmRecord(String var1, ApplicationId var2, String var3, String var4, int var5);

    public void serviceStop() throws Exception {
        ArrayList<AMRecord> records = new ArrayList<AMRecord>(this.amRecords);
        for (AMRecord record : records) {
            this.remove(record);
        }
    }
}

