/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser.datamodel;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringInterner;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.history.parser.datamodel.BaseInfo;
import org.apache.tez.history.parser.datamodel.Container;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.history.parser.utils.Utils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TaskAttemptInfo
extends BaseInfo {
    private static final Log LOG = LogFactory.getLog(TaskAttemptInfo.class);
    private static final String SUCCEEDED = StringInterner.weakIntern((String)TaskAttemptState.SUCCEEDED.name());
    private final String taskAttemptId;
    private final long startTime;
    private final long endTime;
    private final String diagnostics;
    private final long creationTime;
    private final long allocationTime;
    private final String containerId;
    private final String nodeId;
    private final String status;
    private final String logUrl;
    private final String creationCausalTA;
    private final String terminationCause;
    private final long executionTimeInterval;
    private final ArrayList<DataDependencyEvent> lastDataEvents = Lists.newArrayList();
    private TaskInfo taskInfo;
    private Container container;

    TaskAttemptInfo(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        Preconditions.checkArgument((boolean)jsonObject.getString("entitytype").equalsIgnoreCase("TEZ_TASK_ATTEMPT_ID"));
        this.taskAttemptId = StringInterner.weakIntern((String)jsonObject.optString("entity"));
        JSONObject otherInfoNode = jsonObject.getJSONObject("otherinfo");
        long sTime = otherInfoNode.optLong("startTime");
        long eTime = otherInfoNode.optLong("endTime");
        if (eTime < sTime) {
            LOG.warn((Object)("TaskAttemptInfo has got wrong start/end values. startTime=" + sTime + ", endTime=" + eTime + ". Will check " + "timestamps in DAG started/finished events"));
            for (Event event : this.eventList) {
                switch (HistoryEventType.valueOf((String)event.getType())) {
                    case TASK_ATTEMPT_STARTED: {
                        sTime = event.getAbsoluteTime();
                        break;
                    }
                    case TASK_ATTEMPT_FINISHED: {
                        eTime = event.getAbsoluteTime();
                        break;
                    }
                }
            }
            if (eTime < sTime) {
                LOG.warn((Object)("TaskAttemptInfo has got wrong start/end values in events as well. startTime=" + sTime + ", endTime=" + eTime));
            }
        }
        this.startTime = sTime;
        this.endTime = eTime;
        this.diagnostics = otherInfoNode.optString("diagnostics");
        this.creationTime = otherInfoNode.optLong("creationTime");
        this.creationCausalTA = StringInterner.weakIntern((String)otherInfoNode.optString("creationCausalAttempt"));
        this.allocationTime = otherInfoNode.optLong("allocationTime");
        this.containerId = StringInterner.weakIntern((String)otherInfoNode.optString("containerId"));
        String id = otherInfoNode.optString("nodeId");
        this.nodeId = StringInterner.weakIntern((String)(id != null ? id.split(":")[0] : ""));
        this.logUrl = otherInfoNode.optString("completedLogsURL");
        this.status = StringInterner.weakIntern((String)otherInfoNode.optString("status"));
        this.container = new Container(this.containerId, this.nodeId);
        if (otherInfoNode.has("lastDataEvents")) {
            List<DataDependencyEvent> eventInfo = Utils.parseDataEventDependencyFromJSON(otherInfoNode.optJSONObject("lastDataEvents"));
            long lastTime = 0L;
            for (DataDependencyEvent item : eventInfo) {
                Preconditions.checkState((lastTime < item.getTimestamp() ? 1 : 0) != 0);
                lastTime = item.getTimestamp();
                this.lastDataEvents.add(item);
            }
        }
        this.terminationCause = StringInterner.weakIntern((String)otherInfoNode.optString("taskAttemptErrorEnum"));
        this.executionTimeInterval = this.endTime > this.startTime ? this.endTime - this.startTime : 0L;
    }

    public static Ordering<TaskAttemptInfo> orderingOnAllocationTime() {
        return Ordering.from((Comparator)new Comparator<TaskAttemptInfo>(){

            @Override
            public int compare(TaskAttemptInfo o1, TaskAttemptInfo o2) {
                return o1.getAllocationTime() < o2.getAllocationTime() ? -1 : (o1.getAllocationTime() > o2.getAllocationTime() ? 1 : 0);
            }
        });
    }

    void setTaskInfo(TaskInfo taskInfo) {
        Preconditions.checkArgument((taskInfo != null ? 1 : 0) != 0, (Object)"Provide valid taskInfo");
        this.taskInfo = taskInfo;
        taskInfo.addTaskAttemptInfo(this);
    }

    @Override
    public final long getStartTimeInterval() {
        return this.startTime - this.getTaskInfo().getVertexInfo().getDagInfo().getStartTime();
    }

    @Override
    public final long getFinishTimeInterval() {
        return this.endTime - this.getTaskInfo().getVertexInfo().getDagInfo().getStartTime();
    }

    public final boolean isSucceeded() {
        return this.status.equals(SUCCEEDED);
    }

    public final List<DataDependencyEvent> getLastDataEvents() {
        return this.lastDataEvents;
    }

    public final long getExecutionTimeInterval() {
        return this.executionTimeInterval;
    }

    public final long getPostDataExecutionTimeInterval() {
        if (this.getStartTime() > 0L && this.getFinishTime() > 0L) {
            long postDataStartTime = this.startTime;
            if (this.getLastDataEvents() != null && !this.getLastDataEvents().isEmpty()) {
                long lastEventTime = this.getLastDataEvents().get(this.getLastDataEvents().size() - 1).getTimestamp();
                postDataStartTime = this.startTime > lastEventTime ? this.startTime : lastEventTime;
            }
            return this.getFinishTime() - postDataStartTime;
        }
        return -1L;
    }

    public final long getAllocationToEndTimeInterval() {
        return this.endTime - this.allocationTime;
    }

    public final long getAllocationToStartTimeInterval() {
        return this.startTime - this.allocationTime;
    }

    public final long getCreationToAllocationTimeInterval() {
        return this.allocationTime - this.creationTime;
    }

    @Override
    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public final long getFinishTime() {
        return this.endTime;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final DataDependencyEvent getLastDataEventInfo(long timeThreshold) {
        for (int i = this.lastDataEvents.size() - 1; i >= 0; --i) {
            DataDependencyEvent item = this.lastDataEvents.get(i);
            if (item.getTimestamp() >= timeThreshold) continue;
            return item;
        }
        return null;
    }

    public final long getTimeTaken() {
        return this.getFinishTimeInterval() - this.getStartTimeInterval();
    }

    public final long getCreationTimeInterval() {
        return this.creationTime - this.getTaskInfo().getVertexInfo().getDagInfo().getStartTime();
    }

    public final String getCreationCausalTA() {
        return this.creationCausalTA;
    }

    public final long getAllocationTime() {
        return this.allocationTime;
    }

    public final String getShortName() {
        return this.getTaskInfo().getVertexInfo().getVertexName() + " : " + this.taskAttemptId.substring(this.taskAttemptId.lastIndexOf(95, this.taskAttemptId.lastIndexOf(95) - 1) + 1);
    }

    @Override
    public final String getDiagnostics() {
        return this.diagnostics;
    }

    public final String getTerminationCause() {
        return this.terminationCause;
    }

    public static TaskAttemptInfo create(JSONObject taskInfoObject) throws JSONException {
        return new TaskAttemptInfo(taskInfoObject);
    }

    public final boolean isLocalityInfoAvailable() {
        Map<String, TezCounter> dataLocalTask = this.getCounter(DAGCounter.class.getName(), DAGCounter.DATA_LOCAL_TASKS.toString());
        Map<String, TezCounter> rackLocalTask = this.getCounter(DAGCounter.class.getName(), DAGCounter.RACK_LOCAL_TASKS.toString());
        Map<String, TezCounter> otherLocalTask = this.getCounter(DAGCounter.class.getName(), DAGCounter.OTHER_LOCAL_TASKS.toString());
        return !dataLocalTask.isEmpty() || !rackLocalTask.isEmpty() || !otherLocalTask.isEmpty();
    }

    public final String getDetailedStatus() {
        if (!Strings.isNullOrEmpty((String)this.getTerminationCause())) {
            return this.getStatus() + ":" + this.getTerminationCause();
        }
        return this.getStatus();
    }

    public final TezCounter getLocalityInfo() {
        Map<String, TezCounter> dataLocalTask = this.getCounter(DAGCounter.class.getName(), DAGCounter.DATA_LOCAL_TASKS.toString());
        Map<String, TezCounter> rackLocalTask = this.getCounter(DAGCounter.class.getName(), DAGCounter.RACK_LOCAL_TASKS.toString());
        Map<String, TezCounter> otherLocalTask = this.getCounter(DAGCounter.class.getName(), DAGCounter.OTHER_LOCAL_TASKS.toString());
        if (!dataLocalTask.isEmpty()) {
            return dataLocalTask.get(DAGCounter.class.getName());
        }
        if (!rackLocalTask.isEmpty()) {
            return rackLocalTask.get(DAGCounter.class.getName());
        }
        if (!otherLocalTask.isEmpty()) {
            return otherLocalTask.get(DAGCounter.class.getName());
        }
        return null;
    }

    public final TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public final String getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public final String getNodeId() {
        return this.nodeId;
    }

    public final String getStatus() {
        return this.status;
    }

    public final Container getContainer() {
        return this.container;
    }

    public final String getLogURL() {
        return this.logUrl;
    }

    public final Map<String, TezCounter> getMergePhaseTime() {
        return this.getCounter(null, TaskCounter.MERGE_PHASE_TIME.name());
    }

    public final Map<String, TezCounter> getShufflePhaseTime() {
        return this.getCounter(null, TaskCounter.SHUFFLE_PHASE_TIME.name());
    }

    public final Map<String, TezCounter> getTaskOutputBytes() {
        return this.getCounter(null, TaskCounter.OUTPUT_BYTES.name());
    }

    public final Map<String, Float> getSpillCount() {
        Map<String, TezCounter> outputRecords = this.getCounter(null, "OUTPUT_RECORDS");
        Map<String, TezCounter> spilledRecords = this.getCounter(null, "SPILLED_RECORDS");
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, TezCounter> entry : spilledRecords.entrySet()) {
            String source = entry.getKey();
            long spilledVal = entry.getValue().getValue();
            long outputVal = outputRecords.get(source).getValue();
            result.put(source, Float.valueOf((float)spilledVal * 1.0f / ((float)outputVal * 1.0f)));
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("taskAttemptId=").append(this.getTaskAttemptId()).append(", ");
        sb.append("creationTime=").append(this.getCreationTimeInterval()).append(", ");
        sb.append("startTime=").append(this.getStartTimeInterval()).append(", ");
        sb.append("finishTime=").append(this.getFinishTimeInterval()).append(", ");
        sb.append("timeTaken=").append(this.getTimeTaken()).append(", ");
        sb.append("events=").append(this.getEvents()).append(", ");
        sb.append("diagnostics=").append(this.getDiagnostics()).append(", ");
        sb.append("container=").append(this.getContainer()).append(", ");
        sb.append("nodeId=").append(this.getNodeId()).append(", ");
        sb.append("logURL=").append(this.getLogURL()).append(", ");
        sb.append("status=").append(this.getStatus());
        sb.append("]");
        return sb.toString();
    }

    public static class DataDependencyEvent {
        String taId;
        long timestamp;

        public DataDependencyEvent(String id, long time) {
            this.taId = id;
            this.timestamp = time;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getTaskAttemptId() {
            return this.taId;
        }
    }
}

