/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser.datamodel;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringInterner;
import org.apache.tez.client.CallerContext;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.history.parser.datamodel.AdditionalInputOutputDetails;
import org.apache.tez.history.parser.datamodel.BaseInfo;
import org.apache.tez.history.parser.datamodel.Container;
import org.apache.tez.history.parser.datamodel.EdgeInfo;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VersionInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DagInfo
extends BaseInfo {
    private static final Log LOG = LogFactory.getLog(DagInfo.class);
    private final String name;
    private final long startTime;
    private final long endTime;
    private final long submitTime;
    private final int failedTasks;
    private final String dagId;
    private final int numVertices;
    private final String status;
    private final String diagnostics;
    private String userName;
    private VersionInfo versionInfo;
    private CallerContext callerContext;
    private final BidiMap vertexNameIDMapping;
    private final Map<Integer, EdgeInfo> edgeInfoMap;
    private Map<String, BasicVertexInfo> basicVertexInfoMap;
    private Map<String, VertexInfo> vertexNameMap = Maps.newHashMap();
    private Multimap<Container, TaskAttemptInfo> containerMapping;
    private Map<String, String> config;

    DagInfo(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        this.vertexNameIDMapping = new DualHashBidiMap();
        this.edgeInfoMap = Maps.newHashMap();
        this.basicVertexInfoMap = Maps.newHashMap();
        this.containerMapping = LinkedHashMultimap.create();
        Preconditions.checkArgument((boolean)jsonObject.getString("entitytype").equalsIgnoreCase("TEZ_DAG_ID"));
        this.dagId = StringInterner.weakIntern((String)jsonObject.getString("entity"));
        JSONObject otherInfoNode = jsonObject.getJSONObject("otherinfo");
        long sTime = otherInfoNode.optLong("startTime");
        long eTime = otherInfoNode.optLong("endTime");
        this.userName = otherInfoNode.optString("user");
        if (eTime < sTime) {
            LOG.warn((Object)("DAG has got wrong start/end values. startTime=" + sTime + ", endTime=" + eTime + ". Will check " + "timestamps in DAG started/finished events"));
            for (Event event : this.eventList) {
                switch (HistoryEventType.valueOf((String)event.getType())) {
                    case DAG_STARTED: {
                        sTime = event.getAbsoluteTime();
                        break;
                    }
                    case DAG_FINISHED: {
                        eTime = event.getAbsoluteTime();
                        break;
                    }
                }
            }
            if (eTime < sTime) {
                LOG.warn((Object)("DAG has got wrong start/end values in events as well. startTime=" + sTime + ", endTime=" + eTime));
            }
        }
        this.startTime = sTime;
        this.endTime = eTime;
        this.submitTime = otherInfoNode.optLong("startRequestedTime");
        this.diagnostics = otherInfoNode.optString("diagnostics");
        this.failedTasks = otherInfoNode.optInt("numFailedTasks");
        JSONObject dagPlan = otherInfoNode.optJSONObject("dagPlan");
        this.name = StringInterner.weakIntern(dagPlan != null ? dagPlan.optString("dagName") : null);
        if (dagPlan != null) {
            JSONArray vertices = dagPlan.optJSONArray("vertices");
            this.numVertices = vertices != null ? vertices.length() : 0;
            this.parseDAGPlan(dagPlan);
        } else {
            this.numVertices = 0;
        }
        this.status = StringInterner.weakIntern((String)otherInfoNode.optString("status"));
        JSONObject vertexIDMappingJson = otherInfoNode.optJSONObject("vertexNameIdMapping");
        if (vertexIDMappingJson != null) {
            for (Map.Entry<String, BasicVertexInfo> entry : this.basicVertexInfoMap.entrySet()) {
                String vertexId = vertexIDMappingJson.optString(entry.getKey());
                this.vertexNameIDMapping.put((Object)entry.getKey(), (Object)vertexId);
            }
        }
    }

    public static DagInfo create(JSONObject jsonObject) throws JSONException {
        DagInfo dagInfo = new DagInfo(jsonObject);
        return dagInfo;
    }

    private void parseDAGPlan(JSONObject dagPlan) throws JSONException {
        int version = dagPlan.optInt("version", 1);
        this.parseEdges(dagPlan.optJSONArray("edges"));
        JSONArray verticesInfo = dagPlan.optJSONArray("vertices");
        this.parseBasicVertexInfo(verticesInfo);
        if (version > 1) {
            this.parseDAGContext(dagPlan.optJSONObject("dagContext"));
        }
    }

    private void parseDAGContext(JSONObject callerContextInfo) {
        if (callerContextInfo == null) {
            LOG.info((Object)"No DAG Caller Context available");
            return;
        }
        String context = callerContextInfo.optString("context");
        String callerId = callerContextInfo.optString("callerId");
        String callerType = callerContextInfo.optString("callerType");
        String description = callerContextInfo.optString("description");
        this.callerContext = CallerContext.create((String)context, (String)description);
        if (callerId != null && !callerId.isEmpty() && callerType != null && !callerType.isEmpty()) {
            this.callerContext.setCallerIdAndType(callerId, callerType);
        } else {
            LOG.info((Object)"No DAG Caller Context Id and Type available");
        }
    }

    private void parseBasicVertexInfo(JSONArray verticesInfo) throws JSONException {
        if (verticesInfo == null) {
            LOG.info((Object)"No vertices available.");
            return;
        }
        for (int i = 0; i < verticesInfo.length(); ++i) {
            JSONArray outEdges;
            BasicVertexInfo basicVertexInfo = new BasicVertexInfo();
            JSONObject vJson = verticesInfo.getJSONObject(i);
            basicVertexInfo.vertexName = vJson.optString("vertexName");
            JSONArray inEdges = vJson.optJSONArray("inEdgeIds");
            if (inEdges != null) {
                String[] inEdgeIds = new String[inEdges.length()];
                for (int j = 0; j < inEdges.length(); ++j) {
                    inEdgeIds[j] = inEdges.get(j).toString();
                }
                basicVertexInfo.inEdgeIds = inEdgeIds;
            }
            if ((outEdges = vJson.optJSONArray("outEdgeIds")) != null) {
                String[] outEdgeIds = new String[outEdges.length()];
                for (int j = 0; j < outEdges.length(); ++j) {
                    outEdgeIds[j] = outEdges.get(j).toString();
                }
                basicVertexInfo.outEdgeIds = outEdgeIds;
            }
            JSONArray addInputsJson = vJson.optJSONArray("additionalInputs");
            basicVertexInfo.additionalInputs = this.parseAdditionalDetailsForVertex(addInputsJson);
            JSONArray addOutputsJson = vJson.optJSONArray("additionalOutputs");
            basicVertexInfo.additionalOutputs = this.parseAdditionalDetailsForVertex(addOutputsJson);
            this.basicVertexInfoMap.put(basicVertexInfo.vertexName, basicVertexInfo);
        }
    }

    private AdditionalInputOutputDetails[] parseAdditionalDetailsForVertex(JSONArray jsonArray) throws JSONException {
        if (jsonArray != null) {
            AdditionalInputOutputDetails[] additionalInputOutputDetails = new AdditionalInputOutputDetails[jsonArray.length()];
            for (int j = 0; j < jsonArray.length(); ++j) {
                String name = jsonArray.getJSONObject(j).optString("name");
                String clazz = jsonArray.getJSONObject(j).optString("class");
                String initializer = jsonArray.getJSONObject(j).optString("initializer");
                String userPayloadText = jsonArray.getJSONObject(j).optString("userPayloadAsText");
                additionalInputOutputDetails[j] = new AdditionalInputOutputDetails(name, clazz, initializer, userPayloadText);
            }
            return additionalInputOutputDetails;
        }
        return null;
    }

    private void parseEdges(JSONArray edgesArray) throws JSONException {
        if (edgesArray == null) {
            return;
        }
        for (int i = 0; i < edgesArray.length(); ++i) {
            JSONObject edge = edgesArray.getJSONObject(i);
            Integer edgeId = edge.optInt("edgeId");
            String inputVertexName = edge.optString("inputVertexName");
            String outputVertexName = edge.optString("outputVertexName");
            String dataMovementType = edge.optString("dataMovementType");
            String edgeSourceClass = edge.optString("edgeSourceClass");
            String edgeDestinationClass = edge.optString("edgeDestinationClass");
            String inputUserPayloadAsText = edge.optString("inputUserPayloadAsText");
            String outputUserPayloadAsText = edge.optString("outputUserPayloadAsText");
            EdgeInfo edgeInfo = new EdgeInfo(inputVertexName, outputVertexName, dataMovementType, edgeSourceClass, edgeDestinationClass, inputUserPayloadAsText, outputUserPayloadAsText);
            this.edgeInfoMap.put(edgeId, edgeInfo);
        }
    }

    void addVertexInfo(VertexInfo vertexInfo) {
        EdgeInfo edgeInfo;
        BasicVertexInfo basicVertexInfo = this.basicVertexInfoMap.get(vertexInfo.getVertexName());
        Preconditions.checkArgument((basicVertexInfo != null ? 1 : 0) != 0, (Object)("VerteName " + vertexInfo.getVertexName() + " not present in DAG's vertices " + this.basicVertexInfoMap.entrySet()));
        if (basicVertexInfo.additionalInputs != null) {
            vertexInfo.setAdditionalInputInfoList(Arrays.asList(basicVertexInfo.additionalInputs));
        }
        if (basicVertexInfo.additionalOutputs != null) {
            vertexInfo.setAdditionalOutputInfoList(Arrays.asList(basicVertexInfo.additionalOutputs));
        }
        if (basicVertexInfo.inEdgeIds != null) {
            for (String edge : basicVertexInfo.inEdgeIds) {
                edgeInfo = this.edgeInfoMap.get(Integer.parseInt(edge));
                Preconditions.checkState((edgeInfo != null ? 1 : 0) != 0, (Object)("EdgeId " + edge + " not present in DAG"));
                vertexInfo.addInEdge(edgeInfo);
            }
        }
        if (basicVertexInfo.outEdgeIds != null) {
            for (String edge : basicVertexInfo.outEdgeIds) {
                edgeInfo = this.edgeInfoMap.get(Integer.parseInt(edge));
                Preconditions.checkState((edgeInfo != null ? 1 : 0) != 0, (Object)("EdgeId " + edge + " not present in DAG"));
                vertexInfo.addOutEdge(edgeInfo);
            }
        }
        this.vertexNameMap.put(vertexInfo.getVertexName(), vertexInfo);
    }

    void setAppConfig(Map<String, String> config) {
        this.config = config;
    }

    public Map<String, String> getAppConfig() {
        return this.config != null ? Collections.unmodifiableMap(this.config) : null;
    }

    void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    void addContainerMapping(Container container, TaskAttemptInfo taskAttemptInfo) {
        this.containerMapping.put((Object)container, (Object)taskAttemptInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("dagID=").append(this.getDagId()).append(", ");
        sb.append("dagName=").append(this.getName()).append(", ");
        sb.append("status=").append(this.getStatus()).append(", ");
        sb.append("startTime=").append(this.getStartTimeInterval()).append(", ");
        sb.append("submitTime=").append(this.getSubmitTime()).append(", ");
        sb.append("endTime=").append(this.getFinishTimeInterval()).append(", ");
        sb.append("timeTaken=").append(this.getTimeTaken()).append(", ");
        sb.append("diagnostics=").append(this.getDiagnostics()).append(", ");
        sb.append("vertexNameIDMapping=").append(this.getVertexNameIDMapping()).append(", ");
        sb.append("failedTasks=").append(this.getFailedTaskCount()).append(", ");
        sb.append("events=").append(this.getEvents()).append(", ");
        sb.append("status=").append(this.getStatus());
        sb.append("]");
        return sb.toString();
    }

    public Multimap<Container, TaskAttemptInfo> getContainerMapping() {
        return Multimaps.unmodifiableMultimap(this.containerMapping);
    }

    public final VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public final CallerContext getCallerContext() {
        return this.callerContext;
    }

    public final String getName() {
        return this.name;
    }

    public final Collection<EdgeInfo> getEdges() {
        return Collections.unmodifiableCollection(this.edgeInfoMap.values());
    }

    public final long getSubmitTime() {
        return this.submitTime;
    }

    @Override
    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public final long getFinishTime() {
        return this.endTime;
    }

    @Override
    public final long getStartTimeInterval() {
        return 0L;
    }

    @Override
    public final long getFinishTimeInterval() {
        long dagEndTime = this.endTime - this.startTime;
        if (dagEndTime < 0L) {
            for (VertexInfo vertexInfo : this.getVertices()) {
                dagEndTime = vertexInfo.getFinishTimeInterval() > dagEndTime ? vertexInfo.getFinishTimeInterval() : dagEndTime;
            }
        }
        return dagEndTime;
    }

    public final long getTimeTaken() {
        return this.getFinishTimeInterval();
    }

    public final String getStatus() {
        return this.status;
    }

    public VertexInfo getVertexFromId(String vertexId) {
        return this.vertexNameMap.get(this.vertexNameIDMapping.getKey((Object)vertexId));
    }

    public final VertexInfo getVertex(String vertexName) {
        return this.vertexNameMap.get(vertexName);
    }

    @Override
    public final String getDiagnostics() {
        return this.diagnostics;
    }

    public final List<VertexInfo> getVertices() {
        LinkedList vertices = Lists.newLinkedList(this.vertexNameMap.values());
        Collections.sort(vertices, new Comparator<VertexInfo>(){

            @Override
            public int compare(VertexInfo o1, VertexInfo o2) {
                return o1.getStartTimeInterval() < o2.getStartTimeInterval() ? -1 : (o1.getStartTimeInterval() == o2.getStartTimeInterval() ? 0 : 1);
            }
        });
        return Collections.unmodifiableList(vertices);
    }

    public final List<VertexInfo> getFailedVertices() {
        return this.getVertices(VertexState.FAILED);
    }

    public final List<VertexInfo> getKilledVertices() {
        return this.getVertices(VertexState.KILLED);
    }

    public final List<VertexInfo> getSuccessfullVertices() {
        return this.getVertices(VertexState.SUCCEEDED);
    }

    public final List<VertexInfo> getVertices(final VertexState state) {
        return Collections.unmodifiableList(Lists.newLinkedList((Iterable)Iterables.filter((Iterable)Lists.newLinkedList(this.vertexNameMap.values()), (Predicate)new Predicate<VertexInfo>(){

            public boolean apply(VertexInfo input) {
                return input.getStatus() != null && input.getStatus().equals(state.toString());
            }
        })));
    }

    public final Map<String, VertexInfo> getVertexMapping() {
        return Collections.unmodifiableMap(this.vertexNameMap);
    }

    private Ordering<VertexInfo> getVertexOrdering() {
        return Ordering.from((Comparator)new Comparator<VertexInfo>(){

            @Override
            public int compare(VertexInfo o1, VertexInfo o2) {
                return o1.getTimeTaken() < o2.getTimeTaken() ? -1 : (o1.getTimeTaken() == o2.getTimeTaken() ? 0 : 1);
            }
        });
    }

    public final VertexInfo getSlowestVertex() {
        List<VertexInfo> vertexInfoList = this.getVertices();
        if (vertexInfoList.size() == 0) {
            return null;
        }
        return (VertexInfo)this.getVertexOrdering().max(vertexInfoList);
    }

    public final VertexInfo getFastestVertex() {
        List<VertexInfo> vertexInfoList = this.getVertices();
        if (vertexInfoList.size() == 0) {
            return null;
        }
        return (VertexInfo)this.getVertexOrdering().min(vertexInfoList);
    }

    public final Multimap<String, TaskAttemptInfo> getNodeDetails() {
        LinkedListMultimap nodeDetails = LinkedListMultimap.create();
        for (VertexInfo vertexInfo : this.getVertices()) {
            Multimap<Container, TaskAttemptInfo> containerMapping = vertexInfo.getContainersMapping();
            for (Map.Entry entry : containerMapping.entries()) {
                nodeDetails.put((Object)((Container)entry.getKey()).getHost(), entry.getValue());
            }
        }
        return nodeDetails;
    }

    public final Multimap<Container, TaskAttemptInfo> getContainersToTaskAttemptMapping() {
        List<VertexInfo> VertexInfoList = this.getVertices();
        LinkedHashMultimap containerMapping = LinkedHashMultimap.create();
        for (VertexInfo vertexInfo : VertexInfoList) {
            containerMapping.putAll(vertexInfo.getContainersMapping());
        }
        return Multimaps.unmodifiableMultimap((Multimap)containerMapping);
    }

    public final Map getVertexNameIDMapping() {
        return this.vertexNameIDMapping;
    }

    public final int getNumVertices() {
        return this.numVertices;
    }

    public final String getDagId() {
        return this.dagId;
    }

    public final int getFailedTaskCount() {
        return this.failedTasks;
    }

    public final String getUserName() {
        return this.userName;
    }

    final void setUserName(String userName) {
        this.userName = userName;
    }

    static class BasicVertexInfo {
        String vertexName;
        String[] inEdgeIds;
        String[] outEdgeIds;
        AdditionalInputOutputDetails[] additionalInputs;
        AdditionalInputOutputDetails[] additionalOutputs;

        BasicVertexInfo() {
        }
    }
}

