/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.history.parser.datamodel.BaseParser;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHistoryParser
extends BaseParser {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHistoryParser.class);
    private static final String UTF8 = "UTF-8";
    private final File historyFile;

    public SimpleHistoryParser(File historyFile) {
        Preconditions.checkArgument((boolean)historyFile.exists(), (Object)(historyFile + " does not exist"));
        this.historyFile = historyFile;
    }

    public DagInfo getDAGData(String dagId) throws TezException {
        try {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dagId) ? 1 : 0) != 0, (Object)"Please provide valid dagId");
            dagId = dagId.trim();
            this.parseContents(this.historyFile, dagId);
            this.linkParsedContents();
            return this.dagInfo;
        }
        catch (IOException e) {
            LOG.error("Error in reading DAG ", (Throwable)e);
            throw new TezException((Throwable)e);
        }
        catch (JSONException e) {
            LOG.error("Error in parsing DAG ", (Throwable)e);
            throw new TezException((Throwable)e);
        }
    }

    private void populateOtherInfo(JSONObject source, JSONObject destination) throws JSONException {
        if (source == null || destination == null) {
            return;
        }
        Iterator it = source.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object val = source.get(key);
            destination.put(key, val);
        }
    }

    private void populateOtherInfo(JSONObject source, String entityName, Map<String, JSONObject> destMap) throws JSONException {
        JSONObject destinationJson = destMap.get(entityName);
        JSONObject destOtherInfo = destinationJson.getJSONObject("otherinfo");
        this.populateOtherInfo(source, destOtherInfo);
    }

    private void parseContents(File historyFile, String dagId) throws JSONException, FileNotFoundException, TezException {
        Scanner scanner = new Scanner(historyFile, UTF8);
        scanner.useDelimiter(SimpleHistoryLoggingService.RECORD_SEPARATOR);
        JSONObject dagJson = null;
        HashMap vertexJsonMap = Maps.newHashMap();
        HashMap taskJsonMap = Maps.newHashMap();
        HashMap attemptJsonMap = Maps.newHashMap();
        TezDAGID tezDAGID = TezDAGID.fromString((String)dagId);
        String userName = null;
        while (scanner.hasNext()) {
            String entityType;
            String line = scanner.next();
            JSONObject jsonObject = new JSONObject(line);
            String entity = jsonObject.getString("entity");
            switch (entityType = jsonObject.getString("entitytype")) {
                case "TEZ_DAG_ID": {
                    if (!dagId.equals(entity)) {
                        LOG.warn(dagId + " is not matching with " + entity);
                        break;
                    }
                    if (dagJson == null) {
                        dagJson = jsonObject;
                    }
                    JSONObject otherInfo = jsonObject.optJSONObject("otherinfo");
                    JSONObject dagOtherInfo = dagJson.getJSONObject("otherinfo");
                    JSONArray relatedEntities = dagJson.optJSONArray("relatedEntities");
                    if (relatedEntities != null) {
                        for (int i = 0; i < relatedEntities.length(); ++i) {
                            JSONObject subEntity = relatedEntities.getJSONObject(i);
                            String subEntityType = subEntity.optString("entitytype");
                            if (subEntityType == null || !subEntityType.equals("user")) continue;
                            userName = subEntity.getString("entity");
                            break;
                        }
                    }
                    this.populateOtherInfo(otherInfo, dagOtherInfo);
                    break;
                }
                case "TEZ_VERTEX_ID": {
                    String vertexName = entity;
                    TezVertexID tezVertexID = TezVertexID.fromString((String)vertexName);
                    if (!tezDAGID.equals((Object)tezVertexID.getDAGId())) {
                        LOG.warn(vertexName + " does not belong to " + tezDAGID);
                        break;
                    }
                    if (!vertexJsonMap.containsKey(vertexName)) {
                        vertexJsonMap.put(vertexName, jsonObject);
                    }
                    JSONObject otherInfo = jsonObject.optJSONObject("otherinfo");
                    this.populateOtherInfo(otherInfo, vertexName, vertexJsonMap);
                    break;
                }
                case "TEZ_TASK_ID": {
                    String taskName = entity;
                    TezTaskID tezTaskID = TezTaskID.fromString((String)taskName);
                    if (!tezDAGID.equals((Object)tezTaskID.getVertexID().getDAGId())) {
                        LOG.warn(taskName + " does not belong to " + tezDAGID);
                        break;
                    }
                    if (!taskJsonMap.containsKey(taskName)) {
                        taskJsonMap.put(taskName, jsonObject);
                    }
                    JSONObject otherInfo = jsonObject.optJSONObject("otherinfo");
                    this.populateOtherInfo(otherInfo, taskName, taskJsonMap);
                    break;
                }
                case "TEZ_TASK_ATTEMPT_ID": {
                    String taskAttemptName = entity;
                    TezTaskAttemptID tezAttemptId = TezTaskAttemptID.fromString((String)taskAttemptName);
                    if (!tezDAGID.equals((Object)tezAttemptId.getTaskID().getVertexID().getDAGId())) {
                        LOG.warn(taskAttemptName + " does not belong to " + tezDAGID);
                        break;
                    }
                    if (!attemptJsonMap.containsKey(taskAttemptName)) {
                        attemptJsonMap.put(taskAttemptName, jsonObject);
                    }
                    JSONObject otherInfo = jsonObject.optJSONObject("otherinfo");
                    this.populateOtherInfo(otherInfo, taskAttemptName, attemptJsonMap);
                    break;
                }
            }
        }
        scanner.close();
        if (dagJson == null) {
            LOG.error("Dag is not yet parsed. Looks like partial file.");
            throw new TezException("Please provide a valid/complete history log file containing " + dagId);
        }
        this.dagInfo = DagInfo.create(dagJson);
        this.setUserName(userName);
        for (JSONObject jsonObject : vertexJsonMap.values()) {
            VertexInfo vertexInfo = VertexInfo.create(jsonObject);
            this.vertexList.add(vertexInfo);
            LOG.debug("Parsed vertex {}", (Object)vertexInfo.getVertexName());
        }
        for (JSONObject jsonObject : taskJsonMap.values()) {
            TaskInfo taskInfo = TaskInfo.create(jsonObject);
            this.taskList.add(taskInfo);
            LOG.debug("Parsed task {}", (Object)taskInfo.getTaskId());
        }
        for (JSONObject jsonObject : attemptJsonMap.values()) {
            JSONArray relatedEntities = jsonObject.optJSONArray("relatedEntities");
            if (relatedEntities == null) {
                LOG.debug("entity {} did not have related entities", (Object)jsonObject.optJSONObject("entity"));
            } else {
                String containerId;
                JSONObject otherInfo;
                String nodeId;
                JSONObject subJsonObject = relatedEntities.optJSONObject(0);
                if (subJsonObject != null && !Strings.isNullOrEmpty((String)(nodeId = subJsonObject.optString("entitytype"))) && nodeId.equalsIgnoreCase("nodeId")) {
                    otherInfo = jsonObject.optJSONObject("otherinfo");
                    String nodeIdVal = subJsonObject.optString("entity");
                    if (otherInfo != null && nodeIdVal != null) {
                        otherInfo.put("nodeId", (Object)nodeIdVal);
                    }
                }
                if ((subJsonObject = relatedEntities.optJSONObject(1)) != null && !Strings.isNullOrEmpty((String)(containerId = subJsonObject.optString("entitytype"))) && containerId.equalsIgnoreCase("containerId")) {
                    otherInfo = jsonObject.optJSONObject("otherinfo");
                    String containerIdVal = subJsonObject.optString("entity");
                    if (otherInfo != null && containerIdVal != null) {
                        otherInfo.put("containerId", (Object)containerIdVal);
                    }
                }
            }
            TaskAttemptInfo attemptInfo = TaskAttemptInfo.create(jsonObject);
            this.attemptList.add(attemptInfo);
            LOG.debug("Parsed task attempt {}", (Object)attemptInfo.getTaskAttemptId());
        }
    }
}

