/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.log4j;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.LogData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.SimpleMessageFormatter;
import java.util.logging.Level;

final class LogDataFormatter {
    private LogDataFormatter() {
    }

    static void format(LogData logData, SimpleMessageFormatter.SimpleLogHandler receiver) {
        SimpleMessageFormatter.format(logData, receiver);
    }

    static void formatBadLogData(RuntimeException error, LogData badLogData, SimpleMessageFormatter.SimpleLogHandler receiver) {
        StringBuilder errorMsg = new StringBuilder("LOGGING ERROR: ").append(error.getMessage()).append('\n');
        int length = errorMsg.length();
        try {
            LogDataFormatter.appendLogData(badLogData, errorMsg);
        }
        catch (RuntimeException e) {
            errorMsg.setLength(length);
            errorMsg.append("Cannot append LogData: ").append(e);
        }
        Level level = badLogData.getLevel().intValue() < Level.WARNING.intValue() ? Level.WARNING : badLogData.getLevel();
        receiver.handleFormattedLogMessage(level, errorMsg.toString(), error);
    }

    static void appendLogData(LogData data, StringBuilder out) {
        out.append("  original message: ");
        if (data.getTemplateContext() == null) {
            out.append(data.getLiteralArgument());
        } else {
            out.append(data.getTemplateContext().getMessage());
            out.append("\n  original arguments:");
            for (Object arg : data.getArguments()) {
                out.append("\n    ").append(SimpleMessageFormatter.safeToString(arg));
            }
        }
        Metadata metadata = data.getMetadata();
        if (metadata.size() > 0) {
            out.append("\n  metadata:");
            for (int n = 0; n < metadata.size(); ++n) {
                out.append("\n    ");
                out.append(metadata.getKey(n).getLabel()).append(": ").append(metadata.getValue(n));
            }
        }
        out.append("\n  level: ").append(data.getLevel());
        out.append("\n  timestamp (nanos): ").append(data.getTimestampNanos());
        out.append("\n  class: ").append(data.getLogSite().getClassName());
        out.append("\n  method: ").append(data.getLogSite().getMethodName());
        out.append("\n  line number: ").append(data.getLogSite().getLineNumber());
    }
}

