/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.FormatChar;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.parser.ParseException;
import javax.annotation.Nullable;

public final class FormatOptions {
    private static final int MAX_ALLOWED_WIDTH = 999999;
    private static final int MAX_ALLOWED_PRECISION = 999999;
    private static final String FLAG_CHARS_ORDERED = " #(+,-0";
    private static final int MIN_FLAG_VALUE = 32;
    private static final int MAX_FLAG_VALUE = 48;
    private static final long ENCODED_FLAG_INDICES;
    public static final int FLAG_PREFIX_SPACE_FOR_POSITIVE_VALUES = 1;
    public static final int FLAG_SHOW_ALT_FORM = 2;
    public static final int FLAG_USE_PARENS_FOR_NEGATIVE_VALUES = 4;
    public static final int FLAG_PREFIX_PLUS_FOR_POSITIVE_VALUES = 8;
    public static final int FLAG_SHOW_GROUPING = 16;
    public static final int FLAG_LEFT_ALIGN = 32;
    public static final int FLAG_SHOW_LEADING_ZEROS = 64;
    public static final int FLAG_UPPER_CASE = 128;
    public static final int ALL_FLAGS = 255;
    public static final int UNSET = -1;
    private static final FormatOptions DEFAULT;
    private final int flags;
    private final int width;
    private final int precision;

    private static int indexOfFlagCharacter(char c) {
        return (int)(ENCODED_FLAG_INDICES >>> 3 * (c - 32) & 7L) - 1;
    }

    public static FormatOptions getDefault() {
        return DEFAULT;
    }

    public static FormatOptions of(int flags, int width, int precision) {
        if (!FormatOptions.checkFlagConsistency(flags, width != -1)) {
            throw new IllegalArgumentException("invalid flags: 0x" + Integer.toHexString(flags));
        }
        if ((width < 1 || width > 999999) && width != -1) {
            throw new IllegalArgumentException("invalid width: " + width);
        }
        if ((precision < 0 || precision > 999999) && precision != -1) {
            throw new IllegalArgumentException("invalid precision: " + precision);
        }
        return new FormatOptions(flags, width, precision);
    }

    public static FormatOptions parse(String message, int pos, int end, boolean isUpperCase) throws ParseException {
        char n;
        char c;
        int flags;
        if (pos == end && !isUpperCase) {
            return DEFAULT;
        }
        int n2 = flags = isUpperCase ? 128 : 0;
        while (true) {
            if (pos == end) {
                return new FormatOptions(flags, -1, -1);
            }
            if ((c = message.charAt(pos++)) < ' ' || c > '0') break;
            int flagIdx = FormatOptions.indexOfFlagCharacter(c);
            if (flagIdx < 0) {
                if (c == '.') {
                    return new FormatOptions(flags, -1, FormatOptions.parsePrecision(message, pos, end));
                }
                throw ParseException.atPosition("invalid flag", message, pos - 1);
            }
            int flagBit = 1 << flagIdx;
            if ((flags & flagBit) != 0) {
                throw ParseException.atPosition("repeated flag", message, pos - 1);
            }
            flags |= flagBit;
        }
        int widthStart = pos - 1;
        if (c > '9') {
            throw ParseException.atPosition("invalid flag", message, widthStart);
        }
        int width = c - 48;
        do {
            if (pos == end) {
                return new FormatOptions(flags, width, -1);
            }
            if ((c = message.charAt(pos++)) == '.') {
                return new FormatOptions(flags, width, FormatOptions.parsePrecision(message, pos, end));
            }
            n = (char)(c - 48);
            if (n < '\n') continue;
            throw ParseException.atPosition("invalid width character", message, pos - 1);
        } while ((width = width * 10 + n) <= 999999);
        throw ParseException.withBounds("width too large", message, widthStart, end);
    }

    private static int parsePrecision(String message, int start, int end) throws ParseException {
        if (start == end) {
            throw ParseException.atPosition("missing precision", message, start - 1);
        }
        int precision = 0;
        for (int pos = start; pos < end; ++pos) {
            char n = (char)(message.charAt(pos) - 48);
            if (n >= '\n') {
                throw ParseException.atPosition("invalid precision character", message, pos);
            }
            if ((precision = precision * 10 + n) <= 999999) continue;
            throw ParseException.withBounds("precision too large", message, start, end);
        }
        if (precision == 0 && end != start + 1) {
            throw ParseException.withBounds("invalid precision", message, start, end);
        }
        return precision;
    }

    static int parseValidFlags(String flagChars, boolean hasUpperVariant) {
        int flags = hasUpperVariant ? 128 : 0;
        for (int i = 0; i < flagChars.length(); ++i) {
            int flagIdx = FormatOptions.indexOfFlagCharacter(flagChars.charAt(i));
            if (flagIdx < 0) {
                throw new IllegalArgumentException("invalid flags: " + flagChars);
            }
            flags |= 1 << flagIdx;
        }
        return flags;
    }

    private FormatOptions(int flags, int width, int precision) {
        this.flags = flags;
        this.width = width;
        this.precision = precision;
    }

    public FormatOptions filter(int allowedFlags, boolean allowWidth, boolean allowPrecision) {
        int newPrecision;
        if (this.isDefault()) {
            return this;
        }
        int newFlags = allowedFlags & this.flags;
        int newWidth = allowWidth ? this.width : -1;
        int n = newPrecision = allowPrecision ? this.precision : -1;
        if (newFlags == 0 && newWidth == -1 && newPrecision == -1) {
            return DEFAULT;
        }
        if (newFlags == this.flags && newWidth == this.width && newPrecision == this.precision) {
            return this;
        }
        return new FormatOptions(newFlags, newWidth, newPrecision);
    }

    public boolean isDefault() {
        return this == FormatOptions.getDefault();
    }

    public int getWidth() {
        return this.width;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean validate(int allowedFlags, boolean allowPrecision) {
        if (this.isDefault()) {
            return true;
        }
        if ((this.flags & ~allowedFlags) != 0) {
            return false;
        }
        if (!allowPrecision && this.precision != -1) {
            return false;
        }
        return FormatOptions.checkFlagConsistency(this.flags, this.getWidth() != -1);
    }

    static boolean checkFlagConsistency(int flags, boolean hasWidth) {
        if ((flags & 9) == 9) {
            return false;
        }
        if ((flags & 0x60) == 96) {
            return false;
        }
        return (flags & 0x60) == 0 || hasWidth;
    }

    public boolean areValidFor(FormatChar formatChar) {
        return this.validate(formatChar.getAllowedFlags(), formatChar.getType().supportsPrecision());
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean shouldLeftAlign() {
        return (this.flags & 0x20) != 0;
    }

    public boolean shouldShowAltForm() {
        return (this.flags & 2) != 0;
    }

    public boolean shouldShowLeadingZeros() {
        return (this.flags & 0x40) != 0;
    }

    public boolean shouldPrefixPlusForPositiveValues() {
        return (this.flags & 8) != 0;
    }

    public boolean shouldPrefixSpaceForPositiveValues() {
        return (this.flags & 1) != 0;
    }

    public boolean shouldShowGrouping() {
        return (this.flags & 0x10) != 0;
    }

    public boolean shouldUpperCase() {
        return (this.flags & 0x80) != 0;
    }

    public StringBuilder appendPrintfOptions(StringBuilder out) {
        if (!this.isDefault()) {
            int optionFlags = this.flags & 0xFFFFFF7F;
            int bit = 0;
            while (1 << bit <= optionFlags) {
                if ((optionFlags & 1 << bit) != 0) {
                    out.append(FLAG_CHARS_ORDERED.charAt(bit));
                }
                ++bit;
            }
            if (this.width != -1) {
                out.append(this.width);
            }
            if (this.precision != -1) {
                out.append('.').append(this.precision);
            }
        }
        return out;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FormatOptions) {
            FormatOptions other = (FormatOptions)o;
            return other.flags == this.flags && other.width == this.width && other.precision == this.precision;
        }
        return false;
    }

    public int hashCode() {
        int result = this.flags;
        result = 31 * result + this.width;
        result = 31 * result + this.precision;
        return result;
    }

    static {
        long encoded = 0L;
        for (int i = 0; i < FLAG_CHARS_ORDERED.length(); ++i) {
            long n = FLAG_CHARS_ORDERED.charAt(i) - 32;
            encoded |= (long)i + 1L << (int)(3L * n);
        }
        ENCODED_FLAG_INDICES = encoded;
        DEFAULT = new FormatOptions(0, -1, -1);
    }
}

