/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.EntriesCredentialConfiguration;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;

public class HadoopCredentialConfiguration
extends EntriesCredentialConfiguration
implements Configurable {
    public HadoopCredentialConfiguration(List<String> prefixes) {
        super(prefixes);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Configuration getConf() {
        Configuration configuration = new Configuration();
        this.getConfigurationInto(new ConfigurationEntriesAdapter(configuration));
        return configuration;
    }

    @Deprecated
    public void setConf(Configuration entries) {
        this.setConfiguration(new ConfigurationEntriesAdapter(entries));
    }

    public static class Builder
    extends EntriesCredentialConfiguration.Builder<Builder, HadoopCredentialConfiguration> {
        public Builder withConfiguration(Configuration config) {
            super.withConfiguration(new ConfigurationEntriesAdapter(config));
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected HadoopCredentialConfiguration beginBuild() {
            return new HadoopCredentialConfiguration(this.prefixes);
        }
    }

    public static class ConfigurationEntriesAdapter
    implements EntriesCredentialConfiguration.Entries {
        private final Configuration config;

        public ConfigurationEntriesAdapter(Configuration config) {
            this.config = config;
        }

        @Override
        public String get(String key) {
            return this.config.get(key);
        }

        @Override
        public void set(String key, String value) {
            this.config.set(key, value);
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.config.setBoolean(key, value);
        }

        @Override
        public String getPassword(String key) {
            try {
                char[] val = this.config.getPassword(key);
                return val == null ? null : String.valueOf(val);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

