/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.json.GoogleJsonResponseException;
import java.io.IOError;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public class ApiErrorExtractor {
    public static final ApiErrorExtractor INSTANCE = new ApiErrorExtractor();
    public static final int STATUS_CODE_CONFLICT = 409;
    public static final int STATUS_CODE_PRECONDITION_FAILED = 412;
    public static final int STATUS_CODE_RANGE_NOT_SATISFIABLE = 416;
    public static final String GLOBAL_DOMAIN = "global";
    public static final String USAGE_LIMITS_DOMAIN = "usageLimits";
    public static final String RATE_LIMITED_REASON_CODE = "rateLimitExceeded";
    public static final String USER_RATE_LIMITED_REASON_CODE = "userRateLimitExceeded";
    public static final String ACCOUNT_DISABLED_REASON_CODE = "accountDisabled";
    public static final String ACCESS_NOT_CONFIGURED_REASON_CODE = "accessNotConfigured";
    public static final String RESOURCE_NOT_READY_REASON_CODE = "resourceNotReady";
    public static final String FIELD_SIZE_TOO_LARGE = "fieldSizeTooLarge";
    public static final String USER_PROJECT_MISSING = "Bucket is requester pays bucket but no user project provided.";
    private static final String DEBUG_INFO_FIELD = "debugInfo";

    @Deprecated
    public ApiErrorExtractor() {
    }

    public boolean accessDenied(IOException e) {
        return this.recursiveCheckForCode(e, 403);
    }

    public boolean unauthorized(IOException e) {
        return this.recursiveCheckForCode(e, 401);
    }

    public boolean accessDeniedNonRecoverable(IOException e) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseExceptionOrNull(e);
        if (jsonException != null) {
            return this.accessDeniedNonRecoverable(this.getDetails(jsonException));
        }
        return false;
    }

    public boolean accessDeniedNonRecoverable(GoogleJsonError e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        if (errorInfo != null) {
            String reason = errorInfo.getReason();
            return ACCOUNT_DISABLED_REASON_CODE.equals(reason) || ACCESS_NOT_CONFIGURED_REASON_CODE.equals(reason);
        }
        return false;
    }

    public boolean isClientError(IOException e) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseExceptionOrNull(e);
        if (jsonException != null) {
            return this.getHttpStatusCode(jsonException) / 100 == 4;
        }
        return false;
    }

    public boolean isInternalServerError(IOException e) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseExceptionOrNull(e);
        if (jsonException != null) {
            return this.getHttpStatusCode(jsonException) / 100 == 5;
        }
        return false;
    }

    public boolean itemAlreadyExists(IOException e) {
        return this.recursiveCheckForCode(e, 409);
    }

    public boolean itemNotFound(GoogleJsonError e) {
        return e.getCode() == 404;
    }

    public boolean itemNotFound(IOException e) {
        return this.recursiveCheckForCode(e, 404);
    }

    public boolean fieldSizeTooLarge(GoogleJsonError e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        if (errorInfo != null) {
            String reason = errorInfo.getReason();
            return FIELD_SIZE_TOO_LARGE.equals(reason);
        }
        return false;
    }

    public boolean fieldSizeTooLarge(IOException e) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseExceptionOrNull(e);
        if (jsonException != null) {
            return this.fieldSizeTooLarge(this.getDetails(jsonException));
        }
        return false;
    }

    public boolean resourceNotReady(GoogleJsonError e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        if (errorInfo != null) {
            String reason = errorInfo.getReason();
            return RESOURCE_NOT_READY_REASON_CODE.equals(reason);
        }
        return false;
    }

    public boolean resourceNotReady(IOException e) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseExceptionOrNull(e);
        if (jsonException != null) {
            return this.resourceNotReady(this.getDetails(jsonException));
        }
        return false;
    }

    public boolean preconditionNotMet(GoogleJsonError e) {
        return e.getCode() == 412;
    }

    public boolean preconditionNotMet(IOException e) {
        return this.recursiveCheckForCode(e, 412);
    }

    public boolean rangeNotSatisfiable(IOException e) {
        return this.recursiveCheckForCode(e, 416);
    }

    public boolean rateLimited(GoogleJsonError e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        if (errorInfo != null) {
            String domain = errorInfo.getDomain();
            String reason = errorInfo.getReason();
            boolean isRateLimitedOrGlobalDomain = USAGE_LIMITS_DOMAIN.equals(domain) || GLOBAL_DOMAIN.equals(domain);
            boolean isRateLimitedReason = RATE_LIMITED_REASON_CODE.equals(reason) || USER_RATE_LIMITED_REASON_CODE.equals(reason);
            return isRateLimitedOrGlobalDomain && isRateLimitedReason;
        }
        return false;
    }

    public boolean rateLimited(Throwable throwable) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseExceptionOrNull(throwable);
        if (jsonException != null) {
            return this.rateLimited(this.getDetails(jsonException));
        }
        return false;
    }

    public boolean userProjectMissing(GoogleJsonError e) {
        GoogleJsonError.ErrorInfo errorInfo = this.getErrorInfo(e);
        return errorInfo != null && e.getCode() == 400 && USER_PROJECT_MISSING.equals(errorInfo.getMessage());
    }

    public boolean userProjectMissing(IOException e) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseExceptionOrNull(e);
        return jsonException != null && this.userProjectMissing(jsonException.getDetails());
    }

    public boolean ioError(Throwable throwable) {
        if (throwable instanceof IOException || throwable instanceof IOError) {
            return true;
        }
        return throwable.getCause() != null && this.ioError(throwable.getCause());
    }

    public boolean socketError(Throwable throwable) {
        if (throwable instanceof SocketException || throwable instanceof SocketTimeoutException) {
            return true;
        }
        Throwable cause = throwable.getCause();
        if (throwable instanceof SSLException && cause != null && this.ioError(cause)) {
            return true;
        }
        return cause != null && this.socketError(cause);
    }

    public boolean readTimedOut(IOException ex) {
        if (!(ex instanceof SocketTimeoutException)) {
            return false;
        }
        return ex.getMessage().equals("Read timed out");
    }

    public String getErrorMessage(IOException e) {
        GoogleJsonResponseException gjre = ApiErrorExtractor.getJsonResponseExceptionOrNull(e);
        if (gjre != null && gjre.getDetails() != null) {
            return gjre.getDetails().getMessage();
        }
        return e.getMessage();
    }

    public IOException toUserPresentableException(IOException ioe, String action) throws IOException {
        throw new IOException(this.toUserPresentableMessage(ioe, action), ioe);
    }

    public String toUserPresentableMessage(IOException ioe, @Nullable String action) {
        String message = "Internal server error";
        if (this.isClientError(ioe)) {
            message = this.getErrorMessage(ioe);
        }
        if (action == null) {
            return message;
        }
        return String.format("Encountered an error while %s: %s", action, message);
    }

    public String toUserPresentableMessage(IOException ioe) {
        return this.toUserPresentableMessage(ioe, null);
    }

    @Nullable
    public String getDebugInfo(IOException ioe) {
        GoogleJsonError.ErrorInfo info = this.getErrorInfo(ioe);
        if (info != null && info.getUnknownKeys().containsKey(DEBUG_INFO_FIELD)) {
            return (String)info.getUnknownKeys().get(DEBUG_INFO_FIELD);
        }
        return null;
    }

    protected int getHttpStatusCode(GoogleJsonResponseException e) {
        return e.getStatusCode();
    }

    protected GoogleJsonError.ErrorInfo getErrorInfo(IOException e) {
        GoogleJsonError gjre = this.getDetails(e);
        if (gjre != null) {
            return this.getErrorInfo(gjre);
        }
        return null;
    }

    protected GoogleJsonError getDetails(IOException e) {
        if (e instanceof GoogleJsonResponseException) {
            return ((GoogleJsonResponseException)e).getDetails();
        }
        return null;
    }

    protected GoogleJsonError.ErrorInfo getErrorInfo(GoogleJsonError details) {
        if (details == null) {
            return null;
        }
        List<GoogleJsonError.ErrorInfo> errors = details.getErrors();
        return errors.isEmpty() ? null : errors.get(0);
    }

    protected boolean recursiveCheckForCode(Throwable e, int code) {
        GoogleJsonResponseException jsonException = ApiErrorExtractor.getJsonResponseExceptionOrNull(e);
        if (jsonException != null) {
            return this.getHttpStatusCode(jsonException) == code;
        }
        return false;
    }

    @Nullable
    public static GoogleJsonResponseException getJsonResponseExceptionOrNull(Throwable t) {
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof GoogleJsonResponseException)) continue;
            return (GoogleJsonResponseException)cause;
        }
        return null;
    }
}

