/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class AbstractGoogleAsyncWriteChannel<T extends AbstractGoogleClientRequest<S>, S>
implements WritableByteChannel {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    @Deprecated
    public static final int UPLOAD_PIPE_BUFFER_SIZE_DEFAULT = 0x100000;
    public static final int GCS_UPLOAD_GRANULARITY = 0x800000;
    public static final int UPLOAD_CHUNK_SIZE_DEFAULT = Runtime.getRuntime().maxMemory() < 0x20000000L ? 0x800000 : 0x4000000;
    private String contentType;
    private ClientRequestHelper<S> clientRequestHelper = new ClientRequestHelper();
    private final ExecutorService threadPool;
    private boolean isInitialized = false;
    private final int pipeBufferSize;
    private int uploadChunkSize = UPLOAD_CHUNK_SIZE_DEFAULT;
    private WritableByteChannel pipeSinkChannel;
    private Future<S> uploadOperation;
    private boolean directUploadEnabled = false;

    public AbstractGoogleAsyncWriteChannel(ExecutorService threadPool, AsyncWriteChannelOptions options) {
        this.threadPool = threadPool;
        this.pipeBufferSize = options.getPipeBufferSize();
        this.setUploadChunkSize(options.getUploadChunkSize());
        this.setDirectUploadEnabled(options.isDirectUploadEnabled());
        this.setContentType("application/octet-stream");
    }

    @VisibleForTesting
    public void setClientRequestHelper(ClientRequestHelper<S> helper) {
        this.clientRequestHelper = helper;
    }

    public abstract T createRequest(InputStreamContent var1) throws IOException;

    public void handleResponse(S response) throws IOException {
    }

    public S createResponseFromException(IOException ioe) {
        return null;
    }

    @Deprecated
    public void setUploadBufferSize(int bufferSize) {
        this.setUploadChunkSize(bufferSize);
    }

    public void setUploadChunkSize(int chunkSize) {
        Preconditions.checkArgument(chunkSize > 0, "Upload chunk size must be great than 0.");
        Preconditions.checkArgument(chunkSize % 262144 == 0, "Upload chunk size must be a multiple of MediaHttpUploader.MINIMUM_CHUNK_SIZE");
        if (chunkSize > 0x800000 && chunkSize % 0x800000 != 0) {
            ((GoogleLogger.Api)logger.atWarning()).log("Upload chunk size should be a multiple of %s for best performance, got %s", 0x800000, chunkSize);
        }
        this.uploadChunkSize = chunkSize;
    }

    public void setDirectUploadEnabled(boolean enableDirectUpload) {
        this.directUploadEnabled = enableDirectUpload;
    }

    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    @Override
    public synchronized int write(ByteBuffer buffer) throws IOException {
        Preconditions.checkState(this.isInitialized, "initialize() must be invoked before use.");
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.uploadOperation.isDone()) {
            this.waitForCompletionAndThrowIfUploadFailed();
        }
        return this.pipeSinkChannel.write(buffer);
    }

    @Override
    public boolean isOpen() {
        return this.pipeSinkChannel != null && this.pipeSinkChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState(this.isInitialized, "initialize() must be invoked before use.");
        if (this.isOpen()) {
            try {
                this.pipeSinkChannel.close();
                this.handleResponse(this.waitForCompletionAndThrowIfUploadFailed());
            }
            finally {
                this.pipeSinkChannel = null;
                this.uploadOperation = null;
            }
        }
    }

    public void initialize() throws IOException {
        PipedInputStream pipeSource = new PipedInputStream(this.pipeBufferSize);
        PipedOutputStream pipeSink = new PipedOutputStream(pipeSource);
        this.pipeSinkChannel = Channels.newChannel(pipeSink);
        InputStreamContent objectContentStream = new InputStreamContent(this.contentType, pipeSource);
        objectContentStream.setLength(-1L);
        objectContentStream.setCloseInputStream(false);
        T request = this.createRequest(objectContentStream);
        ((AbstractGoogleClientRequest)request).setDisableGZipContent(true);
        this.clientRequestHelper.setChunkSize((AbstractGoogleClientRequest<S>)request, this.uploadChunkSize);
        this.uploadOperation = this.threadPool.submit(new UploadOperation(this, request, (InputStream)pipeSource));
        this.isInitialized = true;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private S waitForCompletionAndThrowIfUploadFailed() throws IOException {
        try {
            return this.uploadOperation.get();
        }
        catch (InterruptedException e) {
            this.uploadOperation.cancel(true);
            ClosedByInterruptException exception = new ClosedByInterruptException();
            exception.addSuppressed(e);
            throw exception;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new IOException("Upload failed", e.getCause());
        }
    }

    static class UploadOperation
    implements Callable<S> {
        private final T uploadObject;
        private final InputStream pipeSource;
        final /* synthetic */ AbstractGoogleAsyncWriteChannel this$0;

        public UploadOperation(T uploadObject, InputStream pipeSource) {
            this.this$0 = this$0;
            this.uploadObject = uploadObject;
            this.pipeSource = pipeSource;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public S call() throws Exception {
            try (InputStream uploadPipeSource = this.pipeSource;){
                Object throwable3 = ((AbstractGoogleClientRequest)this.uploadObject).execute();
                return throwable3;
            }
            catch (IOException ioe) {
                Object response = this.this$0.createResponseFromException(ioe);
                if (response == null) throw ioe;
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ioe)).log("Received IOException, but successfully converted to response '%s'.", response);
                return response;
            }
        }
    }
}

