/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.net.URI;
import java.net.URISyntaxException;

class UriEncodingPathCodec
implements PathCodec {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    UriEncodingPathCodec() {
    }

    @Override
    public StorageResourceId validatePathAndGetId(URI path, boolean allowEmptyObjectName) {
        ((GoogleLogger.Api)logger.atFine()).log("validatePathAndGetId('%s', %s)", (Object)path, allowEmptyObjectName);
        Preconditions.checkNotNull(path);
        if (!"gs".equals(path.getScheme())) {
            throw new IllegalArgumentException(String.format("Google Cloud Storage path supports only '%s' scheme, instead got '%s' from '%s'.", "gs", path.getScheme(), path));
        }
        if (path.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
            return StorageResourceId.ROOT;
        }
        String bucketName = GoogleCloudStorageFileSystem.validateBucketName(path.getAuthority());
        String objectName = GoogleCloudStorageFileSystem.validateObjectName(path.getPath(), allowEmptyObjectName);
        return Strings.isNullOrEmpty(objectName) ? new StorageResourceId(bucketName) : new StorageResourceId(bucketName, objectName);
    }

    @Override
    public URI getPath(String bucketName, String objectName, boolean allowEmptyObjectName) {
        if (allowEmptyObjectName && bucketName == null && objectName == null) {
            return GoogleCloudStorageFileSystem.GCS_ROOT;
        }
        String authority = GoogleCloudStorageFileSystem.validateBucketName(bucketName);
        String path = "/" + GoogleCloudStorageFileSystem.validateObjectName(objectName, allowEmptyObjectName);
        try {
            return new URI("gs", authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid bucket name (%s) or object name (%s)", bucketName, objectName), e);
        }
    }
}

