/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Ticker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class PrefixMappedItemCache {
    private final TreeMap<PrefixKey, CacheValue<GoogleCloudStorageItemInfo>> itemMap = new TreeMap(PrefixKey.COMPARATOR);
    private final TreeMap<PrefixKey, CacheValue<Object>> prefixMap = new TreeMap(PrefixKey.COMPARATOR);
    private final long maxEntryAgeNanos;
    private final Ticker ticker;

    public PrefixMappedItemCache(Config config) {
        this.maxEntryAgeNanos = TimeUnit.MILLISECONDS.toNanos(config.getMaxEntryAgeMillis());
        this.ticker = config.getTicker();
    }

    public synchronized GoogleCloudStorageItemInfo getItem(StorageResourceId id) {
        PrefixKey key = new PrefixKey(id.getBucketName(), id.getObjectName());
        CacheValue<GoogleCloudStorageItemInfo> value = this.itemMap.get(key);
        if (value == null) {
            return null;
        }
        if (this.isExpired(value)) {
            this.itemMap.remove(key);
            this.cleanupLists(key);
            return null;
        }
        return value.getValue();
    }

    public synchronized List<GoogleCloudStorageItemInfo> getList(String bucket, @Nullable String objectNamePrefix) {
        PrefixKey key = new PrefixKey(bucket, objectNamePrefix);
        Map.Entry<PrefixKey, CacheValue<Object>> entry = PrefixMappedItemCache.getParentEntry(this.prefixMap, key);
        if (entry == null) {
            return null;
        }
        if (this.isExpired(entry.getValue())) {
            this.cleanupLists(key);
            return null;
        }
        return this.listItems(key);
    }

    synchronized List<GoogleCloudStorageItemInfo> listItems(String bucket, @Nullable String objectNamePrefix) {
        return this.listItems(new PrefixKey(bucket, objectNamePrefix));
    }

    private List<GoogleCloudStorageItemInfo> listItems(PrefixKey key) {
        return PrefixMappedItemCache.aggregateCacheValues(PrefixMappedItemCache.getPrefixSubMap(this.itemMap, key));
    }

    public synchronized GoogleCloudStorageItemInfo putItem(GoogleCloudStorageItemInfo item) {
        CacheValue<GoogleCloudStorageItemInfo> value;
        StorageResourceId id = item.getResourceId();
        PrefixKey key = new PrefixKey(id.getBucketName(), id.getObjectName());
        CacheValue<GoogleCloudStorageItemInfo> oldValue = this.itemMap.put(key, value = new CacheValue<GoogleCloudStorageItemInfo>(item, this.ticker.read()));
        if (oldValue == null) {
            return null;
        }
        if (this.isExpired(oldValue)) {
            this.cleanupLists(key);
            return null;
        }
        return oldValue.getValue();
    }

    public synchronized void putList(String bucket, @Nullable String objectNamePrefix, List<GoogleCloudStorageItemInfo> items) {
        long creationTime = this.ticker.read();
        PrefixKey key = new PrefixKey(bucket, objectNamePrefix);
        PrefixMappedItemCache.getPrefixSubMap(this.itemMap, key).clear();
        PrefixMappedItemCache.getPrefixSubMap(this.prefixMap, key).clear();
        this.prefixMap.put(key, new CacheValue<Object>(null, creationTime));
        for (GoogleCloudStorageItemInfo item : items) {
            StorageResourceId itemId = item.getResourceId();
            PrefixKey itemKey = new PrefixKey(itemId.getBucketName(), itemId.getObjectName());
            CacheValue<GoogleCloudStorageItemInfo> itemValue = new CacheValue<GoogleCloudStorageItemInfo>(item, creationTime);
            this.itemMap.put(itemKey, itemValue);
        }
    }

    public synchronized GoogleCloudStorageItemInfo removeItem(StorageResourceId id) {
        PrefixKey key = new PrefixKey(id.getBucketName(), id.getObjectName());
        CacheValue<GoogleCloudStorageItemInfo> value = this.itemMap.remove(key);
        if (value == null) {
            return null;
        }
        if (this.isExpired(value)) {
            this.cleanupLists(key);
            return null;
        }
        return value.getValue();
    }

    public synchronized void invalidateBucket(String bucket) {
        PrefixKey key = new PrefixKey(bucket, "");
        PrefixMappedItemCache.getPrefixSubMap(this.itemMap, key).clear();
        PrefixMappedItemCache.getPrefixSubMap(this.prefixMap, key).clear();
    }

    public synchronized void invalidateAll() {
        this.itemMap.clear();
        this.prefixMap.clear();
    }

    private <V> boolean isExpired(CacheValue<V> value) {
        long diff = this.ticker.read() - value.getCreationTime();
        return diff > this.maxEntryAgeNanos;
    }

    private void cleanupLists(PrefixKey key) {
        NavigableMap<PrefixKey, CacheValue<Object>> head = this.prefixMap.headMap(key, true).descendingMap();
        Iterator headItr = head.entrySet().iterator();
        Map.Entry last = null;
        while (headItr.hasNext()) {
            Map.Entry entry2 = headItr.next();
            if (!this.isExpired((CacheValue)entry2.getValue()) || !key.isParent((PrefixKey)entry2.getKey())) continue;
            last = entry2;
            headItr.remove();
        }
        if (last != null) {
            SortedMap<PrefixKey, CacheValue<GoogleCloudStorageItemInfo>> prefix = PrefixMappedItemCache.getPrefixSubMap(this.itemMap, (PrefixKey)last.getKey());
            prefix.entrySet().removeIf(entry -> this.isExpired((CacheValue)entry.getValue()));
        }
    }

    private static <K, V> List<V> aggregateCacheValues(Map<K, CacheValue<V>> map) {
        ArrayList<V> values = new ArrayList<V>(map.size());
        for (Map.Entry<K, CacheValue<V>> entry : map.entrySet()) {
            values.add(entry.getValue().getValue());
        }
        return values;
    }

    private static <E> SortedMap<PrefixKey, E> getPrefixSubMap(TreeMap<PrefixKey, E> map, PrefixKey lowerBound) {
        PrefixKey upperBound = new PrefixKey(lowerBound.getBucket(), lowerBound.getObjectName() + '\uffff');
        return map.subMap(lowerBound, upperBound);
    }

    private static <E> Map.Entry<PrefixKey, E> getParentEntry(TreeMap<PrefixKey, E> map, PrefixKey upperBound) {
        NavigableMap<PrefixKey, E> head = map.headMap(upperBound, true).descendingMap();
        for (Map.Entry entry : head.entrySet()) {
            if (!upperBound.isParent((PrefixKey)entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    @VisibleForTesting
    List<GoogleCloudStorageItemInfo> getAllItemsRaw() {
        return PrefixMappedItemCache.aggregateCacheValues(this.itemMap);
    }

    @VisibleForTesting
    boolean containsListRaw(String bucket, String objectName) {
        return this.prefixMap.containsKey(new PrefixKey(bucket, objectName));
    }

    private static class PrefixKey
    implements Comparable<PrefixKey> {
        public static final Comparator<PrefixKey> COMPARATOR = Comparator.naturalOrder();
        private final String bucket;
        private final String objectName;

        public PrefixKey(String bucket, @Nullable String objectName) {
            Preconditions.checkArgument(bucket != null || objectName == null, "bucket must not be null if object is not null.");
            this.bucket = Strings.nullToEmpty(bucket);
            this.objectName = Strings.nullToEmpty(objectName);
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String toString() {
            return "PrefixKey [bucket=" + this.bucket + ", objectName=" + this.objectName + "]";
        }

        public boolean isParent(PrefixKey other) {
            return this.bucket.equals(other.bucket) && this.objectName.startsWith(other.objectName);
        }

        @Override
        public int compareTo(PrefixKey other) {
            int result = this.bucket.compareTo(other.bucket);
            return result == 0 ? this.objectName.compareTo(other.objectName) : result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bucket.hashCode();
            result = 31 * result + this.objectName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PrefixKey)) {
                return false;
            }
            PrefixKey other = (PrefixKey)obj;
            return this.bucket.equals(other.bucket) && this.objectName.equals(other.objectName);
        }
    }

    private static class CacheValue<V> {
        private final V value;
        private final long creationTime;

        public CacheValue(V value, long creationTime) {
            this.value = value;
            this.creationTime = creationTime;
        }

        public V getValue() {
            return this.value;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public String toString() {
            return "CacheValue [value=" + this.value + ", creationTime=" + this.creationTime + "]";
        }
    }

    public static class Config {
        private long maxEntryAgeMillis;
        private Ticker ticker = Ticker.systemTicker();

        public long getMaxEntryAgeMillis() {
            return this.maxEntryAgeMillis;
        }

        public void setMaxEntryAgeMillis(long maxEntryAgeMillis) {
            this.maxEntryAgeMillis = maxEntryAgeMillis;
        }

        public Ticker getTicker() {
            return this.ticker;
        }

        public void setTicker(Ticker ticker) {
            this.ticker = ticker;
        }
    }
}

