/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.net.URI;
import java.net.URISyntaxException;

class LegacyPathCodec
implements PathCodec {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    LegacyPathCodec() {
    }

    @Override
    public StorageResourceId validatePathAndGetId(URI path, boolean allowEmptyObjectName) {
        ((GoogleLogger.Api)logger.atFine()).log("validatePathAndGetId('%s', %s)", (Object)path, allowEmptyObjectName);
        Preconditions.checkNotNull(path);
        if (!"gs".equals(path.getScheme())) {
            throw new IllegalArgumentException("Google Cloud Storage path supports only 'gs' scheme, instead got '" + path.getScheme() + "' from '" + path + "'.");
        }
        if (path.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
            return StorageResourceId.ROOT;
        }
        String bucketName = path.getAuthority();
        String schemeSpecificPart = path.getRawSchemeSpecificPart();
        Preconditions.checkState(schemeSpecificPart.startsWith("//" + bucketName), "Expected schemeSpecificStart to start with '//%s', instead got '%s'", (Object)bucketName, (Object)schemeSpecificPart);
        String objectName = schemeSpecificPart.substring(2 + bucketName.length());
        bucketName = GoogleCloudStorageFileSystem.validateBucketName(bucketName);
        objectName = GoogleCloudStorageFileSystem.validateObjectName(objectName, allowEmptyObjectName);
        if (Strings.isNullOrEmpty(objectName)) {
            return new StorageResourceId(bucketName);
        }
        return new StorageResourceId(bucketName, objectName);
    }

    @Override
    public URI getPath(String bucketName, String objectName, boolean allowEmptyObjectName) {
        if (allowEmptyObjectName && bucketName == null && objectName == null) {
            return GoogleCloudStorageFileSystem.GCS_ROOT;
        }
        bucketName = GoogleCloudStorageFileSystem.validateBucketName(bucketName);
        objectName = GoogleCloudStorageFileSystem.validateObjectName(objectName, allowEmptyObjectName);
        URI pathUri = null;
        String path = "gs://" + bucketName + "/" + objectName;
        try {
            pathUri = new URI(path);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid bucket name (%s) or object name (%s)", bucketName, objectName);
            throw new IllegalArgumentException(msg, e);
        }
        return pathUri;
    }
}

