/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;

class GoogleHadoopOutputStream
extends OutputStream {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private GoogleHadoopFileSystemBase ghfs;
    private WritableByteChannel channel;
    private OutputStream out;
    private URI gcsPath;
    private final FileSystem.Statistics statistics;
    private long initTime;

    GoogleHadoopOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, FileSystem.Statistics statistics, CreateFileOptions createFileOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GoogleHadoopOutputStream(%s)", gcsPath);
        this.ghfs = ghfs;
        this.gcsPath = gcsPath;
        this.statistics = statistics;
        this.initTime = System.nanoTime();
        this.channel = GoogleHadoopOutputStream.createChannel(ghfs, gcsPath, createFileOptions);
        this.out = GoogleHadoopOutputStream.createOutputStream(this.channel, ghfs.getGcsFs().getOptions().getCloudStorageOptions());
    }

    private static WritableByteChannel createChannel(GoogleHadoopFileSystemBase ghfs, URI gcsPath, CreateFileOptions options) throws IOException {
        try {
            return ghfs.getGcsFs().create(gcsPath, options);
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            throw (FileAlreadyExistsException)new FileAlreadyExistsException("'" + gcsPath + "' already exists").initCause((Throwable)e);
        }
    }

    private static OutputStream createOutputStream(WritableByteChannel channel, GoogleCloudStorageOptions gcsOptions) {
        OutputStream out = Channels.newOutputStream(channel);
        int bufferSize = gcsOptions.getWriteChannelOptions().getBufferSize();
        return bufferSize > 0 ? new BufferedOutputStream(out, bufferSize) : out;
    }

    @Override
    public void write(int b) throws IOException {
        long startTime = System.nanoTime();
        this.out.write(b);
        this.statistics.incrementBytesWritten(1L);
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE1);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE1_TIME, duration);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        long startTime = System.nanoTime();
        this.out.write(b, offset, len);
        this.statistics.incrementBytesWritten((long)len);
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE_TIME, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                long startTime = System.nanoTime();
                this.out.close();
                long duration = System.nanoTime() - startTime;
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE_CLOSE);
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.WRITE_CLOSE_TIME, duration);
                long streamDuration = System.nanoTime() - this.initTime;
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.OUTPUT_STREAM);
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.OUTPUT_STREAM_TIME, streamDuration);
                ((GoogleLogger.Api)logger.atFine()).log("close(%s)", this.gcsPath);
            }
            finally {
                this.out = null;
                this.channel = null;
            }
        }
    }

    WritableByteChannel getInternalChannel() {
        return this.channel;
    }
}

