/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.CallerContext;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.registry.AMRecord;
import org.apache.tez.client.registry.zookeeper.ZkAMRegistryClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.examples.ExampleBase;
import org.apache.tez.examples.StandaloneWordCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class StandaloneWordCountDriver {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneWordCountDriver.class);
    private static TezClient tezClientInternal;

    public static void main(String[] args) throws Exception {
        StandaloneWordCount clazz = new StandaloneWordCount();
        StandaloneWordCountDriver._execute(clazz, args, null, null);
    }

    private static int _execute(ExampleBase clazz, String[] otherArgs, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        tezConf = new TezConfiguration();
        tezConf.set("tez.am.zookeeper.quorum", "localhost:2181");
        ZkAMRegistryClient registryClientZk = ZkAMRegistryClient.getClient((Configuration)tezConf);
        List sessions = registryClientZk.getAllRecords();
        Collections.shuffle(sessions);
        AMRecord am = (AMRecord)sessions.get(0);
        tezConf.set("tez..framework.mode", "STANDALONE_ZOOKEEPER");
        tezConf.setBoolean("tez.ignore.lib.uris", true);
        tezClientInternal = StandaloneWordCountDriver.createTezClient(am.getApplicationId().toString(), tezConf);
        StandaloneWordCount standaloneWordCount = new StandaloneWordCount();
        return standaloneWordCount.runJob(otherArgs, tezConf, tezClientInternal);
    }

    public static int runDag(DAG dag, ApplicationId appId, Logger logger) throws Exception {
        CallerContext callerContext = CallerContext.create((String)"TezExamples", (String)("Tez Example DAG: " + dag.getName()));
        if (appId != null) {
            callerContext.setCallerIdAndType(appId.toString(), "TezExampleApplication");
        }
        dag.setCallerContext(callerContext);
        DAGClient dagClient = tezClientInternal.submitDAG(dag);
        HashSet getOpts = Sets.newHashSet();
        getOpts.add(StatusGetOpts.GET_COUNTERS);
        DAGStatus dagStatus = dagClient.waitForCompletionWithStatusUpdates((Set)getOpts);
        if (dagStatus.getState() != DAGStatus.State.SUCCEEDED) {
            logger.info("DAG diagnostics: " + dagStatus.getDiagnostics());
            return -1;
        }
        return 0;
    }

    private static TezClient createTezClient(String appId, TezConfiguration tezConf) throws IOException, TezException {
        Credentials credentials = new Credentials();
        Token token = new Token();
        credentials.addToken(new Text("root"), token);
        TezClient tezClient = TezClient.create((String)"TezExampleApplication", (TezConfiguration)tezConf, (boolean)true, null, (Credentials)credentials);
        return tezClient.getClient(appId);
    }
}

