/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.examples.ExampleBase;
import org.apache.tez.examples.StandaloneWordCountDriver;
import org.apache.tez.mapreduce.SumProcessor;
import org.apache.tez.mapreduce.TokenProcessor;
import org.apache.tez.runtime.library.FakeInput;
import org.apache.tez.runtime.library.FakeInputInitializer;
import org.apache.tez.runtime.library.FakeOutput;
import org.apache.tez.runtime.library.FakeOutputCommitter;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneWordCount
extends ExampleBase {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneWordCount.class);
    static String INPUT = "Input";
    static String SUMMATION = "Summation";
    static String OUTPUT = "Output";
    static String TOKENIZER = "Tokenizer";

    private DAG createDAG(TezConfiguration tezConf, String inputPath, String outputPath, int numPartitions) throws IOException {
        InputDescriptor inputDescriptor = InputDescriptor.create((String)FakeInput.class.getName());
        InputInitializerDescriptor inputInitializerDescriptor = InputInitializerDescriptor.create((String)FakeInputInitializer.class.getName());
        DataSourceDescriptor dataSource = DataSourceDescriptor.create((InputDescriptor)inputDescriptor, (InputInitializerDescriptor)inputInitializerDescriptor, null);
        OutputDescriptor outputDescriptor = OutputDescriptor.create((String)FakeOutput.class.getName());
        OutputCommitterDescriptor outputCommitterDescriptor = OutputCommitterDescriptor.create((String)FakeOutputCommitter.class.getName());
        DataSinkDescriptor dataSink = DataSinkDescriptor.create((OutputDescriptor)outputDescriptor, (OutputCommitterDescriptor)outputCommitterDescriptor, null);
        Vertex tokenizerVertex = Vertex.create((String)TOKENIZER, (ProcessorDescriptor)ProcessorDescriptor.create((String)TokenProcessor.class.getName())).addDataSource(INPUT, dataSource);
        OrderedPartitionedKVEdgeConfig edgeConf = OrderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName(), (String)HashPartitioner.class.getName()).setFromConfiguration((Configuration)tezConf).build();
        Vertex summationVertex = Vertex.create((String)SUMMATION, (ProcessorDescriptor)ProcessorDescriptor.create((String)SumProcessor.class.getName()), (int)numPartitions).addDataSink(OUTPUT, dataSink);
        DAG dag = DAG.create((String)"WordCount");
        dag.addVertex(tokenizerVertex).addVertex(summationVertex).addEdge(Edge.create((Vertex)tokenizerVertex, (Vertex)summationVertex, (EdgeProperty)edgeConf.createDefaultEdgeProperty()));
        return dag;
    }

    @Override
    protected void printUsage() {
        System.err.println("Usage:  wordcount in out");
    }

    @Override
    protected int validateArgs(String[] otherArgs) {
        if (otherArgs.length != 2) {
            return 2;
        }
        return 0;
    }

    @Override
    protected int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        DAG dag = this.createDAG(tezConf, null, null, 1);
        LOG.info("Running WordCount");
        return StandaloneWordCountDriver.runDag(dag, tezClient.getAppMasterApplicationId(), LOG);
    }
}

