/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.select;

import com.amazonaws.services.s3.model.CSVInput;
import com.amazonaws.services.s3.model.CSVOutput;
import com.amazonaws.services.s3.model.ExpressionType;
import com.amazonaws.services.s3.model.InputSerialization;
import com.amazonaws.services.s3.model.OutputSerialization;
import com.amazonaws.services.s3.model.QuoteFields;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.select.SelectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBinding {
    static final Logger LOG = LoggerFactory.getLogger(SelectBinding.class);
    private final WriteOperationHelper operations;
    private final boolean enabled;
    private final boolean errorsIncludeSql;

    public SelectBinding(WriteOperationHelper operations) {
        this.operations = (WriteOperationHelper)Preconditions.checkNotNull((Object)operations);
        Configuration conf = this.getConf();
        this.enabled = conf.getBoolean("fs.s3a.select.enabled", true);
        this.errorsIncludeSql = conf.getBoolean("fs.s3a.select.errors.include.sql", false);
    }

    Configuration getConf() {
        return this.operations.getConf();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FSDataInputStream select(S3AReadOpContext readContext, String expression, Configuration builderOptions, Optional<SSECustomerKey> sseKey, S3ObjectAttributes objectAttributes) throws IOException {
        return new FSDataInputStream((InputStream)((Object)this.executeSelect(readContext, objectAttributes, builderOptions, this.buildSelectRequest(readContext.getPath(), expression, builderOptions, sseKey))));
    }

    public SelectObjectContentRequest buildSelectRequest(Path path, String expression, Configuration builderOptions, Optional<SSECustomerKey> sseKey) throws IOException {
        Preconditions.checkState((boolean)this.isEnabled(), (String)"S3 Select is not enabled for %s", (Object)path);
        SelectObjectContentRequest request = this.operations.newSelectRequest(path);
        this.buildRequest(request, expression, builderOptions);
        sseKey.ifPresent(arg_0 -> ((SelectObjectContentRequest)request).withSSECustomerKey(arg_0));
        return request;
    }

    private SelectInputStream executeSelect(S3AReadOpContext readContext, S3ObjectAttributes objectAttributes, Configuration builderOptions, SelectObjectContentRequest request) throws IOException {
        String errorText;
        Path path = readContext.getPath();
        if (readContext.getDstFileStatus().isDirectory()) {
            throw new PathIOException(path.toString(), "Can't select " + path + " because it is a directory");
        }
        boolean sqlInErrors = builderOptions.getBoolean("fs.s3a.select.errors.include.sql", this.errorsIncludeSql);
        String expression = request.getExpression();
        String string = errorText = sqlInErrors ? expression : "Select";
        if (sqlInErrors) {
            LOG.info("Issuing SQL request {}", (Object)expression);
        }
        return new SelectInputStream(readContext, objectAttributes, this.operations.select(path, request, errorText));
    }

    void buildRequest(SelectObjectContentRequest request, String expression, Configuration builderOptions) throws IllegalArgumentException, IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)expression), (Object)"No expression provided in parameter fs.s3a.select.sql");
        Configuration ownerConf = this.operations.getConf();
        String inputFormat = builderOptions.get("fs.s3a.select.input.format", "csv").toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((boolean)"csv".equals(inputFormat), (String)"Unsupported input format %s", (Object)inputFormat);
        String outputFormat = builderOptions.get("fs.s3a.select.output.format", "csv").toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((boolean)"csv".equals(outputFormat), (String)"Unsupported output format %s", (Object)outputFormat);
        request.setExpressionType(ExpressionType.SQL);
        request.setExpression(SelectBinding.expandBackslashChars(expression));
        InputSerialization inputSerialization = this.buildCsvInputRequest(ownerConf, builderOptions);
        String compression = SelectBinding.opt(builderOptions, ownerConf, "fs.s3a.select.input.compression", "none", true).toUpperCase(Locale.ENGLISH);
        if (StringUtils.isNotEmpty((CharSequence)compression)) {
            inputSerialization.setCompressionType(compression);
        }
        request.setInputSerialization(inputSerialization);
        request.setOutputSerialization(this.buildCSVOutput(ownerConf, builderOptions));
    }

    public InputSerialization buildCsvInputRequest(Configuration ownerConf, Configuration builderOptions) throws IllegalArgumentException, IOException {
        String headerInfo = SelectBinding.opt(builderOptions, ownerConf, "fs.s3a.select.input.csv.header", "ignore", true).toUpperCase(Locale.ENGLISH);
        String commentMarker = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.input.csv.comment.marker", "#");
        String fieldDelimiter = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.input.csv.field.delimiter", ",");
        String recordDelimiter = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.input.csv.record.delimiter", "\n");
        String quoteCharacter = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.input.csv.quote.character", "\"");
        String quoteEscapeCharacter = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.input.csv.quote.escape.character", "\\");
        CSVInput csv = new CSVInput();
        csv.setFieldDelimiter(fieldDelimiter);
        csv.setRecordDelimiter(recordDelimiter);
        csv.setComments(commentMarker);
        csv.setQuoteCharacter(quoteCharacter);
        if (StringUtils.isNotEmpty((CharSequence)quoteEscapeCharacter)) {
            csv.setQuoteEscapeCharacter(quoteEscapeCharacter);
        }
        csv.setFileHeaderInfo(headerInfo);
        InputSerialization inputSerialization = new InputSerialization();
        inputSerialization.setCsv(csv);
        return inputSerialization;
    }

    public OutputSerialization buildCSVOutput(Configuration ownerConf, Configuration builderOptions) throws IllegalArgumentException, IOException {
        String fieldDelimiter = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.output.csv.field.delimiter", ",");
        String recordDelimiter = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.output.csv.record.delimiter", "\n");
        String quoteCharacter = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.output.csv.quote.character", "\"");
        String quoteEscapeCharacter = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.output.csv.quote.escape.character", "");
        String quoteFields = SelectBinding.xopt(builderOptions, ownerConf, "fs.s3a.select.output.csv.quote.fields", "always").toUpperCase(Locale.ENGLISH);
        OutputSerialization outputSerialization = new OutputSerialization();
        CSVOutput csvOut = new CSVOutput();
        csvOut.setQuoteCharacter(quoteCharacter);
        csvOut.setQuoteFields(QuoteFields.fromValue((String)quoteFields));
        csvOut.setFieldDelimiter(fieldDelimiter);
        csvOut.setRecordDelimiter(recordDelimiter);
        if (!quoteEscapeCharacter.isEmpty()) {
            csvOut.setQuoteEscapeCharacter(quoteEscapeCharacter);
        }
        outputSerialization.setCsv(csvOut);
        return outputSerialization;
    }

    public static String toString(SelectObjectContentRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("SelectObjectContentRequest{").append("bucket name=").append(request.getBucketName()).append("; key=").append(request.getKey()).append("; expressionType=").append(request.getExpressionType()).append("; expression=").append(request.getExpression());
        InputSerialization input = request.getInputSerialization();
        if (input != null) {
            sb.append("; Input").append(input.toString());
        } else {
            sb.append("; Input Serialization: none");
        }
        OutputSerialization out = request.getOutputSerialization();
        if (out != null) {
            sb.append("; Output").append(out.toString());
        } else {
            sb.append("; Output Serialization: none");
        }
        return sb.append("}").toString();
    }

    static String opt(Configuration builderOptions, Configuration fsConf, String base, String defVal, boolean trim) {
        String r = builderOptions.get(base, fsConf.get(base, defVal));
        return trim ? r.trim() : r;
    }

    static String xopt(Configuration selectOpts, Configuration fsConf, String base, String defVal) {
        return SelectBinding.expandBackslashChars(SelectBinding.opt(selectOpts, fsConf, base, defVal, false));
    }

    static String expandBackslashChars(String src) {
        return src.replace("\\n", "\n").replace("\\\"", "\"").replace("\\t", "\t").replace("\\r", "\r").replace("\\\"", "\"").replace("\\\\", "\\");
    }
}

