/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.fs.impl.WrappedIOException;
import org.apache.hadoop.fs.s3a.Invoker;

class RetryingCollection<T>
implements Iterable<T> {
    private final Iterable<T> source;
    private final Invoker invoker;
    private final String operation;

    RetryingCollection(String operation, Invoker invoker, Iterable<T> source) {
        this.operation = operation;
        this.source = source;
        this.invoker = invoker;
    }

    @Override
    public Iterator<T> iterator() {
        return new RetryingIterator(this.source.iterator());
    }

    private final class RetryingIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;

        private RetryingIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            try {
                return RetryingCollection.this.invoker.retry(RetryingCollection.this.operation, null, true, this.iterator::hasNext);
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
        }

        @Override
        public T next() {
            try {
                return RetryingCollection.this.invoker.retry("Scan Dynamo", null, true, this.iterator::next);
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
        }
    }
}

