/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.metrics;

import org.apache.hadoop.fs.StorageStatistics;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;

public class FileSystemStatisticUpdater2 {
    private StorageStatistics stats;
    private TezCounters counters;

    FileSystemStatisticUpdater2(TezCounters counters, StorageStatistics storageStatistics) {
        this.stats = storageStatistics;
        this.counters = counters;
    }

    void updateCounters() {
        for (FileSystemCounter fsCounter : FileSystemCounter.values()) {
            Long val = this.stats.getLong(fsCounter.getOpName());
            if (val == null || val == 0L) continue;
            TezCounter counter = this.counters.findCounter(this.stats.getScheme(), fsCounter);
            counter.setValue(val.longValue());
        }
    }
}

