/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.frameworkplugins.zookeeper;

import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.client.registry.AMRegistry;
import org.apache.tez.dag.api.client.registry.zookeeper.ZkAMRegistry;
import org.apache.tez.frameworkplugins.AmExtensions;
import org.apache.tez.frameworkplugins.ServerFrameworkService;
import org.apache.tez.frameworkplugins.zookeeper.ZkStandaloneAmExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperStandaloneServerFrameworkService
implements ServerFrameworkService {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperStandaloneServerFrameworkService.class);
    private ZkAMRegistry amRegistry;

    @Override
    public synchronized Optional<AMRegistry> createOrGetAMRegistry(Configuration conf) {
        if (this.amRegistry == null) {
            try {
                String externalID = System.getenv("TEZ_AM_EXTERNAL_ID");
                this.amRegistry = new ZkAMRegistry(externalID);
                this.amRegistry.init(conf);
                this.amRegistry.start();
                LOG.info("Created Zookeeper based AM Registry with externalID: {}", (Object)externalID);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.of(this.amRegistry);
    }

    @Override
    public Optional<AmExtensions> createOrGetDAGAppMasterExtensions() {
        return Optional.of(new ZkStandaloneAmExtensions(this));
    }
}

