/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.frameworkplugins.zookeeper;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.client.registry.AMRegistry;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.frameworkplugins.AmExtensions;
import org.apache.tez.frameworkplugins.ServerFrameworkService;

public class ZkStandaloneAmExtensions
implements AmExtensions {
    ServerFrameworkService myFrameworkService;

    public ZkStandaloneAmExtensions(ServerFrameworkService myFrameworkService) {
        this.myFrameworkService = myFrameworkService;
    }

    @Override
    public Optional<ContainerId> allocateContainerId(Configuration conf) {
        try {
            Optional<AMRegistry> amRegistry = this.myFrameworkService.createOrGetAMRegistry(conf);
            if (amRegistry.isPresent()) {
                ApplicationId appId = (ApplicationId)amRegistry.get().generateNewId().get();
                ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
                return Optional.of(ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)0L));
            }
            throw new RuntimeException("AMRegistry is required for ZkStandaloneAmExtensions");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean checkTaskResources(Map<String, Vertex> vertices, AppContext appContext) {
        return false;
    }

    @Override
    public boolean isUsingYarnServicePlugin() {
        return false;
    }

    @Override
    public Optional<DAGProtos.ConfigurationProto> loadConfigurationProto() {
        try {
            return Optional.of(TezUtilsInternal.loadConfProtoFromText());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Token<JobTokenIdentifier>> getSessionToken(ApplicationAttemptId appAttemptID, JobTokenSecretManager jobTokenSecretManager, Credentials amCredentials) {
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(appAttemptID.getApplicationId().toString()));
        Token newSessionToken = new Token((TokenIdentifier)identifier, (SecretManager)jobTokenSecretManager);
        newSessionToken.setService(identifier.getJobId());
        TokenCache.setSessionToken((Token)newSessionToken, (Credentials)amCredentials);
        return Optional.of(newSessionToken);
    }

    @Override
    public Optional<DAGProtos.PlanLocalResourcesProto> getAdditionalSessionResources(String dir) {
        return Optional.of(DAGProtos.PlanLocalResourcesProto.getDefaultInstance());
    }
}

