/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client.registry.zookeeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.curator.RetryLoop;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.registry.AMRecord;
import org.apache.tez.client.registry.AMRegistry;
import org.apache.tez.client.registry.zookeeper.ZkConfig;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZkAMRegistry
extends AMRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ZkAMRegistry.class);
    private CuratorFramework client = null;
    private String namespace = null;
    private List<AMRecord> amRecords = new ArrayList<AMRecord>();
    private ZkConfig zkConfig = null;
    private boolean started = false;
    private String externalId;

    public ZkAMRegistry(String externalId) {
        super("ZkAMRegistry");
        this.externalId = externalId;
    }

    public void serviceInit(Configuration conf) {
        if (this.zkConfig == null) {
            this.zkConfig = new ZkConfig(conf);
            this.client = this.zkConfig.createCuratorFramework();
            this.namespace = this.zkConfig.getZkNamespace();
            LOG.info("AMRegistryZkImpl initialized with namespace: {}", (Object)this.namespace);
        }
    }

    public void serviceStart() throws Exception {
        if (!this.started) {
            this.client.start();
            this.started = true;
            LOG.info("AMRegistryZkImpl started");
        }
    }

    public void serviceStop() throws Exception {
        ArrayList<AMRecord> records = new ArrayList<AMRecord>(this.amRecords);
        for (AMRecord amRecord : records) {
            this.remove(amRecord);
        }
        this.client.close();
        LOG.info("AMRegistryZkImpl shutdown");
    }

    public void add(AMRecord server) throws Exception {
        RegistryUtils.ServiceRecordMarshal marshal = new RegistryUtils.ServiceRecordMarshal();
        String json = marshal.toJson((Object)server.toServiceRecord());
        try {
            String path = this.namespace + "/" + server.getApplicationId().toString();
            this.client.setData().forPath(path, json.getBytes());
            LOG.info("Added AMRecord to zkpath {}", (Object)path);
        }
        catch (KeeperException.NoNodeException nne) {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.namespace + "/" + server.getApplicationId().toString(), json.getBytes());
        }
        this.amRecords.add(server);
    }

    public void remove(AMRecord server) throws Exception {
        this.amRecords.remove(server);
        String path = this.namespace + "/" + server.getApplicationId().toString();
        this.client.delete().forPath(path);
        LOG.info("Deleted AMRecord from zkpath {}", (Object)path);
    }

    public Optional<ApplicationId> generateNewId() throws Exception {
        this.createNamespaceIfNotExists();
        long namespaceCreationTime = this.getNamespaceCreationTime();
        boolean success = false;
        long startTime = System.currentTimeMillis();
        RetryPolicy retryPolicy = this.zkConfig.getRetryPolicy();
        int tryId = 0;
        for (int i = 0; i < this.zkConfig.getCuratorMaxRetries() && !success; ++i) {
            List children = (List)this.client.getChildren().forPath(this.namespace);
            if (children != null && children.size() != 0) {
                Collections.sort(children, Collections.reverseOrder());
                String last = (String)children.get(0);
                ApplicationId lastAppId = ApplicationId.fromString((String)last);
                tryId = lastAppId.getId() + 1;
            }
            ApplicationId tryAppId = ApplicationId.newInstance((long)namespaceCreationTime, (int)tryId);
            try {
                ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(this.namespace + "/" + tryAppId.toString(), new byte[0]);
                success = true;
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExists) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                retryPolicy.allowRetry(i + 1, elapsedTime, RetryLoop.getDefaultRetrySleeper());
                ++tryId;
            }
        }
        if (success) {
            return Optional.of(ApplicationId.newInstance((long)namespaceCreationTime, (int)tryId));
        }
        throw new RuntimeException("Could not obtain unique ApplicationId after " + this.zkConfig.getCuratorMaxRetries() + " tries");
    }

    public AMRecord createAmRecord(String computeName, ApplicationId appId, String hostName, String hostIp, int port) {
        return new AMRecord(appId, hostName, hostIp, port, this.externalId, computeName);
    }

    private long getNamespaceCreationTime() throws Exception {
        Stat stat = (Stat)this.client.checkExists().forPath(this.namespace);
        return stat.getCtime();
    }

    private void createNamespaceIfNotExists() throws Exception {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(CreateMode.CONTAINER)).forPath(this.namespace, new byte[0]);
        }
        catch (KeeperException.NodeExistsException nodeExists) {
            LOG.info("Namespace already exists, will use existing: {}", (Object)this.namespace);
        }
    }
}

