/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NetUtils {
    public static final Logger LOG = LoggerFactory.getLogger(NetUtils.class);

    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr(target, -1);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort) {
        URI uri;
        boolean hasScheme = (target = Objects.requireNonNull(target, "target == null").trim()).contains("://");
        if (!hasScheme && target.charAt(0) == '/') {
            target = target.substring(1);
        }
        try {
            uri = new URI(hasScheme ? target : "dummy://" + target);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to create URI from target " + target, e);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = defaultPort;
        }
        String path = uri.getPath();
        if (host == null) {
            throw new IllegalArgumentException("Host is null in " + target);
        }
        if (port < 0) {
            throw new IllegalArgumentException("Port = " + port + " < 0 in " + target);
        }
        if (!hasScheme && path != null && !path.isEmpty()) {
            throw new IllegalArgumentException("Unexpected path in " + target);
        }
        return NetUtils.createSocketAddrForHost(host, port);
    }

    public static InetSocketAddress createSocketAddrForHost(String host, int port) {
        InetSocketAddress addr;
        String staticHost = StaticResolution.get(host);
        String resolveHost = staticHost != null ? staticHost : host;
        try {
            InetAddress iaddr = InetAddress.getByName(resolveHost);
            if (staticHost != null) {
                iaddr = InetAddress.getByAddress(host, iaddr.getAddress());
            }
            addr = new InetSocketAddress(iaddr, port);
        }
        catch (UnknownHostException e) {
            addr = InetSocketAddress.createUnresolved(host, port);
        }
        return addr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InetSocketAddress createLocalServerAddress() {
        try (ServerSocket s2 = new ServerSocket();){
            s2.setReuseAddress(true);
            s2.bind(null);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)s2.getLocalSocketAddress();
            return inetSocketAddress;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String address2String(InetSocketAddress address) {
        StringBuilder b = new StringBuilder(address.getHostName());
        if (address.getAddress() instanceof Inet6Address) {
            b.insert(0, '[').append(']');
        }
        return b.append(':').append(address.getPort()).toString();
    }

    public static abstract class StaticResolution {
        private static final Map<String, String> HOST_TO_RESOLVED = new ConcurrentHashMap<String, String>();

        public static void put(String host, String resolvedName) {
            HOST_TO_RESOLVED.put(host, resolvedName);
        }

        public static String get(String host) {
            return HOST_TO_RESOLVED.get(host);
        }
    }
}

