/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NativeLibraryChecker {
    public static final Logger LOG = LoggerFactory.getLogger(NativeLibraryChecker.class);

    private NativeLibraryChecker() {
    }

    public static void main(String[] args) {
        String usage = "NativeLibraryChecker [-a|-h]\n  -a  use -a to check all libraries are available\n      by default just check ratis library (and\n      winutils.exe on Windows OS) is available\n      exit with error code 1 if check failed\n  -h  print this message\n";
        if (args.length > 1 || args.length == 1 && !args[0].equals("-a") && !args[0].equals("-h")) {
            System.err.println(usage);
            ExitUtils.terminate(1, "Illegal arguments.", LOG);
        }
        if (args.length == 1 && args[0].equals("-h")) {
            System.out.println(usage);
            return;
        }
        boolean nativeRatisLoaded = NativeCodeLoader.isNativeCodeLoaded();
        String raftLibraryName = "";
        if (nativeRatisLoaded) {
            raftLibraryName = NativeCodeLoader.getLibraryName();
        }
        System.out.println("Native library checking:");
        System.out.printf("raft:  %b %s%n", nativeRatisLoaded, raftLibraryName);
        if (!nativeRatisLoaded) {
            ExitUtils.terminate(1, "Failed to load native library.", LOG);
        }
    }
}

