/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.netty.internal.tcnative;

import org.apache.ratis.thirdparty.io.netty.internal.tcnative.CertificateCallback;
import org.apache.ratis.thirdparty.io.netty.internal.tcnative.SSLTask;

final class CertificateCallbackTask
extends SSLTask {
    private final byte[] keyTypeBytes;
    private final byte[][] asn1DerEncodedPrincipals;
    private final CertificateCallback callback;

    CertificateCallbackTask(long ssl, byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals, CertificateCallback callback) {
        super(ssl);
        this.keyTypeBytes = keyTypeBytes;
        this.asn1DerEncodedPrincipals = asn1DerEncodedPrincipals;
        this.callback = callback;
    }

    @Override
    protected int runTask(long ssl) {
        try {
            this.callback.handle(ssl, this.keyTypeBytes, this.asn1DerEncodedPrincipals);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

