/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc.netty;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ratis.thirdparty.com.google.common.base.MoreObjects;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.ratis.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.ratis.thirdparty.io.grpc.InternalChannelz;
import org.apache.ratis.thirdparty.io.grpc.InternalInstrumented;
import org.apache.ratis.thirdparty.io.grpc.InternalLogId;
import org.apache.ratis.thirdparty.io.grpc.InternalWithLogId;
import org.apache.ratis.thirdparty.io.grpc.ServerStreamTracer;
import org.apache.ratis.thirdparty.io.grpc.internal.InternalServer;
import org.apache.ratis.thirdparty.io.grpc.internal.ObjectPool;
import org.apache.ratis.thirdparty.io.grpc.internal.ServerListener;
import org.apache.ratis.thirdparty.io.grpc.internal.ServerTransportListener;
import org.apache.ratis.thirdparty.io.grpc.internal.TransportTracer;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerTransport;
import org.apache.ratis.thirdparty.io.grpc.netty.ProtocolNegotiator;
import org.apache.ratis.thirdparty.io.grpc.netty.Utils;
import org.apache.ratis.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelOption;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.ServerChannel;
import org.apache.ratis.thirdparty.io.netty.util.AbstractReferenceCounted;
import org.apache.ratis.thirdparty.io.netty.util.ReferenceCounted;
import org.apache.ratis.thirdparty.io.netty.util.concurrent.Future;
import org.apache.ratis.thirdparty.io.netty.util.concurrent.GenericFutureListener;

class NettyServer
implements InternalServer,
InternalWithLogId {
    private static final Logger log = Logger.getLogger(InternalServer.class.getName());
    private final InternalLogId logId;
    private final SocketAddress address;
    private final Class<? extends ServerChannel> channelType;
    private final Map<ChannelOption<?>, ?> channelOptions;
    private final ProtocolNegotiator protocolNegotiator;
    private final int maxStreamsPerConnection;
    private final ObjectPool<? extends EventLoopGroup> bossGroupPool;
    private final ObjectPool<? extends EventLoopGroup> workerGroupPool;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerListener listener;
    private Channel channel;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private final long keepAliveTimeInNanos;
    private final long keepAliveTimeoutInNanos;
    private final long maxConnectionIdleInNanos;
    private final long maxConnectionAgeInNanos;
    private final long maxConnectionAgeGraceInNanos;
    private final boolean permitKeepAliveWithoutCalls;
    private final long permitKeepAliveTimeInNanos;
    private final ReferenceCounted eventLoopReferenceCounter = new EventLoopReferenceCounter();
    private final List<? extends ServerStreamTracer.Factory> streamTracerFactories;
    private final TransportTracer.Factory transportTracerFactory;
    private final InternalChannelz channelz;
    private final AtomicReference<InternalInstrumented<InternalChannelz.SocketStats>> listenSocketStats = new AtomicReference();

    NettyServer(SocketAddress address, Class<? extends ServerChannel> channelType, Map<ChannelOption<?>, ?> channelOptions, ObjectPool<? extends EventLoopGroup> bossGroupPool, ObjectPool<? extends EventLoopGroup> workerGroupPool, ProtocolNegotiator protocolNegotiator, List<? extends ServerStreamTracer.Factory> streamTracerFactories, TransportTracer.Factory transportTracerFactory, int maxStreamsPerConnection, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeInNanos, long keepAliveTimeoutInNanos, long maxConnectionIdleInNanos, long maxConnectionAgeInNanos, long maxConnectionAgeGraceInNanos, boolean permitKeepAliveWithoutCalls, long permitKeepAliveTimeInNanos, InternalChannelz channelz) {
        this.address = address;
        this.channelType = Preconditions.checkNotNull(channelType, "channelType");
        Preconditions.checkNotNull(channelOptions, "channelOptions");
        this.channelOptions = new HashMap(channelOptions);
        this.bossGroupPool = Preconditions.checkNotNull(bossGroupPool, "bossGroupPool");
        this.workerGroupPool = Preconditions.checkNotNull(workerGroupPool, "workerGroupPool");
        this.bossGroup = bossGroupPool.getObject();
        this.workerGroup = workerGroupPool.getObject();
        this.protocolNegotiator = Preconditions.checkNotNull(protocolNegotiator, "protocolNegotiator");
        this.streamTracerFactories = Preconditions.checkNotNull(streamTracerFactories, "streamTracerFactories");
        this.transportTracerFactory = transportTracerFactory;
        this.maxStreamsPerConnection = maxStreamsPerConnection;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.keepAliveTimeInNanos = keepAliveTimeInNanos;
        this.keepAliveTimeoutInNanos = keepAliveTimeoutInNanos;
        this.maxConnectionIdleInNanos = maxConnectionIdleInNanos;
        this.maxConnectionAgeInNanos = maxConnectionAgeInNanos;
        this.maxConnectionAgeGraceInNanos = maxConnectionAgeGraceInNanos;
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
        this.permitKeepAliveTimeInNanos = permitKeepAliveTimeInNanos;
        this.channelz = Preconditions.checkNotNull(channelz);
        this.logId = InternalLogId.allocate(this.getClass(), address != null ? address.toString() : "No address");
    }

    @Override
    public SocketAddress getListenSocketAddress() {
        if (this.channel == null) {
            return this.address;
        }
        return this.channel.localAddress();
    }

    @Override
    public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
        return this.listenSocketStats.get();
    }

    @Override
    public void start(ServerListener serverListener) throws IOException {
        this.listener = Preconditions.checkNotNull(serverListener, "serverListener");
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.bossGroup, this.workerGroup);
        b.channel(this.channelType);
        b.option(ChannelOption.SO_BACKLOG, 128);
        b.childOption(ChannelOption.SO_KEEPALIVE, true);
        if (this.channelOptions != null) {
            for (Map.Entry<ChannelOption<?>, ?> entry : this.channelOptions.entrySet()) {
                ChannelOption<?> key = entry.getKey();
                b.childOption(key, entry.getValue());
            }
        }
        b.childHandler(new ChannelInitializer<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initChannel(Channel ch) throws Exception {
                ServerTransportListener transportListener;
                ChannelPromise channelDone = ch.newPromise();
                long maxConnectionAgeInNanos = NettyServer.this.maxConnectionAgeInNanos;
                if (maxConnectionAgeInNanos != Long.MAX_VALUE) {
                    maxConnectionAgeInNanos = (long)((0.9 + Math.random() * 0.2) * (double)maxConnectionAgeInNanos);
                }
                NettyServerTransport transport = new NettyServerTransport(ch, channelDone, NettyServer.this.protocolNegotiator, NettyServer.this.streamTracerFactories, NettyServer.this.transportTracerFactory.create(), NettyServer.this.maxStreamsPerConnection, NettyServer.this.flowControlWindow, NettyServer.this.maxMessageSize, NettyServer.this.maxHeaderListSize, NettyServer.this.keepAliveTimeInNanos, NettyServer.this.keepAliveTimeoutInNanos, NettyServer.this.maxConnectionIdleInNanos, maxConnectionAgeInNanos, NettyServer.this.maxConnectionAgeGraceInNanos, NettyServer.this.permitKeepAliveWithoutCalls, NettyServer.this.permitKeepAliveTimeInNanos);
                NettyServer nettyServer = NettyServer.this;
                synchronized (nettyServer) {
                    if (NettyServer.this.channel != null && !NettyServer.this.channel.isOpen()) {
                        ch.close();
                        return;
                    }
                    NettyServer.this.eventLoopReferenceCounter.retain();
                    transportListener = NettyServer.this.listener.transportCreated(transport);
                }
                transport.start(transportListener);
                final class LoopReleaser
                implements ChannelFutureListener {
                    boolean done;

                    LoopReleaser() {
                    }

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!this.done) {
                            this.done = true;
                            NettyServer.this.eventLoopReferenceCounter.release();
                        }
                    }
                }
                LoopReleaser loopReleaser = new LoopReleaser();
                channelDone.addListener(loopReleaser);
                ch.closeFuture().addListener(loopReleaser);
            }
        });
        ChannelFuture future = b.bind(this.address);
        try {
            future.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted waiting for bind");
        }
        if (!future.isSuccess()) {
            throw new IOException("Failed to bind", future.cause());
        }
        this.channel = future.channel();
        Future<?> channelzFuture = this.channel.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                ListenSocket listenSocket = new ListenSocket(NettyServer.this.channel);
                NettyServer.this.listenSocketStats.set(listenSocket);
                NettyServer.this.channelz.addListenSocket(listenSocket);
            }
        });
        try {
            channelzFuture.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted while registering listen socket to channelz", ex);
        }
    }

    @Override
    public void shutdown() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        this.channel.close().addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                InternalInstrumented stats;
                if (!future.isSuccess()) {
                    log.log(Level.WARNING, "Error shutting down server", future.cause());
                }
                if ((stats = (InternalInstrumented)NettyServer.this.listenSocketStats.getAndSet(null)) != null) {
                    NettyServer.this.channelz.removeListenSocket(stats);
                }
                NettyServer nettyServer = NettyServer.this;
                synchronized (nettyServer) {
                    NettyServer.this.listener.serverShutdown();
                }
                NettyServer.this.eventLoopReferenceCounter.release();
            }
        });
        try {
            this.channel.closeFuture().await();
        }
        catch (InterruptedException e) {
            log.log(Level.FINE, "Interrupted while shutting down", e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("logId", this.logId.getId()).add("address", this.address).toString();
    }

    private static final class ListenSocket
    implements InternalInstrumented<InternalChannelz.SocketStats> {
        private final InternalLogId id;
        private final Channel ch;

        ListenSocket(Channel ch) {
            this.ch = ch;
            this.id = InternalLogId.allocate(this.getClass(), String.valueOf(ch.localAddress()));
        }

        @Override
        public ListenableFuture<InternalChannelz.SocketStats> getStats() {
            final SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
            if (this.ch.eventLoop().inEventLoop()) {
                ret.set(new InternalChannelz.SocketStats(null, this.ch.localAddress(), null, Utils.getSocketOptions(this.ch), null));
                return ret;
            }
            this.ch.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    ret.set(new InternalChannelz.SocketStats(null, ListenSocket.this.ch.localAddress(), null, Utils.getSocketOptions(ListenSocket.this.ch), null));
                }
            }).addListener(new GenericFutureListener<Future<Object>>(){

                @Override
                public void operationComplete(Future<Object> future) throws Exception {
                    if (!future.isSuccess()) {
                        ret.setException(future.cause());
                    }
                }
            });
            return ret;
        }

        @Override
        public InternalLogId getLogId() {
            return this.id;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("logId", this.id.getId()).add("channel", this.ch).toString();
        }
    }

    class EventLoopReferenceCounter
    extends AbstractReferenceCounted {
        EventLoopReferenceCounter() {
        }

        @Override
        protected void deallocate() {
            try {
                if (NettyServer.this.bossGroup != null) {
                    NettyServer.this.bossGroupPool.returnObject(NettyServer.this.bossGroup);
                }
            }
            finally {
                NettyServer.this.bossGroup = null;
                try {
                    if (NettyServer.this.workerGroup != null) {
                        NettyServer.this.workerGroupPool.returnObject(NettyServer.this.workerGroup);
                    }
                }
                finally {
                    NettyServer.this.workerGroup = null;
                }
            }
        }

        @Override
        public ReferenceCounted touch(Object hint) {
            return this;
        }
    }
}

