/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.common.base.MoreObjects;
import org.apache.ratis.thirdparty.com.google.common.base.Objects;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.com.google.common.base.Strings;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ratis.thirdparty.io.grpc.internal.HedgingPolicy;
import org.apache.ratis.thirdparty.io.grpc.internal.RetriableStream;
import org.apache.ratis.thirdparty.io.grpc.internal.RetryPolicy;
import org.apache.ratis.thirdparty.io.grpc.internal.ServiceConfigUtil;

final class ManagedChannelServiceConfig {
    private final Map<String, MethodInfo> serviceMethodMap;
    private final Map<String, MethodInfo> serviceMap;
    @Nullable
    private final RetriableStream.Throttle retryThrottling;
    @Nullable
    private final Object loadBalancingConfig;

    ManagedChannelServiceConfig(Map<String, MethodInfo> serviceMethodMap, Map<String, MethodInfo> serviceMap, @Nullable RetriableStream.Throttle retryThrottling, @Nullable Object loadBalancingConfig) {
        this.serviceMethodMap = Collections.unmodifiableMap(new HashMap<String, MethodInfo>(serviceMethodMap));
        this.serviceMap = Collections.unmodifiableMap(new HashMap<String, MethodInfo>(serviceMap));
        this.retryThrottling = retryThrottling;
        this.loadBalancingConfig = loadBalancingConfig;
    }

    static ManagedChannelServiceConfig fromServiceConfig(Map<String, ?> serviceConfig, boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit, @Nullable Object loadBalancingConfig) {
        RetriableStream.Throttle retryThrottling = null;
        if (retryEnabled) {
            retryThrottling = ServiceConfigUtil.getThrottlePolicy(serviceConfig);
        }
        HashMap<String, MethodInfo> serviceMethodMap = new HashMap<String, MethodInfo>();
        HashMap<String, MethodInfo> serviceMap = new HashMap<String, MethodInfo>();
        List<Map<String, ?>> methodConfigs = ServiceConfigUtil.getMethodConfigFromServiceConfig(serviceConfig);
        if (methodConfigs == null) {
            return new ManagedChannelServiceConfig(serviceMethodMap, serviceMap, retryThrottling, loadBalancingConfig);
        }
        for (Map<String, ?> methodConfig : methodConfigs) {
            MethodInfo info = new MethodInfo(methodConfig, retryEnabled, maxRetryAttemptsLimit, maxHedgedAttemptsLimit);
            List<Map<String, ?>> nameList = ServiceConfigUtil.getNameListFromMethodConfig(methodConfig);
            Preconditions.checkArgument(nameList != null && !nameList.isEmpty(), "no names in method config %s", methodConfig);
            for (Map<String, ?> name : nameList) {
                String serviceName = ServiceConfigUtil.getServiceFromName(name);
                Preconditions.checkArgument(!Strings.isNullOrEmpty(serviceName), "missing service name");
                String methodName = ServiceConfigUtil.getMethodFromName(name);
                if (Strings.isNullOrEmpty(methodName)) {
                    Preconditions.checkArgument(!serviceMap.containsKey(serviceName), "Duplicate service %s", (Object)serviceName);
                    serviceMap.put(serviceName, info);
                    continue;
                }
                String fullMethodName = MethodDescriptor.generateFullMethodName(serviceName, methodName);
                Preconditions.checkArgument(!serviceMethodMap.containsKey(fullMethodName), "Duplicate method name %s", (Object)fullMethodName);
                serviceMethodMap.put(fullMethodName, info);
            }
        }
        return new ManagedChannelServiceConfig(serviceMethodMap, serviceMap, retryThrottling, loadBalancingConfig);
    }

    Map<String, MethodInfo> getServiceMap() {
        return this.serviceMap;
    }

    Map<String, MethodInfo> getServiceMethodMap() {
        return this.serviceMethodMap;
    }

    @Nullable
    @VisibleForTesting
    Object getLoadBalancingConfig() {
        return this.loadBalancingConfig;
    }

    static final class MethodInfo {
        final Long timeoutNanos;
        final Boolean waitForReady;
        final Integer maxInboundMessageSize;
        final Integer maxOutboundMessageSize;
        final RetryPolicy retryPolicy;
        final HedgingPolicy hedgingPolicy;

        MethodInfo(Map<String, ?> methodConfig, boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit) {
            this.timeoutNanos = ServiceConfigUtil.getTimeoutFromMethodConfig(methodConfig);
            this.waitForReady = ServiceConfigUtil.getWaitForReadyFromMethodConfig(methodConfig);
            this.maxInboundMessageSize = ServiceConfigUtil.getMaxResponseMessageBytesFromMethodConfig(methodConfig);
            if (this.maxInboundMessageSize != null) {
                Preconditions.checkArgument(this.maxInboundMessageSize >= 0, "maxInboundMessageSize %s exceeds bounds", (Object)this.maxInboundMessageSize);
            }
            this.maxOutboundMessageSize = ServiceConfigUtil.getMaxRequestMessageBytesFromMethodConfig(methodConfig);
            if (this.maxOutboundMessageSize != null) {
                Preconditions.checkArgument(this.maxOutboundMessageSize >= 0, "maxOutboundMessageSize %s exceeds bounds", (Object)this.maxOutboundMessageSize);
            }
            Map<String, ?> retryPolicyMap = retryEnabled ? ServiceConfigUtil.getRetryPolicyFromMethodConfig(methodConfig) : null;
            this.retryPolicy = retryPolicyMap == null ? RetryPolicy.DEFAULT : MethodInfo.retryPolicy(retryPolicyMap, maxRetryAttemptsLimit);
            Map<String, ?> hedgingPolicyMap = retryEnabled ? ServiceConfigUtil.getHedgingPolicyFromMethodConfig(methodConfig) : null;
            this.hedgingPolicy = hedgingPolicyMap == null ? HedgingPolicy.DEFAULT : MethodInfo.hedgingPolicy(hedgingPolicyMap, maxHedgedAttemptsLimit);
        }

        public int hashCode() {
            return Objects.hashCode(this.timeoutNanos, this.waitForReady, this.maxInboundMessageSize, this.maxOutboundMessageSize, this.retryPolicy, this.hedgingPolicy);
        }

        public boolean equals(Object other) {
            if (!(other instanceof MethodInfo)) {
                return false;
            }
            MethodInfo that = (MethodInfo)other;
            return Objects.equal(this.timeoutNanos, that.timeoutNanos) && Objects.equal(this.waitForReady, that.waitForReady) && Objects.equal(this.maxInboundMessageSize, that.maxInboundMessageSize) && Objects.equal(this.maxOutboundMessageSize, that.maxOutboundMessageSize) && Objects.equal(this.retryPolicy, that.retryPolicy) && Objects.equal(this.hedgingPolicy, that.hedgingPolicy);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("timeoutNanos", this.timeoutNanos).add("waitForReady", this.waitForReady).add("maxInboundMessageSize", this.maxInboundMessageSize).add("maxOutboundMessageSize", this.maxOutboundMessageSize).add("retryPolicy", this.retryPolicy).add("hedgingPolicy", this.hedgingPolicy).toString();
        }

        private static RetryPolicy retryPolicy(Map<String, ?> retryPolicy, int maxAttemptsLimit) {
            int maxAttempts = Preconditions.checkNotNull(ServiceConfigUtil.getMaxAttemptsFromRetryPolicy(retryPolicy), "maxAttempts cannot be empty");
            Preconditions.checkArgument(maxAttempts >= 2, "maxAttempts must be greater than 1: %s", maxAttempts);
            maxAttempts = Math.min(maxAttempts, maxAttemptsLimit);
            long initialBackoffNanos = Preconditions.checkNotNull(ServiceConfigUtil.getInitialBackoffNanosFromRetryPolicy(retryPolicy), "initialBackoff cannot be empty");
            Preconditions.checkArgument(initialBackoffNanos > 0L, "initialBackoffNanos must be greater than 0: %s", initialBackoffNanos);
            long maxBackoffNanos = Preconditions.checkNotNull(ServiceConfigUtil.getMaxBackoffNanosFromRetryPolicy(retryPolicy), "maxBackoff cannot be empty");
            Preconditions.checkArgument(maxBackoffNanos > 0L, "maxBackoff must be greater than 0: %s", maxBackoffNanos);
            double backoffMultiplier = Preconditions.checkNotNull(ServiceConfigUtil.getBackoffMultiplierFromRetryPolicy(retryPolicy), "backoffMultiplier cannot be empty");
            Preconditions.checkArgument(backoffMultiplier > 0.0, "backoffMultiplier must be greater than 0: %s", (Object)backoffMultiplier);
            return new RetryPolicy(maxAttempts, initialBackoffNanos, maxBackoffNanos, backoffMultiplier, ServiceConfigUtil.getRetryableStatusCodesFromRetryPolicy(retryPolicy));
        }

        private static HedgingPolicy hedgingPolicy(Map<String, ?> hedgingPolicy, int maxAttemptsLimit) {
            int maxAttempts = Preconditions.checkNotNull(ServiceConfigUtil.getMaxAttemptsFromHedgingPolicy(hedgingPolicy), "maxAttempts cannot be empty");
            Preconditions.checkArgument(maxAttempts >= 2, "maxAttempts must be greater than 1: %s", maxAttempts);
            maxAttempts = Math.min(maxAttempts, maxAttemptsLimit);
            long hedgingDelayNanos = Preconditions.checkNotNull(ServiceConfigUtil.getHedgingDelayNanosFromHedgingPolicy(hedgingPolicy), "hedgingDelay cannot be empty");
            Preconditions.checkArgument(hedgingDelayNanos >= 0L, "hedgingDelay must not be negative: %s", hedgingDelayNanos);
            return new HedgingPolicy(maxAttempts, hedgingDelayNanos, ServiceConfigUtil.getNonFatalStatusCodesFromHedgingPolicy(hedgingPolicy));
        }
    }
}

