/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.util.Collections;
import java.util.List;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.statemachine.SnapshotInfo;

public class FileListSnapshotInfo
implements SnapshotInfo {
    private final TermIndex termIndex;
    private final List<FileInfo> files;

    public FileListSnapshotInfo(List<FileInfo> files, long term, long index) {
        this.termIndex = TermIndex.newTermIndex(term, index);
        this.files = Collections.unmodifiableList(files);
    }

    @Override
    public TermIndex getTermIndex() {
        return this.termIndex;
    }

    @Override
    public long getTerm() {
        return this.termIndex.getTerm();
    }

    @Override
    public long getIndex() {
        return this.termIndex.getIndex();
    }

    @Override
    public List<FileInfo> getFiles() {
        return this.files;
    }

    public String toString() {
        return this.termIndex + ":" + this.files;
    }
}

