/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface StateMachine
extends Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(StateMachine.class);

    public void initialize(RaftServer var1, RaftGroupId var2, RaftStorage var3) throws IOException;

    public LifeCycle.State getLifeCycleState();

    public void pause();

    public void reinitialize() throws IOException;

    public long takeSnapshot() throws IOException;

    public StateMachineStorage getStateMachineStorage();

    public SnapshotInfo getLatestSnapshot();

    public CompletableFuture<Message> query(Message var1);

    public CompletableFuture<Message> queryStale(Message var1, long var2);

    public TransactionContext startTransaction(RaftClientRequest var1) throws IOException;

    default public CompletableFuture<?> writeStateMachineData(RaftProtos.LogEntryProto entry) {
        return null;
    }

    default public CompletableFuture<ByteString> readStateMachineData(RaftProtos.LogEntryProto entry) {
        return null;
    }

    public TransactionContext preAppendTransaction(TransactionContext var1) throws IOException;

    public TransactionContext cancelTransaction(TransactionContext var1) throws IOException;

    public TransactionContext applyTransactionSerial(TransactionContext var1);

    default public void notifyIndexUpdate(long term, long index) {
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext var1);

    public TermIndex getLastAppliedTermIndex();

    public void notifyNotLeader(Collection<TransactionContext> var1) throws IOException;

    default public void notifySlowness(RaftProtos.RoleInfoProto roleInfoProto) {
    }

    default public void notifyLogFailed(Throwable t, RaftProtos.LogEntryProto failedEntry) {
    }

    default public void notifyExtendedNoLeader(RaftProtos.RoleInfoProto roleInfoProto) {
    }

    default public CompletableFuture<Void> flushStateMachineData(long index) {
        return CompletableFuture.completedFuture(null);
    }

    default public CompletableFuture<Void> truncateStateMachineData(long index) {
        return CompletableFuture.completedFuture(null);
    }

    default public CompletableFuture<TermIndex> notifyInstallSnapshotFromLeader(RaftProtos.RoleInfoProto roleInfoProto, TermIndex firstTermIndexInLog) {
        return CompletableFuture.completedFuture(null);
    }

    default public void notifyLeaderChanged(RaftGroupMemberId groupMemberId, RaftPeerId raftPeerId) {
    }

    default public void notifyGroupRemove() {
    }

    default public String toStateMachineLogEntryString(RaftProtos.StateMachineLogEntryProto proto) {
        return ServerProtoUtils.toStateMachineLogEntryString(proto, null);
    }

    public static interface Registry
    extends Function<RaftGroupId, StateMachine> {
    }
}

