/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;

public class RaftLogIndex {
    private final Object name;
    private final AtomicLong index;

    public RaftLogIndex(Object name, long initialValue) {
        this.name = name;
        this.index = new AtomicLong(initialValue);
    }

    public long get() {
        return this.index.get();
    }

    public boolean setUnconditionally(long newIndex, Consumer<Object> log) {
        long old = this.index.getAndSet(newIndex);
        log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": setUnconditionally " + old + " -> " + newIndex));
        return old != newIndex;
    }

    public boolean updateUnconditionally(LongUnaryOperator update, Consumer<Object> log) {
        long old = this.index.getAndUpdate(update);
        long newIndex = update.applyAsLong(old);
        log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": updateUnconditionally " + old + " -> " + newIndex));
        return old != newIndex;
    }

    public boolean updateIncreasingly(long newIndex, Consumer<Object> log) {
        long old = this.index.getAndSet(newIndex);
        Preconditions.assertTrue(old <= newIndex, () -> "Failed to updateIncreasingly for " + this.name + ": " + old + " -> " + newIndex);
        log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": updateIncreasingly " + old + " -> " + newIndex));
        return old != newIndex;
    }

    public boolean updateToMax(long newIndex, Consumer<Object> log) {
        long old = this.index.getAndUpdate(oldIndex -> Math.max(oldIndex, newIndex));
        boolean updated = old < newIndex;
        log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": updateToMax old=" + old + ", new=" + newIndex + ", updated? " + updated));
        return updated;
    }

    public long incrementAndGet(Consumer<Object> log) {
        long newIndex = this.index.incrementAndGet();
        log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": incrementAndGet " + (newIndex - 1L) + " -> " + newIndex));
        return newIndex;
    }

    public String toString() {
        return this.name + ":" + this.index;
    }
}

