/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.exceptions.StreamException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamRequests {
    public static final Logger LOG = LoggerFactory.getLogger(StreamRequests.class);
    private final String name;
    private final StreamMap streams = new StreamMap();

    StreamRequests(Object name) {
        this.name = name + "-" + this.getClass().getSimpleName();
    }

    CompletableFuture<?> streamAsync(RaftClientRequest request) {
        RaftProtos.StreamRequestTypeProto stream = request.getType().getStream();
        Preconditions.assertTrue(!stream.getClose());
        Key key = new Key(request.getClientId(), stream.getStreamId());
        PendingStream pending = stream.getMessageId() == 0L ? this.streams.add(key) : this.streams.get(key);
        return pending.append(stream.getMessageId(), request.getMessage());
    }

    CompletableFuture<ByteString> streamCloseAsync(RaftClientRequest request) {
        RaftProtos.StreamRequestTypeProto stream = request.getType().getStream();
        Preconditions.assertTrue(stream.getClose());
        Key key = new Key(request.getClientId(), stream.getStreamId());
        PendingStream pending = this.streams.remove(key);
        if (pending == null) {
            return JavaUtils.completeExceptionally(new StreamException(this.name + ": " + key + " not found"));
        }
        return pending.getBytes(stream.getMessageId(), request.getMessage());
    }

    void clear() {
        this.streams.clear();
    }

    static class StreamMap {
        private final ConcurrentMap<Key, PendingStream> map = new ConcurrentHashMap<Key, PendingStream>();

        StreamMap() {
        }

        PendingStream add(Key key) {
            PendingStream pending = new PendingStream(key);
            PendingStream previous = this.map.put(key, pending);
            Preconditions.assertNull((Object)previous, "previous");
            return pending;
        }

        PendingStream get(Key key) {
            return (PendingStream)this.map.get(key);
        }

        PendingStream remove(Key key) {
            return (PendingStream)this.map.remove(key);
        }

        void clear() {
            this.map.clear();
        }
    }

    private static class PendingStream {
        private final Key key;
        private long nextId = 0L;
        private ByteString bytes = ByteString.EMPTY;

        PendingStream(Key key) {
            this.key = key;
        }

        synchronized CompletableFuture<ByteString> append(long messageId, Message message) {
            if (messageId != this.nextId) {
                return JavaUtils.completeExceptionally(new StreamException("Unexpected message id in " + this.key + ": messageId = " + messageId + " != nextId = " + this.nextId));
            }
            ++this.nextId;
            this.bytes = this.bytes.concat(message.getContent());
            return CompletableFuture.completedFuture(this.bytes);
        }

        synchronized CompletableFuture<ByteString> getBytes(long messageId, Message message) {
            return this.append(messageId, message);
        }
    }

    private static class Key {
        private final ClientId clientId;
        private final long streamId;

        Key(ClientId clientId, long streamId) {
            this.clientId = clientId;
            this.streamId = streamId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Key that = (Key)obj;
            return this.streamId == that.streamId && this.clientId.equals(that.clientId);
        }

        public int hashCode() {
            return Objects.hash(this.clientId, this.streamId);
        }

        public String toString() {
            return "Stream" + this.streamId + "@" + this.clientId;
        }
    }
}

