/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.PeerProxyMap;

public abstract class RaftServerRpcWithProxy<PROXY extends Closeable, PROXIES extends PeerProxyMap<PROXY>>
implements RaftServerRpc {
    private final Supplier<RaftPeerId> idSupplier;
    private final Supplier<LifeCycle> lifeCycleSupplier;
    private final Supplier<PROXIES> proxiesSupplier;

    public RaftServerRpcWithProxy(Supplier<RaftPeerId> idSupplier, Function<RaftPeerId, PROXIES> proxyCreater) {
        this.idSupplier = idSupplier;
        this.lifeCycleSupplier = JavaUtils.memoize(() -> new LifeCycle(this.getId() + "-" + this.getClass().getSimpleName()));
        this.proxiesSupplier = JavaUtils.memoize(() -> (PeerProxyMap)proxyCreater.apply(this.getId()));
    }

    public RaftPeerId getId() {
        return this.idSupplier.get();
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycleSupplier.get();
    }

    public PROXIES getProxies() {
        return (PROXIES)((PeerProxyMap)this.proxiesSupplier.get());
    }

    @Override
    public void addPeers(Iterable<RaftPeer> peers) {
        ((PeerProxyMap)this.getProxies()).addPeers(peers);
    }

    @Override
    public void handleException(RaftPeerId serverId, Exception e, boolean reconnect) {
        ((PeerProxyMap)this.getProxies()).handleException(serverId, e, reconnect);
    }

    @Override
    public final void start() throws IOException {
        this.getLifeCycle().startAndTransition(this::startImpl, IOException.class);
    }

    public abstract void startImpl() throws IOException;

    @Override
    public final void close() throws IOException {
        this.getLifeCycle().checkStateAndClose(() -> this.closeImpl());
    }

    public void closeImpl() throws IOException {
        ((PeerProxyMap)this.getProxies()).close();
    }
}

