/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.hadoop.ozone.shaded.com.codahale.metrics.Counter;
import org.apache.hadoop.ozone.shaded.com.codahale.metrics.Gauge;
import org.apache.hadoop.ozone.shaded.com.codahale.metrics.Timer;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.metrics.RatisMetrics;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.util.Preconditions;

public final class RaftServerMetrics
extends RatisMetrics {
    public static final String RATIS_SERVER_METRICS = "server";
    public static final String RATIS_SERVER_METRICS_DESC = "Metrics for Raft server";
    public static final String FOLLOWER_LAST_HEARTBEAT_ELAPSED_TIME_METRIC = "%s_lastHeartbeatElapsedTime";
    public static final String LEADER_METRIC_PEER_COMMIT_INDEX = "%s_peerCommitIndex";
    public static final String RAFT_CLIENT_READ_REQUEST = "clientReadRequest";
    public static final String RAFT_CLIENT_STALE_READ_REQUEST = "clientStaleReadRequest";
    public static final String RAFT_CLIENT_WRITE_REQUEST = "clientWriteRequest";
    public static final String RAFT_CLIENT_WATCH_REQUEST = "clientWatch%sRequest";
    public static final String RETRY_REQUEST_CACHE_HIT_COUNTER = "numRetryCacheHits";
    public static final String REQUEST_QUEUE_LIMIT_HIT_COUNTER = "numRequestQueueLimitHits";
    public static final String RESOURCE_LIMIT_HIT_COUNTER = "leaderNumResourceLimitHits";
    public static final String REQUEST_BYTE_SIZE_LIMIT_HIT_COUNTER = "numRequestsByteSizeLimitHits";
    public static final String REQUEST_QUEUE_SIZE = "numPendingRequestInQueue";
    public static final String REQUEST_BYTE_SIZE = "numPendingRequestByteSize";
    private Map<String, Long> followerLastHeartbeatElapsedTimeMap = new HashMap<String, Long>();
    private CommitInfoCache commitInfoCache;
    private static Map<String, RaftServerMetrics> metricsMap = new HashMap<String, RaftServerMetrics>();

    public static RaftServerMetrics getRaftServerMetrics(RaftServerImpl raftServer) {
        RaftServerMetrics serverMetrics = new RaftServerMetrics(raftServer);
        metricsMap.put(raftServer.getMemberId().toString(), serverMetrics);
        return serverMetrics;
    }

    private RaftServerMetrics(RaftServerImpl server) {
        this.registry = this.getMetricRegistryForRaftServer(server.getMemberId().toString());
        this.commitInfoCache = server.getCommitInfoCache();
        this.addPeerCommitIndexGauge(server.getId());
    }

    private RatisMetricRegistry getMetricRegistryForRaftServer(String serverId) {
        return this.create(new MetricRegistryInfo(serverId, "ratis", RATIS_SERVER_METRICS, RATIS_SERVER_METRICS_DESC));
    }

    public void addFollower(RaftPeer peer) {
        String followerName = peer.getId().toString();
        String followerHbMetricKey = String.format(FOLLOWER_LAST_HEARTBEAT_ELAPSED_TIME_METRIC, followerName);
        this.followerLastHeartbeatElapsedTimeMap.put(followerName, 0L);
        this.registry.gauge(followerHbMetricKey, () -> () -> this.followerLastHeartbeatElapsedTimeMap.get(followerName));
        this.addPeerCommitIndexGauge(peer.getId());
    }

    public void addPeerCommitIndexGauge(RaftPeerId peerId) {
        String followerCommitIndexKey = String.format(LEADER_METRIC_PEER_COMMIT_INDEX, peerId);
        this.registry.gauge(followerCommitIndexKey, () -> () -> {
            RaftProtos.CommitInfoProto commitInfoProto = this.commitInfoCache.get(peerId);
            if (commitInfoProto != null) {
                return commitInfoProto.getCommitIndex();
            }
            return 0L;
        });
    }

    @VisibleForTesting
    public static Gauge getPeerCommitIndexGauge(RaftServerImpl server, RaftServerImpl peerServer) {
        RaftServerMetrics serverMetrics = metricsMap.get(server.getMemberId().toString());
        if (serverMetrics == null) {
            return null;
        }
        String followerCommitIndexKey = String.format(LEADER_METRIC_PEER_COMMIT_INDEX, peerServer.getPeer().getId().toString());
        SortedMap<String, Gauge> map = serverMetrics.registry.getGauges((s2, metric) -> s2.contains(followerCommitIndexKey));
        Preconditions.assertTrue(map.size() <= 1);
        return (Gauge)map.get(map.firstKey());
    }

    public void recordFollowerHeartbeatElapsedTime(RaftPeer peer, long elapsedTime) {
        this.followerLastHeartbeatElapsedTimeMap.put(peer.getId().toString(), elapsedTime);
    }

    public Timer getFollowerAppendEntryTimer() {
        return this.registry.timer("follower_append_entry_latency");
    }

    public Timer getTimer(String timerName) {
        return this.registry.timer(timerName);
    }

    public Counter getCounter(String counterName) {
        return this.registry.counter(counterName);
    }

    public Timer getClientRequestTimer(RaftClientRequest request) {
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
            return this.getTimer(RAFT_CLIENT_READ_REQUEST);
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            return this.getTimer(RAFT_CLIENT_STALE_READ_REQUEST);
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            String watchType = RaftClientRequest.Type.toString(request.getType().getWatch().getReplication());
            return this.getTimer(String.format(RAFT_CLIENT_WATCH_REQUEST, watchType));
        }
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE)) {
            return this.getTimer(RAFT_CLIENT_WRITE_REQUEST);
        }
        return null;
    }

    public void onRetryRequestCacheHit() {
        this.registry.counter(RETRY_REQUEST_CACHE_HIT_COUNTER).inc();
    }

    public void onRequestQueueLimitHit() {
        this.registry.counter(REQUEST_QUEUE_LIMIT_HIT_COUNTER).inc();
    }

    void addNumPendingRequestsGauge(Gauge queueSize) {
        this.registry.gauge(REQUEST_QUEUE_SIZE, () -> queueSize);
    }

    void addNumPendingRequestsByteSize(Gauge byteSize) {
        this.registry.gauge(REQUEST_BYTE_SIZE, () -> byteSize);
    }

    void onRequestByteSizeLimitHit() {
        this.registry.counter(REQUEST_BYTE_SIZE_LIMIT_HIT_COUNTER).inc();
    }

    void onResourceLimitHit() {
        this.registry.counter(RESOURCE_LIMIT_HIT_COUNTER).inc();
    }

    @Override
    public RatisMetricRegistry getRegistry() {
        return this.registry;
    }
}

