/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.rpc;

import org.apache.ratis.conf.Parameters;
import org.apache.ratis.rpc.RpcFactory;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.util.ReflectionUtils;

public interface RpcType {
    public static RpcType valueOf(String rpcType) {
        try {
            return SupportedRpcType.valueOfIgnoreCase(rpcType);
        }
        catch (Throwable t) {
            Throwable fromSupportedRpcType = t;
            try {
                return ReflectionUtils.newInstance(ReflectionUtils.getClass(rpcType, RpcType.class));
            }
            catch (Throwable t2) {
                IllegalArgumentException iae = new IllegalArgumentException("Invalid " + RpcType.class.getSimpleName() + ": \"" + rpcType + "\"  cannot be used as a user-defined " + RpcType.class.getSimpleName() + " and it is not a " + SupportedRpcType.class.getSimpleName() + ".");
                iae.addSuppressed(t2);
                iae.addSuppressed(fromSupportedRpcType);
                throw iae;
            }
        }
    }

    public String name();

    public RpcFactory newFactory(Parameters var1);

    public static interface Get {
        public RpcType getRpcType();
    }
}

