/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Objects;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

public class RaftClientRequest
extends RaftClientMessage {
    private static final Type WRITE_DEFAULT = new Type(RaftProtos.WriteRequestTypeProto.getDefaultInstance());
    private static final Type WATCH_DEFAULT = new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(0L).setReplication(RaftProtos.ReplicationLevel.MAJORITY).build());
    private static final Type DEFAULT_READ = new Type(RaftProtos.ReadRequestTypeProto.getDefaultInstance());
    private static final Type DEFAULT_STALE_READ = new Type(RaftProtos.StaleReadRequestTypeProto.getDefaultInstance());
    private final long callId;
    private final Message message;
    private final Type type;
    private final RaftProtos.SlidingWindowEntry slidingWindowEntry;

    public static Type writeRequestType() {
        return WRITE_DEFAULT;
    }

    public static Type streamRequestType(long streamId, long messageId, boolean close) {
        return new Type(RaftProtos.StreamRequestTypeProto.newBuilder().setStreamId(streamId).setMessageId(messageId).setClose(close).build());
    }

    public static Type readRequestType() {
        return DEFAULT_READ;
    }

    public static Type staleReadRequestType(long minIndex) {
        return minIndex == 0L ? DEFAULT_STALE_READ : new Type(RaftProtos.StaleReadRequestTypeProto.newBuilder().setMinIndex(minIndex).build());
    }

    public static Type watchRequestType() {
        return WATCH_DEFAULT;
    }

    public static Type watchRequestType(long index, RaftProtos.ReplicationLevel replication) {
        return new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(index).setReplication(replication).build());
    }

    public static RaftClientRequest toWriteRequest(RaftClientRequest r, Message message) {
        return new RaftClientRequest(r.getClientId(), r.getServerId(), r.getRaftGroupId(), r.getCallId(), message, RaftClientRequest.writeRequestType(), r.getSlidingWindowEntry());
    }

    public RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Type type) {
        this(clientId, serverId, groupId, callId, null, type, null);
    }

    public RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Message message, Type type, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        super(clientId, serverId, groupId);
        this.callId = callId;
        this.message = message;
        this.type = type;
        this.slidingWindowEntry = slidingWindowEntry != null ? slidingWindowEntry : RaftProtos.SlidingWindowEntry.getDefaultInstance();
    }

    @Override
    public final boolean isRequest() {
        return true;
    }

    public long getCallId() {
        return this.callId;
    }

    public RaftProtos.SlidingWindowEntry getSlidingWindowEntry() {
        return this.slidingWindowEntry;
    }

    public Message getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public boolean is(RaftProtos.RaftClientRequestProto.TypeCase typeCase) {
        return this.getType().is(typeCase);
    }

    @Override
    public String toString() {
        return super.toString() + ", cid=" + this.callId + ", seq=" + ProtoUtils.toString(this.slidingWindowEntry) + ", " + this.type + ", " + this.getMessage();
    }

    public static final class Type {
        private final RaftProtos.RaftClientRequestProto.TypeCase typeCase;
        private final Object proto;

        public static Type valueOf(RaftProtos.WriteRequestTypeProto write) {
            return WRITE_DEFAULT;
        }

        public static Type valueOf(RaftProtos.ReadRequestTypeProto read) {
            return DEFAULT_READ;
        }

        public static Type valueOf(RaftProtos.StaleReadRequestTypeProto staleRead) {
            return staleRead.getMinIndex() == 0L ? DEFAULT_STALE_READ : new Type(staleRead);
        }

        public static Type valueOf(RaftProtos.WatchRequestTypeProto watch) {
            return RaftClientRequest.watchRequestType(watch.getIndex(), watch.getReplication());
        }

        public static Type valueOf(RaftProtos.StreamRequestTypeProto stream) {
            return RaftClientRequest.streamRequestType(stream.getStreamId(), stream.getMessageId(), stream.getClose());
        }

        private Type(RaftProtos.RaftClientRequestProto.TypeCase typeCase, Object proto) {
            this.typeCase = Objects.requireNonNull(typeCase, "typeCase == null");
            this.proto = Objects.requireNonNull(proto, "proto == null");
        }

        private Type(RaftProtos.WriteRequestTypeProto write) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, write);
        }

        private Type(RaftProtos.StreamRequestTypeProto stream) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.STREAM, stream);
        }

        private Type(RaftProtos.ReadRequestTypeProto read) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.READ, read);
        }

        private Type(RaftProtos.StaleReadRequestTypeProto staleRead) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD, staleRead);
        }

        private Type(RaftProtos.WatchRequestTypeProto watch) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, watch);
        }

        public boolean is(RaftProtos.RaftClientRequestProto.TypeCase tCase) {
            return this.getTypeCase().equals(tCase);
        }

        public RaftProtos.RaftClientRequestProto.TypeCase getTypeCase() {
            return this.typeCase;
        }

        public RaftProtos.WriteRequestTypeProto getWrite() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE));
            return (RaftProtos.WriteRequestTypeProto)this.proto;
        }

        public RaftProtos.StreamRequestTypeProto getStream() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.STREAM), () -> "proto = " + this.proto);
            return (RaftProtos.StreamRequestTypeProto)this.proto;
        }

        public RaftProtos.ReadRequestTypeProto getRead() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.READ));
            return (RaftProtos.ReadRequestTypeProto)this.proto;
        }

        public RaftProtos.StaleReadRequestTypeProto getStaleRead() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD));
            return (RaftProtos.StaleReadRequestTypeProto)this.proto;
        }

        public RaftProtos.WatchRequestTypeProto getWatch() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH));
            return (RaftProtos.WatchRequestTypeProto)this.proto;
        }

        public static String toString(RaftProtos.ReplicationLevel replication) {
            return replication == RaftProtos.ReplicationLevel.MAJORITY ? "" : "-" + replication;
        }

        public static String toString(RaftProtos.WatchRequestTypeProto w) {
            return "Watch" + Type.toString(w.getReplication()) + "(" + w.getIndex() + ")";
        }

        public static String toString(RaftProtos.StreamRequestTypeProto s2) {
            return "Stream" + s2.getStreamId() + "-" + s2.getMessageId() + (s2.getClose() ? "-close" : "");
        }

        public String toString() {
            switch (this.typeCase) {
                case WRITE: {
                    return "RW";
                }
                case STREAM: {
                    return Type.toString(this.getStream());
                }
                case READ: {
                    return "RO";
                }
                case STALEREAD: {
                    return "StaleRead(" + this.getStaleRead().getMinIndex() + ")";
                }
                case WATCH: {
                    return Type.toString(this.getWatch());
                }
            }
            throw new IllegalStateException("Unexpected request type: " + this.typeCase);
        }
    }
}

