/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NettyConfigKeys {
    public static final String PREFIX = "raft.netty";

    public static void main(String[] args) {
        ConfUtils.printAll(NettyConfigKeys.class);
    }

    public static interface Server {
        public static final Logger LOG = LoggerFactory.getLogger(Server.class);
        public static final String PREFIX = "raft.netty.server";
        public static final String PORT_KEY = "raft.netty.server.port";
        public static final int PORT_DEFAULT = 0;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).info(arg_0);
        }

        public static int port(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, PORT_KEY, 0, Server.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt(properties::setInt, PORT_KEY, port, new BiConsumer[0]);
        }
    }
}

