/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryFactory;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.MetricRegistryFactoryImpl;
import org.apache.ratis.metrics.impl.RefCountingMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistriesImpl
extends MetricRegistries {
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistriesImpl.class);
    private final List<Consumer<RatisMetricRegistry>> reporterRegistrations = new CopyOnWriteArrayList<Consumer<RatisMetricRegistry>>();
    private final MetricRegistryFactory factory;
    private final RefCountingMap<MetricRegistryInfo, RatisMetricRegistry> registries;

    public MetricRegistriesImpl() {
        this(new MetricRegistryFactoryImpl());
    }

    public MetricRegistriesImpl(MetricRegistryFactory factory) {
        this.factory = factory;
        this.registries = new RefCountingMap();
    }

    @Override
    public RatisMetricRegistry create(MetricRegistryInfo info) {
        return this.registries.put(info, () -> {
            if (this.reporterRegistrations.isEmpty()) {
                LOG.warn("First MetricRegistry has been created without registering reporters. You may need to call MetricRegistries.global().addReportRegistration(...) before.");
            }
            RatisMetricRegistry registry = this.factory.create(info);
            this.reporterRegistrations.forEach(reg -> reg.accept(registry));
            return registry;
        });
    }

    @Override
    public boolean remove(MetricRegistryInfo key) {
        return this.registries.remove(key) == null;
    }

    @Override
    public Optional<RatisMetricRegistry> get(MetricRegistryInfo info) {
        return Optional.ofNullable(this.registries.get(info));
    }

    @Override
    public Collection<RatisMetricRegistry> getMetricRegistries() {
        return Collections.unmodifiableCollection(this.registries.values());
    }

    @Override
    public void clear() {
        this.registries.clear();
    }

    @Override
    public Set<MetricRegistryInfo> getMetricRegistryInfos() {
        return Collections.unmodifiableSet(this.registries.keySet());
    }

    @Override
    public void addReporterRegistration(Consumer<RatisMetricRegistry> reporterRegistration) {
        this.reporterRegistrations.add(reporterRegistration);
    }
}

