/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GrpcConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcConfigKeys.class);
    public static final String PREFIX = "raft.grpc";
    public static final String MESSAGE_SIZE_MAX_KEY = "raft.grpc.message.size.max";
    public static final SizeInBytes MESSAGE_SIZE_MAX_DEFAULT = SizeInBytes.valueOf("64MB");
    public static final String FLOW_CONTROL_WINDOW_KEY = "raft.grpc.flow.control.window";
    public static final SizeInBytes FLOW_CONTROL_WINDOW_DEFAULT = SizeInBytes.valueOf("1MB");

    public static Consumer<String> getDefaultLog() {
        return arg_0 -> ((Logger)LOG).info(arg_0);
    }

    public static SizeInBytes messageSizeMax(RaftProperties properties, Consumer<String> logger) {
        return ConfUtils.getSizeInBytes(properties::getSizeInBytes, MESSAGE_SIZE_MAX_KEY, MESSAGE_SIZE_MAX_DEFAULT, logger, new BiConsumer[0]);
    }

    public static void setMessageSizeMax(RaftProperties properties, SizeInBytes maxMessageSize) {
        ConfUtils.setSizeInBytes(properties::set, MESSAGE_SIZE_MAX_KEY, maxMessageSize, new BiConsumer[0]);
    }

    public static SizeInBytes flowControlWindow(RaftProperties properties, Consumer<String> logger) {
        return ConfUtils.getSizeInBytes(properties::getSizeInBytes, FLOW_CONTROL_WINDOW_KEY, FLOW_CONTROL_WINDOW_DEFAULT, logger, new BiConsumer[0]);
    }

    public static void setFlowControlWindow(RaftProperties properties, SizeInBytes flowControlWindowSize) {
        ConfUtils.setSizeInBytes(properties::set, FLOW_CONTROL_WINDOW_KEY, flowControlWindowSize, new BiConsumer[0]);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(GrpcConfigKeys.class);
    }

    public static interface OutputStream {
        public static final Logger LOG = LoggerFactory.getLogger(OutputStream.class);
        public static final String PREFIX = "raft.grpc.outputstream";
        public static final String BUFFER_SIZE_KEY = "raft.grpc.outputstream.buffer.size";
        public static final SizeInBytes BUFFER_SIZE_DEFAULT = SizeInBytes.valueOf("64KB");
        public static final String RETRY_TIMES_KEY = "raft.grpc.outputstream.retry.times";
        public static final int RETRY_TIMES_DEFAULT = 5;
        public static final String RETRY_INTERVAL_KEY = "raft.grpc.outputstream.retry.interval";
        public static final TimeDuration RETRY_INTERVAL_DEFAULT = TimeDuration.valueOf(300L, TimeUnit.MILLISECONDS);
        public static final String OUTSTANDING_APPENDS_MAX_KEY = "raft.grpc.outputstream.outstanding.appends.max";
        public static final int OUTSTANDING_APPENDS_MAX_DEFAULT = 128;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).debug(arg_0);
        }

        public static SizeInBytes bufferSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, BUFFER_SIZE_KEY, BUFFER_SIZE_DEFAULT, OutputStream.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setBufferSize(RaftProperties properties, SizeInBytes bufferSize) {
            ConfUtils.setSizeInBytes(properties::set, BUFFER_SIZE_KEY, bufferSize, new BiConsumer[0]);
        }

        public static int retryTimes(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, RETRY_TIMES_KEY, 5, OutputStream.getDefaultLog(), ConfUtils.requireMin(1));
        }

        public static void setRetryTimes(RaftProperties properties, int retryTimes) {
            ConfUtils.setInt(properties::setInt, RETRY_TIMES_KEY, retryTimes, new BiConsumer[0]);
        }

        public static TimeDuration retryInterval(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(RETRY_INTERVAL_DEFAULT.getUnit()), RETRY_INTERVAL_KEY, RETRY_INTERVAL_DEFAULT, OutputStream.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setRetryInterval(RaftProperties properties, TimeDuration retryInterval) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, RETRY_INTERVAL_KEY, retryInterval, new BiConsumer[0]);
        }

        public static int outstandingAppendsMax(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, OUTSTANDING_APPENDS_MAX_KEY, 128, OutputStream.getDefaultLog(), ConfUtils.requireMin(0));
        }

        public static void setOutstandingAppendsMax(RaftProperties properties, int maxOutstandingAppends) {
            ConfUtils.setInt(properties::setInt, OUTSTANDING_APPENDS_MAX_KEY, maxOutstandingAppends, new BiConsumer[0]);
        }
    }

    public static interface Server {
        public static final Logger LOG = LoggerFactory.getLogger(Server.class);
        public static final String PREFIX = "raft.grpc.server";
        public static final String PORT_KEY = "raft.grpc.server.port";
        public static final int PORT_DEFAULT = 0;
        public static final String LEADER_OUTSTANDING_APPENDS_MAX_KEY = "raft.grpc.server.leader.outstanding.appends.max";
        public static final int LEADER_OUTSTANDING_APPENDS_MAX_DEFAULT = 128;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).info(arg_0);
        }

        public static int port(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, PORT_KEY, 0, Server.getDefaultLog(), ConfUtils.requireMin(0), ConfUtils.requireMax(65536));
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt(properties::setInt, PORT_KEY, port, new BiConsumer[0]);
        }

        public static int leaderOutstandingAppendsMax(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, LEADER_OUTSTANDING_APPENDS_MAX_KEY, 128, Server.getDefaultLog(), ConfUtils.requireMin(0));
        }

        public static void setLeaderOutstandingAppendsMax(RaftProperties properties, int maxAppend) {
            ConfUtils.setInt(properties::setInt, LEADER_OUTSTANDING_APPENDS_MAX_KEY, maxAppend, new BiConsumer[0]);
        }
    }

    public static interface TLS {
        public static final String PREFIX = "raft.grpc.tls";
        public static final String TLS_ENABLED_KEY = "raft.grpc.tls.enabled";
        public static final boolean TLS_ENABLED_DEFAULT = false;
        public static final String MUTUAL_AUTHN_ENABLED_KEY = "raft.grpc.tls.mutual_authn.enabled";
        public static final boolean MUTUAL_AUTHN_ENABLED_DEFAULT = false;
        public static final String PRIVATE_KEY_FILE_KEY = "raft.grpc.tls.private.key.file.name";
        public static final String PRIVATE_KEY_FILE_DEFAULT = "private.pem";
        public static final String CERT_CHAIN_FILE_KEY = "raft.grpc.tls.cert.chain.file.name";
        public static final String CERT_CHAIN_FILE_DEFAULT = "certificate.crt";
        public static final String TRUST_STORE_KEY = "raft.grpc.tls.trust.store";
        public static final String TRUST_STORE_DEFAULT = "ca.crt";
        public static final String CONF_PARAMETER = "raft.grpc.tls.conf";
        public static final Class<GrpcTlsConfig> CONF_CLASS = GrpcTlsConfig.class;

        public static boolean tlsEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, TLS_ENABLED_KEY, false, GrpcConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static boolean mutualAuthnEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean(properties::getBoolean, MUTUAL_AUTHN_ENABLED_KEY, false, GrpcConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static String getPrivateKeyFile(RaftProperties properties) {
            return ConfUtils.get(properties::get, PRIVATE_KEY_FILE_KEY, PRIVATE_KEY_FILE_DEFAULT, GrpcConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static String getCertChainFile(RaftProperties properties) {
            return ConfUtils.get(properties::get, CERT_CHAIN_FILE_KEY, CERT_CHAIN_FILE_DEFAULT, GrpcConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static String getTrustStore(RaftProperties properties) {
            return ConfUtils.get(properties::get, TRUST_STORE_KEY, TRUST_STORE_DEFAULT, GrpcConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static GrpcTlsConfig getConf(Parameters parameters) {
            return parameters != null ? parameters.get(CONF_PARAMETER, CONF_CLASS) : null;
        }

        public static void setConf(Parameters parameters, GrpcTlsConfig conf) {
            parameters.put(CONF_PARAMETER, conf, GrpcTlsConfig.class);
        }
    }
}

