/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.apache.ratis.client.ClientRetryEvent;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UnorderedAsync {
    public static final Logger LOG = LoggerFactory.getLogger(UnorderedAsync.class);

    public static CompletableFuture<RaftClientReply> send(RaftClientRequest.Type type, RaftClientImpl client) {
        long callId = RaftClientImpl.nextCallId();
        PendingUnorderedRequest pending = new PendingUnorderedRequest(() -> client.newRaftClientRequest(null, callId, null, type, null));
        UnorderedAsync.sendRequestWithRetry(pending, client);
        return pending.getReplyFuture().thenApply(reply -> RaftClientImpl.handleRaftException(reply, CompletionException::new));
    }

    public static void sendRequestWithRetry(RaftClientImpl.PendingClientRequest pending, RaftClientImpl client) {
        CompletableFuture<RaftClientReply> f = pending.getReplyFuture();
        if (f.isDone()) {
            return;
        }
        RaftClientRequest request = pending.newRequest();
        int attemptCount = pending.getAttemptCount();
        ClientId clientId = client.getId();
        LOG.debug("{}: attempt #{} send~ {}", new Object[]{clientId, attemptCount, request});
        client.getClientRpc().sendRequestAsyncUnordered(request).whenCompleteAsync((reply, e) -> {
            try {
                ClientRetryEvent event;
                LOG.debug("{}: attempt #{} receive~ {}", new Object[]{clientId, attemptCount, reply});
                RaftException replyException = reply != null ? reply.getException() : null;
                reply = client.handleLeaderException(request, (RaftClientReply)reply, null);
                if (reply != null) {
                    f.complete((RaftClientReply)reply);
                    return;
                }
                RetryPolicy retryPolicy = client.getRetryPolicy();
                RetryPolicy.Action action = retryPolicy.handleAttemptFailure(event = new ClientRetryEvent(attemptCount, request, replyException != null ? replyException : e));
                if (!action.shouldRetry()) {
                    f.completeExceptionally(client.noMoreRetries(event));
                    return;
                }
                if (e != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(clientId + ": attempt #" + attemptCount + " failed~ " + request, e);
                    } else {
                        LOG.debug("{}: attempt #{} failed {} with {}", new Object[]{clientId, attemptCount, request, e});
                    }
                    e = JavaUtils.unwrapCompletionException(e);
                    if (e instanceof IOException) {
                        if (e instanceof NotLeaderException) {
                            client.handleNotLeaderException(request, (NotLeaderException)e, null);
                            retryPolicy = ((NotLeaderException)e).getSuggestedLeader() != null ? RetryPolicies.retryForeverNoSleep() : retryPolicy;
                        } else {
                            if (e instanceof GroupMismatchException) {
                                f.completeExceptionally((Throwable)e);
                                return;
                            }
                            client.handleIOException(request, (IOException)e);
                        }
                    } else if (!client.getClientRpc().handleException(request.getServerId(), (Throwable)e, false)) {
                        f.completeExceptionally((Throwable)e);
                        return;
                    }
                }
                LOG.debug("schedule retry for attempt #{}, policy={}, request={}", new Object[]{attemptCount, retryPolicy, request});
                client.getScheduler().onTimeout(action.getSleepTime(), () -> UnorderedAsync.sendRequestWithRetry(pending, client), LOG, () -> clientId + ": Failed~ to retry " + request);
            }
            catch (Throwable t) {
                LOG.error(clientId + ": Failed " + request, t);
                f.completeExceptionally(t);
            }
        });
    }

    public static class PendingUnorderedRequest
    extends RaftClientImpl.PendingClientRequest {
        private final Supplier<RaftClientRequest> requestConstructor;

        PendingUnorderedRequest(Supplier<RaftClientRequest> requestConstructor) {
            this.requestConstructor = requestConstructor;
        }

        @Override
        RaftClientRequest newRequestImpl() {
            return this.requestConstructor.get();
        }
    }
}

