/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ratis.client.api.MessageOutputStream;
import org.apache.ratis.client.api.StreamApi;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamImpl
implements StreamApi {
    public static final Logger LOG = LoggerFactory.getLogger(StreamImpl.class);
    private final RaftClientImpl client;
    private final AtomicLong streamId = new AtomicLong();

    static StreamImpl newInstance(RaftClientImpl client, RaftProperties properties) {
        return new StreamImpl(client, properties);
    }

    private StreamImpl(RaftClientImpl client, RaftProperties properties) {
        this.client = Objects.requireNonNull(client, "client == null");
    }

    @Override
    public MessageOutputStream stream() {
        return new MessageOutputStreamImpl(this.streamId.incrementAndGet());
    }

    class MessageOutputStreamImpl
    implements MessageOutputStream {
        private final long id;
        private final AtomicLong messageId = new AtomicLong();

        MessageOutputStreamImpl(long id) {
            this.id = id;
        }

        @Override
        public CompletableFuture<RaftClientReply> sendAsync(Message message) {
            return StreamImpl.this.client.streamAsync(this.id, this.messageId.getAndIncrement(), message);
        }

        @Override
        public CompletableFuture<RaftClientReply> closeAsync() {
            return StreamImpl.this.client.streamCloseAsync(this.id, this.messageId.getAndIncrement());
        }
    }
}

