/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftClientConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(RaftClientConfigKeys.class);
    public static final String PREFIX = "raft.client";

    public static Consumer<String> getDefaultLog() {
        return arg_0 -> ((Logger)LOG).debug(arg_0);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(RaftClientConfigKeys.class);
    }

    public static interface Async {
        public static final String PREFIX = "raft.client.async";
        public static final String MAX_OUTSTANDING_REQUESTS_KEY = "raft.client.async.outstanding-requests.max";
        public static final int MAX_OUTSTANDING_REQUESTS_DEFAULT = 100;

        public static int maxOutstandingRequests(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, MAX_OUTSTANDING_REQUESTS_KEY, 100, RaftClientConfigKeys.getDefaultLog(), ConfUtils.requireMin(2));
        }

        public static void setMaxOutstandingRequests(RaftProperties properties, int outstandingRequests) {
            ConfUtils.setInt(properties::setInt, MAX_OUTSTANDING_REQUESTS_KEY, outstandingRequests, new BiConsumer[0]);
        }

        public static interface Experimental {
            public static final String PREFIX = "raft.client.async." + Experimental.class.getSimpleName().toLowerCase();
            public static final String SEND_DUMMY_REQUEST_KEY = PREFIX + ".send-dummy-request";
            public static final boolean SEND_DUMMY_REQUEST_DEFAULT = true;

            public static boolean sendDummyRequest(RaftProperties properties) {
                return ConfUtils.getBoolean(properties::getBoolean, SEND_DUMMY_REQUEST_KEY, true, RaftClientConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setSendDummyRequest(RaftProperties properties, boolean sendDummyRequest) {
                ConfUtils.setBoolean(properties::setBoolean, SEND_DUMMY_REQUEST_KEY, sendDummyRequest, new BiConsumer[0]);
            }
        }
    }

    public static interface Rpc {
        public static final String PREFIX = "raft.client.rpc";
        public static final String REQUEST_TIMEOUT_KEY = "raft.client.rpc.request.timeout";
        public static final TimeDuration REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf(3000L, TimeUnit.MILLISECONDS);
        public static final String WATCH_REQUEST_TIMEOUT_KEY = "raft.client.rpc.watch.request.timeout";
        public static final TimeDuration WATCH_REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf(10000L, TimeUnit.MILLISECONDS);

        public static TimeDuration requestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(REQUEST_TIMEOUT_DEFAULT.getUnit()), REQUEST_TIMEOUT_KEY, REQUEST_TIMEOUT_DEFAULT, RaftClientConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, REQUEST_TIMEOUT_KEY, timeoutDuration, new BiConsumer[0]);
        }

        public static TimeDuration watchRequestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(WATCH_REQUEST_TIMEOUT_DEFAULT.getUnit()), WATCH_REQUEST_TIMEOUT_KEY, WATCH_REQUEST_TIMEOUT_DEFAULT, RaftClientConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setWatchRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, WATCH_REQUEST_TIMEOUT_KEY, timeoutDuration, new BiConsumer[0]);
        }
    }
}

