/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.tukaani.xz.rangecoder;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.ozone.shaded.org.tukaani.xz.CorruptedInputException;
import org.apache.hadoop.ozone.shaded.org.tukaani.xz.rangecoder.RangeCoder;

public final class RangeDecoder
extends RangeCoder {
    private static final int INIT_SIZE = 5;
    private final byte[] buf;
    private int pos = 0;
    private int end = 0;
    private int range = 0;
    private int code = 0;

    public RangeDecoder(int n) {
        this.buf = new byte[n - 5];
    }

    public void prepareInputBuffer(DataInputStream dataInputStream, int n) throws IOException {
        if (n < 5) {
            throw new CorruptedInputException();
        }
        if (dataInputStream.readUnsignedByte() != 0) {
            throw new CorruptedInputException();
        }
        this.code = dataInputStream.readInt();
        this.range = -1;
        this.pos = 0;
        this.end = n - 5;
        dataInputStream.readFully(this.buf, 0, this.end);
    }

    public boolean isInBufferOK() {
        return this.pos <= this.end;
    }

    public boolean isFinished() {
        return this.pos == this.end && this.code == 0;
    }

    public void normalize() throws IOException {
        if ((this.range & 0xFF000000) == 0) {
            try {
                this.code = this.code << 8 | this.buf[this.pos++] & 0xFF;
                this.range <<= 8;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new CorruptedInputException();
            }
        }
    }

    public int decodeBit(short[] sArray, int n) throws IOException {
        int n2;
        this.normalize();
        short s2 = sArray[n];
        int n3 = (this.range >>> 11) * s2;
        if ((this.code ^ Integer.MIN_VALUE) < (n3 ^ Integer.MIN_VALUE)) {
            this.range = n3;
            sArray[n] = (short)(s2 + (2048 - s2 >>> 5));
            n2 = 0;
        } else {
            this.range -= n3;
            this.code -= n3;
            sArray[n] = (short)(s2 - (s2 >>> 5));
            n2 = 1;
        }
        return n2;
    }

    public int decodeBitTree(short[] sArray) throws IOException {
        int n = 1;
        while ((n = n << 1 | this.decodeBit(sArray, n)) < sArray.length) {
        }
        return n - sArray.length;
    }

    public int decodeReverseBitTree(short[] sArray) throws IOException {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        do {
            int n4 = this.decodeBit(sArray, n);
            n = n << 1 | n4;
            n3 |= n4 << n2++;
        } while (n < sArray.length);
        return n3;
    }

    public int decodeDirectBits(int n) throws IOException {
        int n2 = 0;
        do {
            this.normalize();
            this.range >>>= 1;
            int n3 = this.code - this.range >>> 31;
            this.code -= this.range & n3 - 1;
            n2 = n2 << 1 | 1 - n3;
        } while (--n != 0);
        return n2;
    }
}

