/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.tukaani.xz.lz;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.ozone.shaded.org.tukaani.xz.lz.BT4;
import org.apache.hadoop.ozone.shaded.org.tukaani.xz.lz.HC4;
import org.apache.hadoop.ozone.shaded.org.tukaani.xz.lz.Matches;

public abstract class LZEncoder {
    public static final int MF_HC4 = 4;
    public static final int MF_BT4 = 20;
    private final int keepSizeBefore;
    private final int keepSizeAfter;
    final int matchLenMax;
    final int niceLen;
    final byte[] buf;
    int readPos = -1;
    private int readLimit = -1;
    private boolean finishing = false;
    private int writePos = 0;
    private int pendingSize = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    static void normalize(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) {
                nArray[i] = 0;
                continue;
            }
            int n2 = i;
            nArray[n2] = nArray[n2] - n;
        }
    }

    private static int getBufSize(int n, int n2, int n3, int n4) {
        int n5 = n2 + n;
        int n6 = n3 + n4;
        int n7 = Math.min(n / 2 + 262144, 0x20000000);
        return n5 + n6 + n7;
    }

    public static int getMemoryUsage(int n, int n2, int n3, int n4, int n5) {
        int n6 = LZEncoder.getBufSize(n, n2, n3, n4) / 1024 + 10;
        switch (n5) {
            case 4: {
                n6 += HC4.getMemoryUsage(n);
                break;
            }
            case 20: {
                n6 += BT4.getMemoryUsage(n);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n6;
    }

    public static LZEncoder getInstance(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (n6) {
            case 4: {
                return new HC4(n, n2, n3, n4, n5, n7);
            }
            case 20: {
                return new BT4(n, n2, n3, n4, n5, n7);
            }
        }
        throw new IllegalArgumentException();
    }

    LZEncoder(int n, int n2, int n3, int n4, int n5) {
        this.buf = new byte[LZEncoder.getBufSize(n, n2, n3, n5)];
        this.keepSizeBefore = n2 + n;
        this.keepSizeAfter = n3 + n5;
        this.matchLenMax = n5;
        this.niceLen = n4;
    }

    public void setPresetDict(int n, byte[] byArray) {
        if (!$assertionsDisabled && this.isStarted()) {
            throw new AssertionError();
        }
        if (byArray != null) {
            int n2 = Math.min(byArray.length, n);
            int n3 = byArray.length - n2;
            System.arraycopy(byArray, n3, this.buf, 0, n2);
            this.skip(n2);
        }
    }

    private void moveWindow() {
        int n = this.readPos + 1 - this.keepSizeBefore & 0xFFFFFFF0;
        int n2 = this.writePos - n;
        System.arraycopy(this.buf, n, this.buf, 0, n2);
        this.readPos -= n;
        this.readLimit -= n;
        this.writePos -= n;
    }

    public int fillWindow(byte[] byArray, int n, int n2) {
        if (!$assertionsDisabled && this.finishing) {
            throw new AssertionError();
        }
        if (this.readPos >= this.buf.length - this.keepSizeAfter) {
            this.moveWindow();
        }
        if (n2 > this.buf.length - this.writePos) {
            n2 = this.buf.length - this.writePos;
        }
        System.arraycopy(byArray, n, this.buf, this.writePos, n2);
        this.writePos += n2;
        if (this.writePos >= this.keepSizeAfter) {
            this.readLimit = this.writePos - this.keepSizeAfter;
        }
        if (this.pendingSize > 0 && this.readPos < this.readLimit) {
            this.readPos -= this.pendingSize;
            int n3 = this.pendingSize;
            this.pendingSize = 0;
            this.skip(n3);
            if (!$assertionsDisabled && this.pendingSize >= n3) {
                throw new AssertionError();
            }
        }
        return n2;
    }

    public boolean isStarted() {
        return this.readPos != -1;
    }

    public void setFlushing() {
        this.readLimit = this.writePos - 1;
    }

    public void setFinishing() {
        this.readLimit = this.writePos - 1;
        this.finishing = true;
    }

    public boolean hasEnoughData(int n) {
        return this.readPos - n < this.readLimit;
    }

    public void copyUncompressed(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(this.buf, this.readPos + 1 - n, n2);
    }

    public int getAvail() {
        if (!$assertionsDisabled && !this.isStarted()) {
            throw new AssertionError();
        }
        return this.writePos - this.readPos;
    }

    public int getPos() {
        return this.readPos;
    }

    public int getByte(int n) {
        return this.buf[this.readPos - n] & 0xFF;
    }

    public int getByte(int n, int n2) {
        return this.buf[this.readPos + n - n2] & 0xFF;
    }

    public int getMatchLen(int n, int n2) {
        int n3;
        int n4 = this.readPos - n - 1;
        for (n3 = 0; n3 < n2 && this.buf[this.readPos + n3] == this.buf[n4 + n3]; ++n3) {
        }
        return n3;
    }

    public int getMatchLen(int n, int n2, int n3) {
        int n4;
        int n5 = this.readPos + n;
        int n6 = n5 - n2 - 1;
        for (n4 = 0; n4 < n3 && this.buf[n5 + n4] == this.buf[n6 + n4]; ++n4) {
        }
        return n4;
    }

    public boolean verifyMatches(Matches matches) {
        int n = Math.min(this.getAvail(), this.matchLenMax);
        for (int i = 0; i < matches.count; ++i) {
            if (this.getMatchLen(matches.dist[i], n) == matches.len[i]) continue;
            return false;
        }
        return true;
    }

    int movePos(int n, int n2) {
        if (!$assertionsDisabled && n < n2) {
            throw new AssertionError();
        }
        ++this.readPos;
        int n3 = this.writePos - this.readPos;
        if (!(n3 >= n || n3 >= n2 && this.finishing)) {
            ++this.pendingSize;
            n3 = 0;
        }
        return n3;
    }

    public abstract Matches getMatches();

    public abstract void skip(int var1);

    static {
        $assertionsDisabled = !LZEncoder.class.desiredAssertionStatus();
    }
}

