/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.rocksdb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.hadoop.ozone.shaded.org.rocksdb.util.Environment;

public class NativeLibraryLoader {
    private static final NativeLibraryLoader instance = new NativeLibraryLoader();
    private static boolean initialized = false;
    private static final String sharedLibraryName = Environment.getSharedLibraryName("rocksdb");
    private static final String jniLibraryName = Environment.getJniLibraryName("rocksdb");
    private static final String jniLibraryFileName = Environment.getJniLibraryFileName("rocksdb");
    private static final String tempFilePrefix = "librocksdbjni";
    private static final String tempFileSuffix = Environment.getJniLibraryExtension();

    public static NativeLibraryLoader getInstance() {
        return instance;
    }

    public synchronized void loadLibrary(String string) throws IOException {
        try {
            System.loadLibrary(sharedLibraryName);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary(jniLibraryName);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                this.loadLibraryFromJar(string);
            }
        }
    }

    void loadLibraryFromJar(String string) throws IOException {
        if (!initialized) {
            System.load(this.loadLibraryFromJarToTemp(string).getAbsolutePath());
            initialized = true;
        }
    }

    File loadLibraryFromJarToTemp(String string) throws IOException {
        File file;
        if (string == null || string.isEmpty()) {
            file = File.createTempFile(tempFilePrefix, tempFileSuffix);
        } else {
            file = new File(string, jniLibraryFileName);
            if (file.exists() && !file.delete()) {
                throw new RuntimeException("File: " + file.getAbsolutePath() + " already exists and cannot be removed.");
            }
            if (!file.createNewFile()) {
                throw new RuntimeException("File: " + file.getAbsolutePath() + " could not be created.");
            }
        }
        if (!file.exists()) {
            throw new RuntimeException("File " + file.getAbsolutePath() + " does not exist.");
        }
        file.deleteOnExit();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(jniLibraryFileName);){
            if (inputStream == null) {
                throw new RuntimeException(jniLibraryFileName + " was not found inside JAR.");
            }
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return file;
    }

    private NativeLibraryLoader() {
    }
}

